/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.OidTableViewLabelProvider;
import netjfwatcher.snmpmanager.OidTreeListener;
import netjfwatcher.snmptest.SnmpErrorTest;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;


/**
 * SNMP}l[WViewłSNMPR}hs\bh
 * NXłB
 * ȉ̂SnmpR}hs\bh܂B
 * EGetNext Command
 * ESet Request Command
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpCommandOperation {
    /* MO */
    private static Logger logger;

    /* SNMP V3}l[W */
    private SnmpV3ManagerConfigInfo info = null;

    /* Engine Sysup timetH[}bg */
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /* Report OID Description */
    private String reportOidDescription = "";

    /* SNMP Agent̉OIDɑΉOID Description */
    private String searchOidDescription = "";

    /* SNMP Agent̉OIDɑΉAccess^Cv */
    private String searchOidAccess = "";

    /*
     * SNMP}l[WViewłSNMPR}hs\bh
     * NXCX^X𐶐܂B
     */
    private SnmpCommandOperation() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP Agentɑ΂ GetRequests\bhłB
     * GetRequestsɃbZ[WBox\܂B
     *
     * @param dataHolder f[^z_[
     */
    public void getRequest(SnmpOperationDataHolder dataHolder) {
        int version = dataHolder.getSnmpVersion();

        // ^G[eXgs̃`FbN
        if (version == SnmpPreference.SNMPV3) {
            if (
                !SnmpErrorTest.getInstance().getManagerErrorControlCode()
                                  .equals(SnmpPreference.CORRECT_DESCRIPTION)) {
                logger.info(
                    "Error test : "
                    + SnmpErrorTest.getInstance().getManagerErrorControlCode());

                try {
                    /* ^eXgݒ肪G[ݒ̏ꍇɋ^G[
                     * iG[WFg̏ȂǁjZbg
                     */
                    setTestError(dataHolder);
                } catch (SnmpCommandErrorTestException e) {
                    /* ^eXgݒňُ킪ꍇ */
                    MessageBox alertMessageBox =
                        new MessageBox(
                            dataHolder.getViewSite().getShell(),
                            SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();

                    return;
                }
            }
        }

        String targetIPAddress = dataHolder.getTargetIP();
        String community = dataHolder.getRoCommunity();
        String oid = dataHolder.getTargetOid();
        ManagerDispatcher dispacher = null;

        try {
            String returnOid = oid;
            dispacher = new ManagerDispatcher();

            dispacher.setManagerDispatcher(targetIPAddress, community, version);

            SnmpVarBindList newVars =
                dispacher.dispathGetMessage(
                    version, SnmpBERCodec.SNMPGETREQUEST, returnOid);

            if (newVars == null) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        dataHolder.getViewSite().getShell(),
                        SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Abort MIB Get");
                alertMessageBox.open();

                return;
            }

            SnmpSequence responsePair =
                (SnmpSequence) (newVars.getSNMPObjectAt(0));
            SnmpObjectIdentifier responseOID =
                (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);


            AbstractSnmpObject responseValue = responsePair.getSNMPObjectAt(1);

            // String responseTypeString = responseValue.getTagCode();
            String responseTypeString = responseValue.getTagDescription();

            logger.info("Return OID :" + responseOID.toString());
            logger.info("Return responseValue :" + responseValue);
            logger.info("Return responseTypeString :" + responseTypeString);
            
            if (this.checkReportOID(responseOID.toString())) {
                String[] mib =
                    new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];
                mib[OidTableViewLabelProvider.OID_DESC] = reportOidDescription;
                mib[OidTableViewLabelProvider.OID] = responseOID.toString();
                mib[OidTableViewLabelProvider.VALUE] = responseValue.toString();
                mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
                findOidDescription(mib[OidTableViewLabelProvider.OID]);
                mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

                Table oidTable =
                    NetJFWatcherApplication.getOidTableView().getViewer()
                                           .getTable();
                TableItem item = new TableItem(oidTable, SWT.NULL);

                item.setText(mib);
                item.setData(mib);

            }

            String[] mib =
                new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];

            mib[OidTableViewLabelProvider.OID] = responseOID.toString();
            mib[OidTableViewLabelProvider.VALUE] = responseValue.toString();
            mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
            findOidDescription(mib[OidTableViewLabelProvider.OID]);
            mib[OidTableViewLabelProvider.OID_DESC] = searchOidDescription;
            mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

            Table oidTable =
                NetJFWatcherApplication.getOidTableView().getViewer().getTable();
            TableItem item = new TableItem(oidTable, SWT.NULL);

            item.setText(mib);
            item.setData(mib);
            returnOid = responseOID.toString();

            if (version == SnmpPreference.SNMPV3) {
                /*
                     * Snmp V3̏ꍇA̎挋ʂfĂł낤
                     * wAhXV3G[WFg擾
                     */
                info =
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(targetIPAddress);

                if (info != null) {
                    if (info.isLearned()) {
                        dataHolder.getAgentLearnedText().setText("Dicovery");
                    } else {
                        dataHolder.getAgentLearnedText().setText("Undiscovery");
                    }

                    if (
                        !(info.getSnmpEngineID() == null)
                            && !(info.getSnmpEngineID().equals(""))) {
                        dataHolder.getEngineIDText().setText(
                            "0x" + info.getSnmpEngineID());
                    } else {
                        dataHolder.getEngineIDText().setText("");
                    }

                    dataHolder.getEngineBootText().setText(
                        info.getSnmpEngineBoots());

                    long agentSnmpEngineTime = 0;
                    agentSnmpEngineTime =
                        Long.parseLong(info.getSnmpEngineTime());

                    Date agentDate = Calendar.getInstance().getTime();
                    agentDate.setTime(agentSnmpEngineTime);

                    dataHolder.getEngineSysUpTimeText().setText(
                        dateformat.format(agentDate));

                    if (
                        !SnmpErrorTest.getInstance().getManagerErrorControlCode()
                                          .equals(
                                SnmpPreference.CORRECT_DESCRIPTION)) {
                        /*
                         * ^G[w莞̏ꍇSnmp v3G[WFg
                         * 
                         */
                        info =
                            SnmpV3ManagerConfig.getInstance()
                                               .getResourceFileParse()
                                               .getSnmpV3AgentInfo(
                                dataHolder.getTargetIP());
                        info.setLearned(false);
                        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                           .updateSnmpV3ManagerConfigInfo(
                            dataHolder.getTargetIP(), info);
                        dataHolder.getAgentLearnedText().setText("Undiscovery");
                    }
                }
            }
        } catch (SnmpErrorStatusException e1) {
            /* bZ[WErrorXe[^Xُ̏ꍇ */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();

            /* ErrorXe[^Xُ̏ꍇɂ
             * printStackTrace()Ȃ
             */
        } catch (SnmpUnmuchRequestIDException e1) {
            /*
             * bZ[WRequestIDҒlƃA}b`
             * ̏ꍇ
             */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpUnmuchRequestMsgIDException e1) {
            /*
             * SNMP V3bZ[W msgIDҒlƃA}b`
             * ̏ꍇ
             */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (GeneralSecurityException e1) {
            /* SNMP V3 GeneralSecurityException̏ꍇ */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SocketException e1) {
            /* SNMPMSocketException */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpBadValueException e1) {
            /* SNMP bZ[W܂͉͂ňُ킪 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpConfigurationException e1) {
            /* SNMP\ǂݍ݂ňُ픭 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3ConfigurationException e1) {
            /* SNMP V3\ǂݍ݂ňُ픭 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3DecryptAbortException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3AuthAbortException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpMIBGetException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpSetException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (UnknownHostException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(
                "UnknownHostException : " + e1.getMessage());
            alertMessageBox.open();
        } catch (IOException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
        } finally {
            dispacher.closeConnection();
        }
    }

    /**
     * SNMP Agentɑ΂ GetNextRequests\bhłB
     * GetNextRequestsɃbZ[WBox\܂B
     *
     * @param dataHolder f[^z_[
     */
    public void getNextRequest(SnmpOperationDataHolder dataHolder) {
        int version = dataHolder.getSnmpVersion();

        // ^G[eXgs̃`FbN
        if (version == SnmpPreference.SNMPV3) {
            if (
                !SnmpErrorTest.getInstance().getManagerErrorControlCode()
                                  .equals(SnmpPreference.CORRECT_DESCRIPTION)) {
                logger.info(
                    "Error test : "
                    + SnmpErrorTest.getInstance().getManagerErrorControlCode());

                try {
                    /* ^eXgݒ肪G[ݒ̏ꍇɋ^G[
                     * iG[WFg̏ȂǁjZbg
                     */
                    setTestError(dataHolder);
                } catch (SnmpCommandErrorTestException e) {
                    /* ^eXgݒňُ킪ꍇ */
                    MessageBox alertMessageBox =
                        new MessageBox(
                            dataHolder.getViewSite().getShell(),
                            SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();

                    return;
                }
            }
        }

        String targetIPAddress = dataHolder.getTargetIP();
        String community = dataHolder.getRoCommunity();
        String oid = dataHolder.getTargetOid();
        ManagerDispatcher dispacher = null;

        try {
            String returnOid = oid;
            dispacher = new ManagerDispatcher();

            dispacher.setManagerDispatcher(targetIPAddress, community, version);

            while (true) {
                SnmpVarBindList newVars =
                    dispacher.dispathGetMessage(
                        version, SnmpBERCodec.SNMPGETNEXTREQUEST, returnOid);

                if (newVars == null) {
                    MessageBox alertMessageBox =
                        new MessageBox(
                            dataHolder.getViewSite().getShell(),
                            SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage("Abort MIB Get");
                    alertMessageBox.open();

                    return;
                }

                SnmpSequence responsePair =
                    (SnmpSequence) (newVars.getSNMPObjectAt(0));
                SnmpObjectIdentifier responseOID =
                    (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);
                logger.info("Return OID :" + responseOID.toString());

                AbstractSnmpObject responseValue =
                    responsePair.getSNMPObjectAt(1);

                // String responseTypeString = responseValue.getTagCode();
                String responseTypeString = responseValue.getTagDescription();

                if (this.checkReportOID(responseOID.toString())) {
                    String[] mib =
                        new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];
                    mib[OidTableViewLabelProvider.OID_DESC] =
                        reportOidDescription;
                    mib[OidTableViewLabelProvider.OID] = responseOID.toString();
                    mib[OidTableViewLabelProvider.VALUE] =
                        responseValue.toString();
                    mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
                    findOidDescription(mib[OidTableViewLabelProvider.OID]);
                    mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

                    Table oidTable =
                        NetJFWatcherApplication.getOidTableView().getViewer()
                                               .getTable();
                    TableItem item = new TableItem(oidTable, SWT.NULL);

                    item.setText(mib);
                    item.setData(mib);

                    break;
                }

                int checkOidPos = responseOID.toString().lastIndexOf(".");
                String workSearchOid = "";

                if (checkOidPos >= 0) {
                    workSearchOid =
                        responseOID.toString().substring(0, checkOidPos);
                }

                /* vOIDOIDɊ܂܂邩`FbNA܂܂ȂꍇBreak
                 * GetNextI
                 */
                if (workSearchOid.indexOf(oid) < 0) {
                    break;
                }

                String[] mib =
                    new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];

                mib[OidTableViewLabelProvider.OID] = responseOID.toString();
                mib[OidTableViewLabelProvider.VALUE] = responseValue.toString();
                mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
                findOidDescription(mib[OidTableViewLabelProvider.OID]);
                mib[OidTableViewLabelProvider.OID_DESC] = searchOidDescription;
                mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

                Table oidTable =
                    NetJFWatcherApplication.getOidTableView().getViewer()
                                           .getTable();
                TableItem item = new TableItem(oidTable, SWT.NULL);

                item.setText(mib);
                item.setData(mib);
                returnOid = responseOID.toString();
            }

            if (version == SnmpPreference.SNMPV3) {
                /*
                     * Snmp V3̏ꍇA̎挋ʂfĂł낤
                     * wAhXV3G[WFg擾
                     */
                info =
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(targetIPAddress);

                if (info != null) {
                    if (info.isLearned()) {
                        dataHolder.getAgentLearnedText().setText("Dicovery");
                    } else {
                        dataHolder.getAgentLearnedText().setText("Undiscovery");
                    }

                    if (
                        !(info.getSnmpEngineID() == null)
                            && !(info.getSnmpEngineID().equals(""))) {
                        dataHolder.getEngineIDText().setText(
                            "0x" + info.getSnmpEngineID());
                    } else {
                        dataHolder.getEngineIDText().setText("");
                    }

                    dataHolder.getEngineBootText().setText(
                        info.getSnmpEngineBoots());

                    long agentSnmpEngineTime = 0;
                    agentSnmpEngineTime =
                        Long.parseLong(info.getSnmpEngineTime());

                    Date agentDate = Calendar.getInstance().getTime();
                    agentDate.setTime(agentSnmpEngineTime);

                    dataHolder.getEngineSysUpTimeText().setText(
                        dateformat.format(agentDate));

                    if (
                        !SnmpErrorTest.getInstance().getManagerErrorControlCode()
                                          .equals(
                                SnmpPreference.CORRECT_DESCRIPTION)) {
                        /*
                         * ^G[w莞̏ꍇSnmp v3G[WFg
                         * 
                         */
                        info =
                            SnmpV3ManagerConfig.getInstance()
                                               .getResourceFileParse()
                                               .getSnmpV3AgentInfo(
                                dataHolder.getTargetIP());
                        info.setLearned(false);
                        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                           .updateSnmpV3ManagerConfigInfo(
                            dataHolder.getTargetIP(), info);
                        dataHolder.getAgentLearnedText().setText("Undiscovery");
                    }
                }
            }
        } catch (SnmpErrorStatusException e1) {
            /* bZ[WErrorXe[^Xُ̏ꍇ */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();

            /* ErrorXe[^Xُ̏ꍇɂ
             * printStackTrace()Ȃ
             */
        } catch (SnmpUnmuchRequestIDException e1) {
            /*
             * bZ[WRequestIDҒlƃA}b`
             * ̏ꍇ
             */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpUnmuchRequestMsgIDException e1) {
            /*
             * SNMP V3bZ[W msgIDҒlƃA}b`
             * ̏ꍇ
             */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (GeneralSecurityException e1) {
            /* SNMP V3 GeneralSecurityException̏ꍇ */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SocketException e1) {
            /* SNMPMSocketException */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpBadValueException e1) {
            /* SNMP bZ[W܂͉͂ňُ킪 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpConfigurationException e1) {
            /* SNMP\ǂݍ݂ňُ픭 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3ConfigurationException e1) {
            /* SNMP V3\ǂݍ݂ňُ픭 */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3DecryptAbortException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpV3AuthAbortException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpMIBGetException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (SnmpSetException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
            e1.printStackTrace();
        } catch (UnknownHostException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(
                "UnknownHostException : " + e1.getMessage());
            alertMessageBox.open();
        } catch (IOException e1) {
            /*  */
            MessageBox alertMessageBox =
                new MessageBox(
                    dataHolder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e1.getMessage());
            alertMessageBox.open();
        } finally {
            dispacher.closeConnection();
        }
    }

    /**
     * SNMP SetRequestAgentɑ΂Ďs郁\bhłB
     *
     * @param dataholder f[^z_[
     */
    public void setRequest(SnmpOperationDataHolder dataholder) {
        ManagerDispatcher dispacher = null;

        try {
            String rwCommunity = dataholder.getRwCommunity();
            int version = dataholder.getSnmpVersion();

            logger.info(
                "IP=" + dataholder.getTargetIP() + " version=" + version
                + " Community=" + rwCommunity);

            dispacher = new ManagerDispatcher();

            dispacher.setManagerDispatcher(
                dataholder.getTargetIP(), rwCommunity, version);

            String itemID = dataholder.getTargetOid();
            String valueString = dataholder.getSetValue();
            String valueTypeString = dataholder.getSetType();

            logger.info("valueTypeString = " + valueTypeString);

            AbstractSnmpObject itemValue =
                SnmpMappingTableController.getInstance().getSnmpObjectInstance(
                    valueTypeString);

            itemValue.setValue(valueString);

            SnmpVarBindList newVars =
                dispacher.dispathSetMessage(
                    version, SnmpBERCodec.SNMPSETREQUEST, itemID, itemValue);

            SnmpSequence responsePair =
                (SnmpSequence) (newVars.getSNMPObjectAt(0));
            SnmpObjectIdentifier responseOID =
                (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);

            /*
             * Snmp V3łSetRequestʁij|[gOIDimj`FbN
             */
            logger.info("Response OID = " + responseOID.toString());

            if (this.checkReportOID(responseOID.toString())) {
                /*
                 * Report ID
                 */
                logger.info(
                    "Report ID = " + responseOID.toString() + " : "
                    + reportOidDescription);

                AbstractSnmpObject responseValue =
                    responsePair.getSNMPObjectAt(1);

                // String responseTypeString = responseValue.getClass().getName();
                // String responseTypeString = responseValue.getTagCode();
                String responseTypeString = responseValue.getTagDescription();

                String[] mib =
                    new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];
                mib[OidTableViewLabelProvider.OID_DESC] = reportOidDescription;
                mib[OidTableViewLabelProvider.OID] = responseOID.toString();
                mib[OidTableViewLabelProvider.VALUE] = responseValue.toString();
                mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
                findOidDescription(mib[OidTableViewLabelProvider.OID]);
                mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

                Table oidTable =
                    NetJFWatcherApplication.getOidTableView().getViewer()
                                           .getTable();
                TableItem item = new TableItem(oidTable, SWT.NULL);

                item.setText(mib);
                item.setData(mib);
            } else {
                logger.info("Return OID = " + responseOID.toString());

                AbstractSnmpObject responseValue =
                    responsePair.getSNMPObjectAt(1);

                // String responseTypeString = responseValue.getClass().getName();
                // String responseTypeString = responseValue.getTagCode();
                String responseTypeString = responseValue.getTagDescription();

                String[] mib =
                    new String[OidTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];
                mib[OidTableViewLabelProvider.OID] = responseOID.toString();
                mib[OidTableViewLabelProvider.VALUE] = responseValue.toString();
                mib[OidTableViewLabelProvider.TYPE] = responseTypeString;
                findOidDescription(mib[OidTableViewLabelProvider.OID]);
                mib[OidTableViewLabelProvider.OID_DESC] = searchOidDescription;
                mib[OidTableViewLabelProvider.ACCESS] = searchOidAccess;

                Table oidTable =
                    NetJFWatcherApplication.getOidTableView().getViewer()
                                           .getTable();
                TableItem item = new TableItem(oidTable, SWT.NULL);

                item.setText(mib);
                item.setData(mib);
            }
        } catch (SnmpSetException e) {
            logger.warning(e.getMessage());

            MessageBox alertMessageBox =
                new MessageBox(
                    dataholder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e.getMessage());
            alertMessageBox.open();
            e.printStackTrace();
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());

            MessageBox alertMessageBox =
                new MessageBox(
                    dataholder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(
                "UnknownHostException : " + e.getMessage());
            alertMessageBox.open();
            e.printStackTrace();
        } catch (Exception e) {
            logger.warning(e.getMessage());

            MessageBox alertMessageBox =
                new MessageBox(
                    dataholder.getViewSite().getShell(),
                    SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(e.getMessage());
            alertMessageBox.open();
            e.printStackTrace();
        } finally {
            dispacher.closeConnection();
        }
    }

    /**
     * SNMP Agent̉OID|[gOIDۂ̃`FbNsA
     * |[gOID̏ꍇ́A|[gOIDɑΉDiscriptionZbg
     * ܂B
     * true:|[gOID̏ꍇ
     * false:|[gOIDłȂꍇ
     *
     * |[gOIDMIB OID`t@C͖`ƂĂ邽߂OID description
     * 𐶐AGUIɕ\邽߂ɂ̃\bhgp܂B
     *
     * @param checkOID OID
     * @return |[gOIDۂ̔tO
     * true:|[gOID̏ꍇ
     * false:|[gOIDłȂꍇ
     */
    public boolean checkReportOID(String checkOID) {
        boolean isCheckReportOID = false;
        reportOidDescription = "";

        if (checkOID.equals(SnmpPreference.UNSUPPORTED_SECURITY_LEVEL)) {
            reportOidDescription =
                SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.NOT_IN_TIME_PACKET)) {
            reportOidDescription =
                SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.UNKNOWN_USER_NAME)) {
            reportOidDescription = SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.UNKNOWN_ENGINE_ID)) {
            reportOidDescription = SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.WRONG_DIGEST)) {
            reportOidDescription = SnmpPreference.WRONG_DIGEST_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.DECRYPTION_ERROR)) {
            reportOidDescription = SnmpPreference.DECRYPTION_ERROR_DESCRIPTION;
            isCheckReportOID = true;
        }

        logger.info("isCheckReportOID = " + isCheckReportOID);
        logger.info("oidDescription = " + reportOidDescription);

        return isCheckReportOID;
    }

    /**
     * OIDɑΉDescriptionyAccessNXo[ɃZbg܂B
     * OIDɊYoidDescriptionȂꍇɂ́A
     * "unknown"Zbg܂B
     *
     * @param oid OID
     */
    public void findOidDescription(String oid) {
        searchOidDescription = "unknown";
        searchOidAccess = "unknown";

        int oidwork = oid.lastIndexOf(".");

        // String searchoid = mib[1].substring(0,oidwork); // OID̐擪Lʒu܂łpOIDƂėp
        //   CX^X
        String searchOid = oid.substring(0, oidwork);
        System.out.println("oidNext : " + oid.substring(0, oidwork));

        /*
         * oidkeyƂHashMap
         * key݂Ȃ΁Aoid̒ZčēxAkey݃`FbN
         * key݂܂oid̒ZĂ
         * key݂΂ɂHashMap MIB Nameget
         */
        for (int i = 0; i < oid.length(); i++) {
            if (
                ManagerMibTree.getInstance().getOidHashMap().containsKey(
                        searchOid)) {
                MibInfo miboid =
                    (MibInfo) ManagerMibTree.getInstance().getOidHashMap().get(
                        searchOid);
                searchOidDescription =
                    miboid.getDescrip()
                    + oid.substring(miboid.getOid().length(), oid.length());

                if (miboid.getAccess().equals(OidTreeListener.READ_ONLY_CODE)) {
                    searchOidAccess = OidTreeListener.READ_ONLY_DESCRIPTION;
                } else if (
                    miboid.getAccess().equals(OidTreeListener.READ_WRITE_CODE)) {
                    searchOidAccess = OidTreeListener.READ_WRITE_DESCRIPTION;
                } else {
                    searchOidAccess =
                        OidTreeListener.NOT_ACCESSIBLE_DESCRIPTION;
                }

                break;
            }

            searchOid = oid.substring(0, oidwork - i);
            System.out.println("oidworkPos - i : " + (oidwork - i));
            System.out.println("searchOid : " + searchOid);
        }
    }

    /**
     * ^G[ɂ́AG[ʖɏZbg܂B
     *
     * UG[WFgƒʏGetNextRequestsA
     * ̌ɁAݒ肳Ă^G[R[hɊăG[𔭐邽߂ɁA
     * G[WFg̏Ȃǂs܂B
     *
     *
     * @param dataholder
     */
    private void setTestError(SnmpOperationDataHolder dataholder)
        throws SnmpCommandErrorTestException {
        int version = dataholder.getSnmpVersion();
        String community = dataholder.getRoCommunity();
        String requestOID = dataholder.getTargetOid();
        ManagerDispatcher dispacher = null;

        try {
            dispacher = new ManagerDispatcher();

            dispacher.setManagerDispatcher(
                dataholder.getTargetIP(), community, version);

            dispacher.dispathGetMessage(
                version, SnmpBERCodec.SNMPGETNEXTREQUEST, requestOID);
        } catch (SnmpUnmuchRequestIDException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpUnmuchRequestMsgIDException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (GeneralSecurityException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpErrorStatusException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpBadValueException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpV3AuthAbortException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpV3DecryptAbortException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SocketException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpConfigurationException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpV3ConfigurationException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpMIBGetException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (SnmpSetException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } catch (IOException e) {
            logger.warning("Abort error test : " + e.getMessage());
            throw new SnmpCommandErrorTestException(
                "Abort error test : " + e.getMessage());
        } finally {
            dispacher.closeConnection();
        }

        info =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(dataholder.getTargetIP());

        String testCode =
            SnmpErrorTest.getInstance().getManagerErrorControlCode();
        logger.info("ErrorTest : " + testCode);

        /*
         * UAG[WFgƐʐMsɎw̃G[R[h
         * ɂċ^G[𔭐ʐMsB
         *
         */
        if (
            testCode.equals(
                    SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION)) {
            /* Unsuported security level */
            logger.info(
                "UNSUPPORTED_SECURITY_LEVEL : "
                + SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION);
            info.setLearned(false);

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            if (userInfo.getAuthPriv().equals(UsmUserManager.AUTHPRIV_NOAUTH)) {
                userInfo.setAuthPriv(UsmUserManager.AUTHPRIV_PRIV);
            } else if (
                userInfo.getAuthPriv().equals(UsmUserManager.AUTHPRIV_AUTH)) {
                userInfo.setAuthPriv(UsmUserManager.AUTHPRIV_NOAUTH);
            } else if (
                userInfo.getAuthPriv().equals(UsmUserManager.AUTHPRIV_PRIV)) {
                userInfo.setAuthPriv(UsmUserManager.AUTHPRIV_NOAUTH);
            }

            info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);
        } else if (
            testCode.equals(SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION)) {
            /* Not in time packet */
            info.setSnmpEngineBoots(Integer.toString(Integer.MAX_VALUE));
            info.setSnmpEngineTime(Integer.toString(Integer.MAX_VALUE));
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);
        } else if (
            testCode.equals(SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION)) {
            /* Unknown user name */
            logger.info(
                "UNKNOWN_USER_NAME : "
                + SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION);
            info.setLearned(false);

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            /* [UL蓾Ȃ̂ɃZbg */
            userInfo.setUsername("ABC DEF");
            info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);

            try {
                UsmUserManager.getInstance().registList(
                    new SnmpEngineID(info.getSnmpEngineID()), info);
            } catch (NumberFormatException e) {
                logger.warning(
                    "Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException(
                    "Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
            } catch (SnmpV3ConfigurationException e) {
                logger.warning(
                    "Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException(
                    "Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
            }
        } else if (
            testCode.equals(SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION)) {
            /* Unknown EngineID */
            logger.info(
                "UNKNOWN_ENGINEID : "
                + SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION);
            info.setLearned(true);
            info.setSnmpEngineID(Long.toString(Long.MAX_VALUE));
            info.setSnmpEngineBoots(Integer.toString(Integer.MAX_VALUE));
            info.setSnmpEngineTime(Integer.toString(Integer.MAX_VALUE));
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);

            try {
                UsmUserManager.getInstance().registList(
                    new SnmpEngineID(info.getSnmpEngineID()), info);
            } catch (NumberFormatException e) {
                logger.warning(
                    "Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException(
                    "Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
            } catch (SnmpV3ConfigurationException e) {
                logger.warning(
                    "Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException(
                    "Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
            }
        } else if (testCode.equals(SnmpPreference.WRONG_DIGEST_DESCRIPTION)) {
            /* Wrong digest */
            logger.info(
                "WRONG_DIGEST : " + SnmpPreference.WRONG_DIGEST_DESCRIPTION);

            logger.info(
                ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
                .getUsername());
            info.setLearned(false);

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            userInfo.setAuthPassPhrase("AUTHPASSPHRASE");

            info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);

            userInfo = (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);
            logger.info("AuthPassPhrase : " + userInfo.getAuthPassPhrase());
        } else if (testCode.equals(SnmpPreference.DECRYPTION_ERROR_DESCRIPTION)) {
            /* Decryption error */
            logger.info(
                "DECRYPTION_ERROR : "
                + SnmpPreference.DECRYPTION_ERROR_DESCRIPTION);

            logger.info(
                ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
                .getUsername());
            info.setLearned(false);

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            userInfo.setPrivPassPhrase("PRIVPASSPHRASE");

            info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateSnmpV3ManagerConfigInfo(
                dataholder.getTargetIP(), info);

            userInfo = (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);
            logger.info("PrivPassPhrase : " + userInfo.getPrivPassPhrase());
        } else {
            info =
                (SnmpV3ManagerConfigInfo) SnmpV3ManagerConfig.getInstance()
                                                             .getResourceFileParse()
                                                             .getSnmpV3AgentInfo(
                    dataholder.getTargetIP());
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpCommandOperation getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpCommandOperation RESOURCE = new SnmpCommandOperation();
    }
}
