/*
 * Created on 2004/12/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;


/**
 * GWSNMPvMIB𑗎M郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionStatisticsMibGet extends AbstractConnectionEngine {
    /**
     * GWSNMPvMIB𑗎M郁\bhNX
     * CX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionStatisticsMibGet(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * SNMPvMIB擾܂B
     *
     * @param mibControl SNMPvMIB
     * @return statisticsMib SNMPvMIB
    * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
    * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public StatisticsMibProperty getStatisticsMib(
        final StatisticsMibControl mibControl)
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setStatisticsMibControl(mibControl);
        commnadInfo.setCode(
            CommandMappingTableResource.STATISTICS_MIB_GET_COMMAND_ID);

        // GWƒʐMă\[X擾
        StatisticsMibProperty statisticsMib =
            (StatisticsMibProperty) this.communicationToEngine(commnadInfo);

        return statisticsMib;
    }
}
