/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;



/**
 * SNMP V1 SetRequestSet Valuẽ^CvݒR{Box̃Xi[
 * NXłB
 * IꂽSet Value^Cv̑Ilێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpV1ValueTypeSelection implements SelectionListener {
    /* MO */
    private static Logger logger;

    /* SNMP Value Type */
    private String snmpValueType;

    /*
     * SNMP V1 SetRequestSet Valuẽ^CvݒR{Box̃Xi[
     * NXCX^X𐶐܂B
     */
    private SnmpV1ValueTypeSelection() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP V1 SetRequestSet Valuẽ^CvݒR{Box̃Xi[
     * łB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        SnmpV1OperationView view = NetJFWatcherApplication.getSnmpV1OperationView();
        Combo snmpValueTypeCombo = view.getSnmpValueTypeCombo();

        int index = snmpValueTypeCombo.getSelectionIndex();
        snmpValueType = snmpValueTypeCombo.getItem(index);
        logger.info("Select Snmp V1 ValueType : " + snmpValueType);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.swt.events.
     * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent event) {
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpV1ValueTypeSelection getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * SNMP Value TypeԂ܂B
     *
     * @return snmpValueType SNMP Value Type
     */
    public String getSnmpValueType() {
        return snmpValueType;
    }

    /**
     * SNMP Value Typeݒ肵܂B
     *
     * @param snmpValueType SNMP Value Type
     */
    public void setSnmpValueType(String snmpValueType) {
        this.snmpValueType = snmpValueType;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpV1ValueTypeSelection RESOURCE =
            new SnmpV1ValueTypeSelection();
    }
}
