/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;


public class TrapForwardResourceFileParse {

	private static final String XML_FILE_VALUE = "value";

	private static final String ROOT = "root";

	private static final String FORWARD_FLAG = "forward_flag";

	private static final String FORWARD_ADDRESS = "forward_address";

	private static final String FILTER_OID = "filter_oid";

	private static final String ENTERPRISE_OID = "enterprise_oid";

	private String forwardFlag;
	private String forwardAddress; 

	private ArrayList<String> enterpriseOidList = new ArrayList<String>();
	
	private HashMap<String, String> enterpriseOidHashMap = new HashMap<String, String>();
	
	/* Logging */
	private static Logger logger = null;


	/**
	 * 
	 * wfBNgt@C͂ă\[Xێ܂B
	 * 
	 * @throws Exception
	 *             \[X͂Ɏsꍇ
	 */
	public TrapForwardResourceFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
		setTrapForwardInfo();
	}


	public void setTrapForwardInfo() {

		Document doc = null;

		// jart@C邩fBNgwt@C擾邩
		// doc = getDocument(TrapPreference.TRAP_FORWARD_CONF_FILE);
		doc = getResourceFileDocumentPath(TrapPreference.TRAP_FORWARD_CONF_FILE);

		if (doc == null) {
			logger.severe("Resource File Doc null ");

			return;
		}


		try {

			// rootvfo
			Element root = doc.getRootElement();
			Element forwardFlagEl = root.getChild(FORWARD_FLAG);
			Element forwardAddressEl = root.getChild(FORWARD_ADDRESS);
			Element filterOidEl = root.getChild(FILTER_OID);
			
			forwardFlag = forwardFlagEl
					.getAttributeValue(XML_FILE_VALUE);
			forwardAddress = forwardAddressEl
			.getAttributeValue(XML_FILE_VALUE);

			
			enterpriseOidList.clear();
			enterpriseOidHashMap.clear();
			List enterpriseOidElList = filterOidEl.getChildren(ENTERPRISE_OID);

			
			
			Iterator iterator = enterpriseOidElList.iterator();

			while (iterator.hasNext()) {

				Element enterpriseOidEl = (Element) iterator.next();
				
				String enterpriseOid = enterpriseOidEl.getAttributeValue(XML_FILE_VALUE);
				enterpriseOidList.add(enterpriseOid);				
				enterpriseOidHashMap.put(enterpriseOid, enterpriseOid);
				
			}
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter() {
		File f = new File(TrapPreference.TRAP_FORWARD_CONF_FILE);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(
					TrapPreference.TRAP_FORWARD_CONF_FILE);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {

			Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
			url = bundle.getEntry(file);

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("JDOMException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("NullPointerException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("IOException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * \[X񂩂Document𐶐AԂ܂B
	 * 
	 * @param updateResourceInfo
	 *            \[X
	 * @return Document
	 */
	public Document updateDocument(String forwardFlag, String forwardAddress, ArrayList oidList) {
		logger = Logger.getLogger(this.getClass().getName());

		Element rootElement = new Element(ROOT);
		Document doc = new Document(rootElement);

		Element forwardFlagEl = new Element(FORWARD_FLAG);
		Element forwardAddressEl = new Element(FORWARD_ADDRESS);
		Element filterOidEl = new Element(FILTER_OID);


		


		rootElement.addContent(forwardFlagEl);
		rootElement.addContent(forwardAddressEl);

		forwardFlagEl.setAttribute(new Attribute(XML_FILE_VALUE, forwardFlag));
		forwardAddressEl.setAttribute(new Attribute(XML_FILE_VALUE, forwardAddress));
		rootElement.addContent(filterOidEl);


		for (int i = 0; i < oidList.size(); i++) {
			Element enterpriseOidEl = new Element(ENTERPRISE_OID);
			filterOidEl.addContent(enterpriseOidEl);
			if((String)oidList.get(i) != null) {
			enterpriseOidEl.setAttribute(new Attribute(XML_FILE_VALUE, (String)oidList.get(i)));
			} else {
				enterpriseOidEl.setAttribute(new Attribute(XML_FILE_VALUE, ""));
			}
		}

		return doc;
	}
	
	
	
    
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static TrapForwardResourceFileParse getInstance() {
		return SingletonResource.TRAP_FORWARD_DEFINE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final TrapForwardResourceFileParse TRAP_FORWARD_DEFINE = new TrapForwardResourceFileParse();
	}

	public ArrayList<String> getEnterpriseOidList() {
		return enterpriseOidList;
	}



	public String getForwardAddress() {
		return forwardAddress;
	}



	public String getForwardFlag() {
		return forwardFlag;
	}


	public HashMap getEnterpriseOidHashMap() {
		return enterpriseOidHashMap;
	}
}
