/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.view.editorpart.alarm.EditorAllNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * XML SocketڑԂĎAA[oɃA[r[\ ^C}[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketConnectTimerProcessor implements Runnable {
	/* TimerN */
	public static final int TIMER = 1000;

	/* Timer~R[h */
	public static final int TIMER_STOP = -1;

	private TreeViewer engineListTreeViewer;

	private IWorkbenchPartSite engineListViewSite;

	/* GWAhXXg */
	private List detinationEngineAddressList;

	/* bZ[WXg */
	private List messageList;

	/* Display */
	private Display display;

	/* IEditorSite */
	private IEditorSite editorSite;

	private static int alamCount = 0;

	/**
	 * XML SocketMf[^i[L[IɊĎAe[u\ NXCX^X𐶐܂B
	 */
	public XMLSocketConnectTimerProcessor() {
		// nothing
	}

	public void run() {
		if (editorSite.getPage().isPartVisible(editorSite.getPart())) {

			detinationEngineAddressList.removeAll();
			java.util.List engineConnectList = XMLSocketConnectThread
					.getInstance().getEngineConnectList();
			for (int i = 0; i < engineConnectList.size(); i++) {
				detinationEngineAddressList.add((String) engineConnectList
						.get(i));
			}

			AlarmCodeInformation alarminfo = (AlarmCodeInformation) XMLSocketAlarmReceiveMessageQueue
					.getInstance().popXMLAlarmData();
			if (alarminfo != null) {
				alamCount++;
				String alarmMessage = Integer.toString(alamCount) + "  Engine="
						+ alarminfo.getEngineAddress() + "  Node="
						+ alarminfo.getIpaddress() + "  :  "
						+ alarminfo.getMessage();
				messageList.add(alarmMessage, 0);
			}
		}
		if (XMLSocketConnectThread.getInstance().isAccess()) {
			java.util.List connectThreadList = XMLSocketConnectThread
					.getInstance().getConnectThreadList();
			for (int j = 0; j < connectThreadList.size(); j++) {
				ConnectionEngineThread connectEngine = (ConnectionEngineThread) connectThreadList
						.get(j);
				/*
				 * XML SocketڑŃA[o`FbN
				 */
				if (connectEngine.isAlarm()) {

					/*
					 * A[oŃA[r[\
					 */
					connectEngine.setAlarm(false);
					setAlarmView(connectEngine.getEngineAddress());
				}
			}
		}

		if (engineListTreeViewer != null
				&& engineListViewSite.getPage().isPartVisible(
						engineListViewSite.getPart())) {
			// engineListView.setTreeViewer();
			engineListTreeViewer.refresh();
		}
		// ^C}[p
		display.timerExec(TIMER, this);
	}

	/*
	 * A[ʒmGW̃A[r[\܂B
	 * 
	 * @param engineAddress GWAhX
	 */
	private void setAlarmView(String engineAddress) {

		IWorkbench workbench = PlatformUI.getWorkbench();
		if (workbench == null) {
			return;
		}
		if (workbench.getActiveWorkbenchWindow() == null) {
			return;
		}
		ClientEngineInfo.getClientEngineInfoInstance().setEngineAddress(
				engineAddress);

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		try {
			/*
			 * EditorɃuEUI[v EditorID̓uEŨNX
			 */
			activePage.openEditor(new EditorInputNodeView(
					EditorAllNodeAlarm.TITLE_SUFFIX
							+ NetworkClientNodeTreeView
									.getTitleSuffixEngineAddress(), null, true,
					true), EditorAllNodeAlarm.class.getName());
		} catch (PartInitException e) {

			e.printStackTrace();
		}

	}

	/**
	 * IEditorSiteZbg܂B
	 * 
	 * @param editorSite
	 *            IEditorSite
	 */
	public void setEditorSite(IEditorSite editorSite) {
		this.editorSite = editorSite;
	}

	/**
	 * GWڑ\ListZbg܂B
	 * 
	 * @param detinationEngineAddressList
	 *            GWڑ\List
	 */
	public void setList(List detinationEngineAddressList, List messageList) {
		this.detinationEngineAddressList = detinationEngineAddressList;
		this.messageList = messageList;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static XMLSocketConnectTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final XMLSocketConnectTimerProcessor RESOURCE = new XMLSocketConnectTimerProcessor();
	}

	protected void finalize() throws java.lang.Throwable {

		super.finalize();
		display.timerExec(TIMER_STOP, this);
	}

	public void setEngineListTreeViewer(IWorkbenchPartSite engineListViewSite,
			TreeViewer engineListTreeViewer) {

		this.engineListViewSite = engineListViewSite;
		this.engineListTreeViewer = engineListTreeViewer;
	}
}
