/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.view;

import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.webbrowser.nodetree.NodeTreeListener;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;


/**
 * m[hTree View\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTreeView extends AbstractNodeTreeView {
    /* MO */
    private static Logger logger;

    /**
     * m[hTree ViewNXCX^X𐶐܂B
     *
     */
    public NodeTreeView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Webm[hĎ񃊃XgǂݍTree\
     * ܂B
     *
     */
    protected void initShow() {
        /*  ((ActionReloadNodeTreeHttp) actionNodeTree.
         * actionReloadNodeTreeHttp()).setNodeTree();
         */
        try {
            setStatusLine();
        } catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    /**
     * m[hTree View̑IXi[ݒ肵܂B
     *
     */
    public void setupNodeTreeViewListener() {
        /*
         * Node Tree ViewɃXi[o^
         * Xi[̏ƂẮA
         * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
         *
         */
        nodeListTreeViewer.addSelectionChangedListener(new NodeTreeListener());
    }

    /**
     * ReLXgj[𐶐܂B
     *
     */
    public void createContextMenu() {
        /* j[}l[W */
        MenuManager mm = new MenuManager();

        /*  */
        mm.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);

                    try {
                        setStatusLine();
                    } catch (HttpAccessPreferenceException e) {
                        e.printStackTrace();
                    }
                }
            });

        Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
        nodeListTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, nodeListTreeViewer);
    }

    /*
     * Xe[^XC\Zbg܂B
     */
    private void setStatusLine() throws HttpAccessPreferenceException {
        /* Xe[^XC\L */
        SubStatusLineManager statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        statusLineManager.setMessage(
            "Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    /**
     * j[o[ݒ肵܂B
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /* m[hTreeǂݍ݃ANVZbg */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* m[hTreeǂݍ݃ANVMenuManagerɃZbg */
        manager.add(actionNodeTree.actionReloadNodeTreeHttp());

        /* m[hTree\[gANVMenuManagerɃZbg */
        manager.add(actionNodeTree.actionSortNodeTreeHttp());

        /* SĂEditorPartcloseANVMenuManagerɃZbg */
        manager.add(actionBuilderEditorPart.actionCloseAllEditors());
    }

    /**
     * ANV̏ƂToolBarݒ肵܂B
     *
     */
    public void setToolBarActions() {
        /* ToolBarݒ */
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        /* m[hTreeēǍANV */
        toolBarManager.add(
            getActionNodeTreeBuilder().actionReloadNodeTreeHttp());

        /* m[hTree sort */
        toolBarManager.add(getActionNodeTreeBuilder().actionSortNodeTreeHttp());

        /* Editor part close */
        toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
    }
}
