/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.trap.AlarmTrapResourceFileParse;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class AlarmSnmpTrapPreferencePage
extends AbstractSnmpPreferencePage {
    public static final String TRAP_FLAG_TRUE = "true";
    public static final String TRAP_FLAG_FALSE = "false";
    private static final int TEXT_WIDTH = 200;
    private static final int COMBO_WIDTH = 120;
    private static final int HORIZONTAL_SPAN2 = 2;
    private static final int HORIZONTAL_SPAN3 = 3;
    private Button alarmTrapButton;
    private Text destinationAddressText;
    private Combo alarmLevelCombo;
    private static Logger logger;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected Control createContents(Composite parent) {
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        Composite composite0 = new Composite(parent, 0);
        GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
        composite0.setLayout((Layout)gridLayoutV3AgentProp);
        composite0.setLayoutData((Object)new GridData(256));
        this.alarmTrapButton = new Button(composite0, 32);
        this.alarmTrapButton.setText("Alarm Trap");
        Label label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Trap Server Address");
        label.setLayoutData((Object)new GridData());
        this.destinationAddressText = new Text(composite0, 2048);
        this.destinationAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.destinationAddressText.setBackground(this.textBackColor);
        this.destinationAddressText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Alarm level filter");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmLevelCombo = new Combo(composite0, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.alarmLevelCombo.setLayoutData((Object)gridData);
        this.alarmLevelCombo.add("INFO");
        this.alarmLevelCombo.add("WARNING");
        this.alarmLevelCombo.add("ERROR");
        this.alarmLevelCombo.select(0);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        Composite entryTable = new Composite(parent, 0);
        entryTable.setLayoutData((Object)new GridData(768));
        this.setSelectionListener();
        this.setText();
        return entryTable;
    }

    private void setText() {
        String forwardFlag = AlarmTrapResourceFileParse.getInstance().getAlarmTrapFlag();
        if (forwardFlag.equals(TRAP_FLAG_TRUE)) {
            this.alarmTrapButton.setSelection(true);
        } else {
            this.alarmTrapButton.setSelection(false);
        }
        String forwardAddress = AlarmTrapResourceFileParse.getInstance().getServerAddress();
        this.destinationAddressText.setText(forwardAddress);
        if (this.alarmTrapButton.getSelection()) {
            this.destinationAddressText.setEnabled(true);
        } else {
            this.destinationAddressText.setEnabled(false);
        }
    }

    private void setSelectionListener() {
        this.alarmTrapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (AlarmSnmpTrapPreferencePage.this.alarmTrapButton.getSelection()) {
                    AlarmSnmpTrapPreferencePage.this.destinationAddressText.setEnabled(true);
                } else {
                    AlarmSnmpTrapPreferencePage.this.destinationAddressText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected void performDefaults() {
        this.setText();
    }

    public boolean performOk() {
        String trapFlag = TRAP_FLAG_TRUE;
        if (!this.alarmTrapButton.getSelection()) {
            trapFlag = TRAP_FLAG_FALSE;
        }
        String trapAddress = "";
        if (trapFlag.equals(TRAP_FLAG_TRUE)) {
            trapAddress = this.destinationAddressText.getText();
            String localHostAddress = "";
            try {
                InetAddress host = InetAddress.getByName(trapAddress);
                trapAddress = host.getHostAddress();
                localHostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("UnknownHostException IP Address = " + trapAddress));
                this.destinationAddressText.setFocus();
                return false;
            }
            if (trapAddress == null || trapAddress.equals("") || trapAddress.equals("127.0.0.1") || trapAddress.equals(localHostAddress)) {
                MessageDialog.openError((Shell)this.getShell().getShell(), (String)"Error", (String)"Illegal IP Address");
                this.destinationAddressText.setFocus();
                return false;
            }
        }
        String trapLevel = this.alarmLevelCombo.getText();
        this.saveAlarmTrapInfo(trapFlag, trapAddress, trapLevel);
        return super.performOk();
    }

    private void saveAlarmTrapInfo(String trapFlag, String trapAddress, String trapLevel) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateAlarmTrapResource(trapFlag, trapAddress, trapLevel);
        if (dom == null) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort save Alarm Trap config");
            shell.dispose();
            return;
        }
        bufWriter = AlarmTrapResourceFileParse.getInstance().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for Alarm Trap resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        AlarmTrapResourceFileParse.getInstance().setTrapForwardInfo();
    }

    private Document updateAlarmTrapResource(String trapFlag, String trapAddress, String trapLevel) {
        Document dom = AlarmTrapResourceFileParse.getInstance().updateDocument(trapFlag, trapAddress, trapLevel);
        return dom;
    }
}

