/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.holdperiod;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;

public final class ThreadPeriodHoldCheck
implements Runnable {
    public static final long WATCH_PERIOD = 60000L;
    private static final long DIFF = 86400000L;
    private static final int WAIT_COUNT = 5;
    private static Logger logger = null;
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SystemResourceFileParse resourceset;
    private Thread periodHoldCheckThread;
    private boolean isLoop = true;

    private ThreadPeriodHoldCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startThread() {
        this.periodHoldCheckThread = new Thread(SingletonResource.RESOURCE);
        this.periodHoldCheckThread.start();
        int wait = 0;
        while (!this.periodHoldCheckThread.isAlive()) {
            if (++wait >= 5) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopReceiving() {
        if (this.periodHoldCheckThread == null) {
            return;
        }
        this.periodHoldCheckThread.interrupt();
        while (this.periodHoldCheckThread != null && this.periodHoldCheckThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Stop pperiod hold check Thread " + e.getMessage());
                break;
            }
        }
        logger.info("PeriodHold Check Thread stop");
        this.periodHoldCheckThread = null;
    }

    public void run() {
        while (this.isLoop) {
            try {
                Thread.sleep(60000L);
                this.checkData();
            }
            catch (InterruptedException e) {
                logger.info("Stop pperiod hold check Thread " + e.getMessage());
                break;
            }
            catch (DatabaseConnectionException e3) {
                logger.warning(e3.getMessage());
                e3.printStackTrace();
                break;
            }
            catch (SQLException e3) {
                logger.warning(e3.getMessage());
                e3.printStackTrace();
                break;
            }
        }
    }

    private void checkData() throws DatabaseConnectionException, SQLException {
        long lineNo = 0L;
        this.resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        lineNo = Long.parseLong(this.resourceset.getResourceInfo().getAlarmMax());
        if (lineNo > 0L) {
            this.checkDataMaxLine("alarm_table", "alarm_date", lineNo);
        }
        Date date = Calendar.getInstance().getTime();
        long nowdate = date.getTime();
        long alarmHoldPeriod = 0L;
        long statisticsHoldPeriod = 0L;
        alarmHoldPeriod = Long.parseLong(this.resourceset.getResourceInfo().getAlarmHoldPeriodDay());
        if (alarmHoldPeriod != 0L) {
            long diff = 86400000L * alarmHoldPeriod;
            Date validDate = Calendar.getInstance().getTime();
            validDate.setTime(nowdate - diff);
            this.checkAlarmPeriodDate(validDate);
        }
        statisticsHoldPeriod = Long.parseLong(this.resourceset.getResourceInfo().getStatisticsHoldPeriodDay());
        Date validDate = null;
        if (statisticsHoldPeriod != 0L) {
            long diff = 86400000L * statisticsHoldPeriod;
            validDate = Calendar.getInstance().getTime();
            validDate.setTime(nowdate - diff);
        }
        lineNo = 0L;
        this.resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        lineNo = Long.parseLong(this.resourceset.getResourceInfo().getStatisticsMax());
        this.checkStatisticsTable(validDate, lineNo);
    }

    private void checkAlarmPeriodDate(Date checkDate) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                String sql = "SELECT * from alarm_table where alarm_date <= '" + this.dateformat.format(checkDate) + "'";
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    System.out.print(String.valueOf(rs.getObject("alarm_date").toString()) + "  ");
                    System.out.println(rs.getObject("alarm_message").toString());
                }
                sql = "DELETE from alarm_table where alarm_date <= '" + this.dateformat.format(checkDate) + "'";
                stmt.execute(sql);
            }
            catch (DatabaseConnectionException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
        }
        if (dataaccess != null) {
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
    }

    private void checkDataMaxLine(String tableName, String columnName, long limitLineNo) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        long lineCount = 0L;
        String sql = "";
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                sql = "select count(*) from " + tableName;
                rs = stmt.executeQuery(sql);
                rs.next();
                long count = -1L;
                lineCount = count = rs.getLong(1);
                if (lineCount > limitLineNo) {
                    sql = "SELECT * from " + tableName + " order by " + columnName + " desc";
                    rs = stmt.executeQuery(sql);
                    ArrayList<String> alarmIDList = new ArrayList<String>();
                    while (rs.next()) {
                        alarmIDList.add(rs.getObject("id").toString());
                    }
                    int i = 0;
                    while (i < alarmIDList.size()) {
                        if ((long)i >= limitLineNo) {
                            sql = "DELETE from " + tableName + " where " + "id" + " = '" + alarmIDList.get(i) + "'";
                            stmt.execute(sql);
                        }
                        ++i;
                    }
                }
            }
            catch (DatabaseConnectionException ex) {
                logger.warning("DatabaseConnectionException SQL=" + sql + " " + ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                logger.warning("SQLException SQL=" + sql + " " + ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }

    public void checkStatisticsTable(Date checkDate, long limitLineNo) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "";
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                sql = "SELECT * from tableManagement where limit_check='yes'";
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String tableName = rs.getObject("table_name").toString();
                    if (checkDate != null) {
                        sql = "DELETE from " + tableName + " " + "where " + "curdate" + " <= '" + this.dateformat.format(checkDate) + "'";
                        dataaccess.executeUpdate(sql);
                    }
                    if (limitLineNo <= 0L) continue;
                    this.checkDataMaxLine(tableName, "curdate", limitLineNo);
                }
            }
            catch (DatabaseConnectionException ex) {
                logger.warning("DatabaseConnectionException SQL=" + sql + " " + ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                logger.warning("SQLException SQL=" + sql + " " + ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }

    public static ThreadPeriodHoldCheck getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Thread getPeriodHoldCheckThread() {
        return this.periodHoldCheckThread;
    }

    /* synthetic */ ThreadPeriodHoldCheck(ThreadPeriodHoldCheck threadPeriodHoldCheck) {
        this();
    }

    private static class SingletonResource {
        static final ThreadPeriodHoldCheck RESOURCE = new ThreadPeriodHoldCheck(null);

        private SingletonResource() {
        }
    }
}

