/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.snmpmanager.process.AbstractManagerMessageProcessingSubsystem;
import netjfwatcher.engine.snmpmanager.process.ManagerV1MP;
import netjfwatcher.engine.snmpmanager.process.ManagerV2MP;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MP;

public final class ManagerMPQueue {
    private static Map flyweightMap = Collections.synchronizedMap(new HashMap());
    private static Logger logger;

    private ManagerMPQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized AbstractManagerMessageProcessingSubsystem popQueue(String addressKey, int version) {
        String versionString = Integer.toString(version);
        if (flyweightMap.containsKey(String.valueOf(addressKey) + versionString)) {
            return (AbstractManagerMessageProcessingSubsystem)flyweightMap.get(String.valueOf(addressKey) + versionString);
        }
        AbstractManagerMessageProcessingSubsystem mp = null;
        switch (version) {
            case 0: {
                mp = new ManagerV1MP();
                break;
            }
            case 1: {
                mp = new ManagerV2MP();
                break;
            }
            case 3: {
                mp = new ManagerV3MP();
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
                return null;
            }
        }
        flyweightMap.put(String.valueOf(addressKey) + versionString, mp);
        return mp;
    }

    public synchronized void removeMP(String addressKey) {
        flyweightMap.remove(addressKey);
    }

    public static ManagerMPQueue getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /* synthetic */ ManagerMPQueue(ManagerMPQueue managerMPQueue) {
        this();
    }

    private static class SingletonAboutMessage {
        static final ManagerMPQueue DBPOOL = new ManagerMPQueue(null);

        private SingletonAboutMessage() {
        }
    }
}

