/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class GarbageCollectionView
extends ViewPart {
    private static final int TEXT_WIDTH = 200;
    private static final String ALIVE = "Alive";
    private static final String NOALIVE = "No Alive";
    private static final int DEFAULT_INTERVAL_TIME = 60000;
    private static Logger logger;
    private static final float COLUMN0_DATE_RATIO = 0.15f;
    private static final float COLUMN1_DATA_RATIO = 0.15f;
    private Text treadStateText;
    private Text treadIntervalText;
    private Text maxMemoryText;
    private Text totalDataCountText;
    private Text collectStartDateText;
    private Text collectEndDateText;
    private Text freeMemoryMinDataText;
    private Text freeMemoryMaxDataText;
    private Text totalMemoryMinDataText;
    private Text totalMemoryMaxDataText;
    private Button startButton;
    private Button stopButton;
    private Button refreshButton;
    private TableViewer viewer;
    private Table memoryTable;
    private ActionBuilderChart nodeChart = new ActionBuilderChart();
    private ArrayList dateList = new ArrayList();
    private ArrayList freeMemoryDataList = new ArrayList();
    private ArrayList totalMemoryDataList = new ArrayList();
    private ArrayList dataListList = new ArrayList();
    private ArrayList nameList = new ArrayList();
    private String[] maxData = new String[2];
    private String[] minData = new String[2];
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();
    private ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

    public GarbageCollectionView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 16384);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(2));
        gridLayout0 = new GridLayout(2, false);
        Composite subBaseComposite = new Composite(baseComposite, 16384);
        subBaseComposite.setLayout((Layout)gridLayout0);
        subBaseComposite.setLayoutData((Object)new GridData(2));
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite leftComposite = new Composite(subBaseComposite, 16384);
        leftComposite.setLayout((Layout)gridLayout);
        leftComposite.setLayoutData((Object)new GridData(2));
        gridData = new GridData();
        gridLayout = new GridLayout(1, true);
        Composite rightComposite = new Composite(subBaseComposite, 4);
        rightComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(272);
        rightComposite.setLayoutData((Object)gridData);
        this.refreshButton = new Button(leftComposite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData());
        Label label = new Label(leftComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startButton = new Button(leftComposite, 0);
        this.startButton.setText("Start");
        this.startButton.setLayoutData((Object)new GridData());
        label = new Label(leftComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.stopButton = new Button(leftComposite, 0);
        this.stopButton.setText("Stop ");
        this.stopButton.setLayoutData((Object)new GridData());
        label = new Label(leftComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Thread state");
        label.setLayoutData((Object)new GridData(2));
        this.treadStateText = new Text(leftComposite, 2048);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.treadStateText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Thread Interval(sec)");
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        this.treadIntervalText = new Text(leftComposite, 2048);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.treadIntervalText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Max memory");
        label.setLayoutData((Object)new GridData());
        this.maxMemoryText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.maxMemoryText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Total data count");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.totalDataCountText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.totalDataCountText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Start date");
        label.setLayoutData((Object)new GridData());
        this.collectStartDateText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.collectStartDateText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("End date");
        label.setLayoutData((Object)new GridData());
        this.collectEndDateText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.collectEndDateText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Free memory max data");
        label.setLayoutData((Object)new GridData());
        this.freeMemoryMaxDataText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.freeMemoryMaxDataText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Free memory min data");
        label.setLayoutData((Object)new GridData());
        this.freeMemoryMinDataText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.freeMemoryMinDataText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Total memory max data");
        label.setLayoutData((Object)new GridData());
        this.totalMemoryMaxDataText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.totalMemoryMaxDataText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Total memory min data");
        label.setLayoutData((Object)new GridData());
        this.totalMemoryMinDataText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.totalMemoryMinDataText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GarbageCollectionDataTable statisticsTable = new GarbageCollectionDataTable();
        this.memoryTable = statisticsTable.createTable(rightComposite);
        this.viewer = new TableViewer(this.memoryTable);
        this.viewer.setUseHashlookup(true);
        this.setInitText();
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(800, 400);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GarbageCollectionView.this.refreshButton.setEnabled(false);
                GarbageCollectionView.this.getGarbageCollection();
                GarbageCollectionView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GarbageCollectionView.this.startButton.setEnabled(false);
                GarbageCollectionView.this.startGarbageCollection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GarbageCollectionView.this.stopButton.setEnabled(false);
                GarbageCollectionView.this.stopGarbageCollection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.createContextMenu();
        this.fillActionBars();
    }

    private void setInitText() {
        this.treadIntervalText.setText("60");
        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            this.treadStateText.setText(ALIVE);
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        } else {
            this.treadStateText.setText(NOALIVE);
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        this.maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GarbageCollectionView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        String title = "GarbageCollection  Chart";
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setTitle(title);
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setMaxData(this.maxData);
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setMinData(this.minData);
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setDateList(this.dateList);
        this.dataListList.clear();
        this.dataListList.add(this.freeMemoryDataList);
        this.dataListList.add(this.totalMemoryDataList);
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setDataList(this.dataListList);
        this.nameList.clear();
        this.nameList.add("Free memory");
        this.nameList.add("Total memory");
        ((ActionBuilderChart.ActionGarbageCollectionView)this.nodeChart.getActionGarbageCollectionView()).setNameList(this.nameList);
        manager.add(this.nodeChart.getActionGarbageCollectionView());
    }

    private void startGarbageCollection() {
        GarbageCollectionControl garbageControl = new GarbageCollectionControl();
        logger.info("GarbageCollection start");
        DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();
        try {
            try {
                gar.createTable();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            gar = null;
        }
        int intervalTime = 60000;
        intervalTime = Integer.parseInt(this.treadIntervalText.getText()) * 1000;
        GarbageCollectionMemoryJVM.getInstance().setSleepTime(intervalTime);
        GarbageCollectionMemoryJVM.getInstance().startThread();
        garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
        garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            this.treadStateText.setText(ALIVE);
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        } else {
            this.treadStateText.setText(NOALIVE);
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        this.maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    private void getGarbageCollection() {
        GarbageCollectionControl garbageControl = null;
        ArrayList garbageCollectionDataList = null;
        logger.info("GarbageCollection get info");
        DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();
        try {
            try {
                garbageCollectionDataList = gar.findAll(null, null);
                garbageControl = gar.getDataCount();
            }
            catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            gar = null;
        }
        if (garbageControl != null) {
            garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setGarbagCollectionMemoryList(garbageCollectionDataList);
            long totalMemoryMaxData = garbageControl.getTotalMemoryMaxData();
            long totalMemoryMinData = garbageControl.getTotalMemoryMinData();
            long freeMemoryMaxData = garbageControl.getFreeMemoryMaxData();
            long freeMemoryMinData = garbageControl.getFreeMemoryMinData();
            if (garbageCollectionDataList != null) {
                long totalDataCount = garbageCollectionDataList.size();
                this.totalDataCountText.setText(Long.toString(totalDataCount));
            }
            this.treadIntervalText.setText(Long.toString(GarbageCollectionMemoryJVM.getInstance().getSleepTime() / 1000L));
            this.freeMemoryMaxDataText.setText(Long.toString(freeMemoryMaxData));
            this.freeMemoryMinDataText.setText(Long.toString(freeMemoryMinData));
            this.totalMemoryMaxDataText.setText(Long.toString(totalMemoryMaxData));
            this.totalMemoryMinDataText.setText(Long.toString(totalMemoryMinData));
            this.maxData[0] = Long.toString(freeMemoryMaxData);
            this.maxData[1] = Long.toString(totalMemoryMaxData);
            this.minData[0] = Long.toString(freeMemoryMinData);
            this.minData[1] = Long.toString(totalMemoryMinData);
            logger.info("maxData[0] : " + this.maxData[0]);
            logger.info("maxData[1] : " + this.maxData[1]);
            logger.info("minData[0] : " + this.minData[0]);
            logger.info("minData[1] : " + this.minData[1]);
            if (garbageControl.getStartDate() != null) {
                this.collectStartDateText.setText(garbageControl.getStartDate().toString());
            }
            if (garbageControl.getEndDate() != null) {
                this.collectEndDateText.setText(garbageControl.getEndDate().toString());
            }
            this.setTable(garbageCollectionDataList);
        }
        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            this.treadStateText.setText(ALIVE);
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        } else {
            this.treadStateText.setText(NOALIVE);
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        this.maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    private void stopGarbageCollection() {
        GarbageCollectionControl garbageControl = new GarbageCollectionControl();
        GarbageCollectionMemoryJVM.getInstance().stopThread();
        logger.info("GarbageCollectionMemoryJVM thread stop");
        garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
        garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
        logger.info("GarbageCollectionMemoryJVM thread stop thread State : " + GarbageCollectionMemoryJVM.getInstance().checkThread());
        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            this.treadStateText.setText(ALIVE);
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        } else {
            this.treadStateText.setText(NOALIVE);
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        this.maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    public void setFocus() {
    }

    private void setTable(ArrayList garbageCollectionDataList) {
        if (garbageCollectionDataList == null || garbageCollectionDataList.size() < 1) {
            return;
        }
        this.memoryTable.removeAll();
        this.viewer.refresh();
        this.dateList.clear();
        this.freeMemoryDataList.clear();
        this.totalMemoryDataList.clear();
        logger.info("garbageCollectionDataList.size() : " + garbageCollectionDataList.size());
        int i = 0;
        while (i < garbageCollectionDataList.size()) {
            GarbageCollectionInfo garbageCollectionInfo = (GarbageCollectionInfo)garbageCollectionDataList.get(i);
            String[] garbageCollectionTableCellArray = new String[]{garbageCollectionInfo.getCheckDate().toString(), Long.toString(garbageCollectionInfo.getFreeMemory()), Long.toString(garbageCollectionInfo.getTotalMemory())};
            TableItem item = new TableItem(this.memoryTable, 0);
            item.setText(garbageCollectionTableCellArray);
            item.setData((Object)garbageCollectionTableCellArray);
            this.dateList.add(garbageCollectionTableCellArray[0]);
            this.freeMemoryDataList.add(garbageCollectionTableCellArray[1]);
            this.totalMemoryDataList.add(garbageCollectionTableCellArray[2]);
            logger.info("garbageCollectionTableCellArray[0] : " + garbageCollectionTableCellArray[0]);
            logger.info("garbageCollectionTableCellArray[1] : " + garbageCollectionTableCellArray[1]);
            logger.info("garbageCollectionTableCellArray[2] : " + garbageCollectionTableCellArray[2]);
            ++i;
        }
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.memoryTable != null) {
            this.memoryTable.dispose();
        }
    }

    private ActionBuilderEngine getEngineActionBuilder() {
        return this.actionBuilderEngine;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.getEngineActionBuilder().getActionStartEngine());
        toolBar.add(this.getEngineActionBuilder().getActionStopEngine());
        toolBar.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    private final class GarbageCollectionDataTable
    extends AbstractTableView {
        private boolean[] isColDirection;

        private GarbageCollectionDataTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.isColDirection = new boolean[3];
            TableColumn[] col = new TableColumn[3];
            col[0] = new TableColumn(this.table, 0x1000000);
            col[0].setText("Date");
            col[0].setWidth(GarbageCollectionView.this.computeCol0Width());
            this.isColDirection[0] = true;
            col[0].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ((GarbageCollectionDataTable)GarbageCollectionDataTable.this).isColDirection[0] = GarbageCollectionDataTable.this.sortTable(GarbageCollectionDataTable.this.table, 0, GarbageCollectionDataTable.this.isColDirection[0]);
                }
            });
            col[1] = new TableColumn(this.table, 0x1000000);
            col[1].setText("Free memory");
            col[1].setWidth(GarbageCollectionView.this.computeCol1Width());
            this.isColDirection[1] = true;
            col[1].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ((GarbageCollectionDataTable)GarbageCollectionDataTable.this).isColDirection[1] = GarbageCollectionDataTable.this.sortIntegerTable(GarbageCollectionDataTable.this.table, 1, GarbageCollectionDataTable.this.isColDirection[1]);
                }
            });
            col[2] = new TableColumn(this.table, 0x1000000);
            col[2].setText("Total memory");
            col[2].setWidth(GarbageCollectionView.this.computeCol0Width());
            this.isColDirection[2] = true;
            col[2].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ((GarbageCollectionDataTable)GarbageCollectionDataTable.this).isColDirection[2] = GarbageCollectionDataTable.this.sortIntegerTable(GarbageCollectionDataTable.this.table, 2, GarbageCollectionDataTable.this.isColDirection[2]);
                }
            });
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
        }
    }
}

