/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view;

import java.io.IOException;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.action.ActionBuilderApacheDerby;
import netjfwatcher.engine.model.action.ActionBuilderDatabase;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.model.thread.TrapReceiveThread;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.QueueForHTTP;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.control.QueueForPop3;
import netjfwatcher.engine.server.protocol.control.QueueForSmtp;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class GenericResourceView
extends ViewPart {
    public static final int TEXT_WIDTH = 120;
    public static final String ACITIVE = "Active";
    public static final String INACITIVE = "InActive";
    public static final String AWAKE = "awake";
    public static final String SLEEP = "sleep";
    private static Logger logger;
    private SubStatusLineManager statusLineManager;
    private ResourceInfo info;
    private Text engineStatusText;
    private Button engineStartButton;
    private Button engineStopButton;
    private Button refreshButton;
    private Text databaseNameText;
    private Text databaseStatusText;
    private Text commandReceivePortText;
    private Text commandReceiveStatusText;
    private Text xmlSocketPortText;
    private Text xmlSocketStatusText;
    private Text mailGuardTimeText;
    private Text mailGuardStatusText;
    private Text dataHoldPeriodThreadPeriodText;
    private Text dataHoldPeriodThreadStatusText;
    private Text trapReceivePortText;
    private Text trapReceiveStatusText;
    private Button databaseStartButton;
    private Button databaseStopButton;
    private Button commandReceiveStartButton;
    private Button commandReceiveStopButton;
    private Button trapReceiveStartButton;
    private Button trapReceiveStopButton;
    private Button xmlSocketReceiveStartButton;
    private Button xmlSocketReceiveStopButton;
    private Button mailGuardStartButton;
    private Button mailGuardStopButton;
    private Button dataHoldPeriodStopButton;
    private Button dataHoldPeriodStartButton;
    private Text snmpStatusText;
    private Text pingStatusText;
    private Text httpStatusText;
    private Text smtpStatusText;
    private Text pop3StatusText;
    private Button snmpAwakeButton;
    private Button snmpSleepButton;
    private Button pingAwakeButton;
    private Button pingSleepButton;
    private Button httpAwakeButton;
    private Button httpSleepButton;
    private Button smtpAwakeButton;
    private Button smtpSleepButton;
    private Button pop3AwakeButton;
    private Button pop3SleepButton;
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();
    private ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    private ActionBuilderDatabase actionBuilderDatabase = new ActionBuilderDatabase();
    private ActionBuilderApacheDerby actionBuilderApacheDerby = new ActionBuilderApacheDerby();

    public GenericResourceView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.fillActionBars();
        this.setStatusLine();
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayoutBase = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 16384);
        baseComposite.setLayout((Layout)gridLayoutBase);
        baseComposite.setLayoutData((Object)new GridData(2));
        gridLayoutBase = new GridLayout(1, false);
        Composite subBaseComposite = new Composite(baseComposite, 0);
        subBaseComposite.setLayout((Layout)gridLayoutBase);
        subBaseComposite.setLayoutData((Object)new GridData());
        GridLayout gridLayout0 = new GridLayout(5, false);
        Composite composite0 = new Composite(subBaseComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData());
        Group composite1 = new Group(subBaseComposite, 0);
        composite1.setText("Engine Detail");
        composite1.setLayout((Layout)new GridLayout(7, false));
        composite1.setLayoutData((Object)new GridData());
        Group composite2 = new Group(subBaseComposite, 0);
        composite2.setText("Protocol Detail");
        composite2.setLayout((Layout)new GridLayout(4, false));
        composite2.setLayoutData((Object)new GridData());
        Label label0 = new Label(composite0, 0);
        label0.setText("Engine status");
        label0.setLayoutData((Object)new GridData());
        this.engineStatusText = new Text(composite0, 2048);
        GridData gridDataa = new GridData();
        gridDataa.horizontalSpan = 1;
        gridDataa.verticalSpan = 1;
        gridDataa.widthHint = 120;
        this.engineStatusText.setLayoutData((Object)gridDataa);
        this.engineStartButton = new Button(composite0, 0);
        this.engineStartButton.setText("start");
        gridDataa = new GridData();
        gridDataa.horizontalSpan = 1;
        gridDataa.verticalSpan = 1;
        this.engineStartButton.setLayoutData((Object)gridDataa);
        this.engineStopButton = new Button(composite0, 0);
        this.engineStopButton.setText("stop");
        gridDataa = new GridData();
        gridDataa.horizontalSpan = 1;
        gridDataa.verticalSpan = 1;
        this.engineStopButton.setLayoutData((Object)gridDataa);
        this.refreshButton = new Button(composite0, 0);
        this.refreshButton.setText("Refresh");
        gridDataa = new GridData();
        gridDataa.horizontalSpan = 1;
        gridDataa.verticalSpan = 1;
        this.refreshButton.setLayoutData((Object)gridDataa);
        label0 = new Label(composite0, 0);
        label0.setText("");
        label0.setLayoutData((Object)new GridData());
        GridData gridData = new GridData();
        Label label = new Label((Composite)composite1, 0);
        label.setText("Database");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        label.setLayoutData((Object)new GridData());
        this.databaseStatusText = new Text((Composite)composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.databaseStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Database name");
        label.setLayoutData((Object)new GridData());
        this.databaseNameText = new Text((Composite)composite1, 2048);
        this.databaseNameText.setText(this.info.getDatabaseName());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.databaseNameText.setLayoutData((Object)gridData);
        this.databaseStartButton = new Button((Composite)composite1, 0);
        this.databaseStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.databaseStartButton.setLayoutData((Object)gridData);
        this.databaseStopButton = new Button((Composite)composite1, 0);
        this.databaseStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.databaseStopButton.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Command receive server");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.commandReceiveStatusText = new Text((Composite)composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.commandReceiveStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Command recive port");
        label.setLayoutData((Object)new GridData());
        this.commandReceivePortText = new Text((Composite)composite1, 2048);
        this.commandReceivePortText.setText(this.info.getEnginePort());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.commandReceivePortText.setLayoutData((Object)gridData);
        this.commandReceiveStartButton = new Button((Composite)composite1, 0);
        this.commandReceiveStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.commandReceiveStartButton.setLayoutData((Object)gridData);
        this.commandReceiveStopButton = new Button((Composite)composite1, 0);
        this.commandReceiveStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.commandReceiveStopButton.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Trap receive server");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.trapReceiveStatusText = new Text((Composite)composite1, 2048);
        Thread trapThread = (Thread)EngineThreadList.getInstance().getThread("Trap receive");
        if (trapThread == null) {
            this.trapReceiveStatusText.setText(INACITIVE);
        } else if (trapThread.isAlive()) {
            this.trapReceiveStatusText.setText(ACITIVE);
        } else {
            this.trapReceiveStatusText.setText(INACITIVE);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.trapReceiveStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Snmp Trap receive port");
        label.setLayoutData((Object)new GridData());
        this.trapReceivePortText = new Text((Composite)composite1, 2048);
        this.trapReceivePortText.setText(Integer.toString(this.info.getSnmpTrapPort()));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.trapReceivePortText.setLayoutData((Object)gridData);
        this.trapReceiveStartButton = new Button((Composite)composite1, 0);
        this.trapReceiveStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.trapReceiveStartButton.setLayoutData((Object)gridData);
        this.trapReceiveStopButton = new Button((Composite)composite1, 0);
        this.trapReceiveStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.trapReceiveStopButton.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("XML socket server");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.xmlSocketStatusText = new Text((Composite)composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.xmlSocketStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("XML Socket port");
        label.setLayoutData((Object)new GridData());
        this.xmlSocketPortText = new Text((Composite)composite1, 2048);
        this.xmlSocketPortText.setText(this.info.getXmlSocketPort());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.xmlSocketPortText.setLayoutData((Object)gridData);
        this.xmlSocketReceiveStartButton = new Button((Composite)composite1, 0);
        this.xmlSocketReceiveStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.xmlSocketReceiveStartButton.setLayoutData((Object)gridData);
        this.xmlSocketReceiveStopButton = new Button((Composite)composite1, 0);
        this.xmlSocketReceiveStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.xmlSocketReceiveStopButton.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Mail guard thread");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.mailGuardStatusText = new Text((Composite)composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.mailGuardStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Mail guard time(sec)");
        label.setLayoutData((Object)new GridData());
        this.mailGuardTimeText = new Text((Composite)composite1, 2048);
        this.mailGuardTimeText.setText(this.info.getMailGuardTime());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.mailGuardTimeText.setLayoutData((Object)gridData);
        this.mailGuardStartButton = new Button((Composite)composite1, 0);
        this.mailGuardStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.mailGuardStartButton.setLayoutData((Object)gridData);
        this.mailGuardStopButton = new Button((Composite)composite1, 0);
        this.mailGuardStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.mailGuardStopButton.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Data hold period thread");
        label.setLayoutData((Object)new GridData());
        label = new Label((Composite)composite1, 0);
        label.setText("status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.dataHoldPeriodThreadStatusText = new Text((Composite)composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.dataHoldPeriodThreadStatusText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite1, 0);
        label.setText("Datahold period thread period(sec)");
        label.setLayoutData((Object)new GridData());
        this.dataHoldPeriodThreadPeriodText = new Text((Composite)composite1, 2048);
        this.dataHoldPeriodThreadPeriodText.setText(Long.toString(60L));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.dataHoldPeriodThreadPeriodText.setLayoutData((Object)gridData);
        this.dataHoldPeriodStartButton = new Button((Composite)composite1, 0);
        this.dataHoldPeriodStartButton.setText("start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dataHoldPeriodStartButton.setLayoutData((Object)gridData);
        this.dataHoldPeriodStopButton = new Button((Composite)composite1, 0);
        this.dataHoldPeriodStopButton.setText("stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.dataHoldPeriodStopButton.setLayoutData((Object)gridData);
        this.setEngineComposite((Composite)composite2);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(700, 400);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.refreshView(true);
        this.setSelectionListener();
    }

    private void setEngineComposite(Composite composite2) {
        Label label = new Label(composite2, 0);
        label.setText("SNMP status");
        label.setLayoutData((Object)new GridData());
        this.snmpStatusText = new Text(composite2, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpStatusText.setLayoutData((Object)gridData);
        this.snmpAwakeButton = new Button(composite2, 0);
        this.snmpAwakeButton.setText("Awake");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.snmpAwakeButton.setLayoutData((Object)gridData);
        this.snmpSleepButton = new Button(composite2, 0);
        this.snmpSleepButton.setText("Sleep");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.snmpSleepButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Ping status");
        label.setLayoutData((Object)new GridData());
        this.pingStatusText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingStatusText.setLayoutData((Object)gridData);
        this.pingAwakeButton = new Button(composite2, 0);
        this.pingAwakeButton.setText("Awake");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.pingAwakeButton.setLayoutData((Object)gridData);
        this.pingSleepButton = new Button(composite2, 0);
        this.pingSleepButton.setText("Sleep");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.pingSleepButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("HTTP status");
        label.setLayoutData((Object)new GridData());
        this.httpStatusText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpStatusText.setLayoutData((Object)gridData);
        this.httpAwakeButton = new Button(composite2, 0);
        this.httpAwakeButton.setText("Awake");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.httpAwakeButton.setLayoutData((Object)gridData);
        this.httpSleepButton = new Button(composite2, 0);
        this.httpSleepButton.setText("Sleep");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.httpSleepButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SMTP status");
        label.setLayoutData((Object)new GridData());
        this.smtpStatusText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpStatusText.setLayoutData((Object)gridData);
        this.smtpAwakeButton = new Button(composite2, 0);
        this.smtpAwakeButton.setText("Awake");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.smtpAwakeButton.setLayoutData((Object)gridData);
        this.smtpSleepButton = new Button(composite2, 0);
        this.smtpSleepButton.setText("Sleep");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.smtpSleepButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Pop3 status");
        label.setLayoutData((Object)new GridData());
        this.pop3StatusText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3StatusText.setLayoutData((Object)gridData);
        this.pop3AwakeButton = new Button(composite2, 0);
        this.pop3AwakeButton.setText("Awake");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.pop3AwakeButton.setLayoutData((Object)gridData);
        this.pop3SleepButton = new Button(composite2, 0);
        this.pop3SleepButton.setText("Sleep");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.pop3SleepButton.setLayoutData((Object)gridData);
    }

    private void setSelectionListener() {
        this.engineStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.engineStartButton.setEnabled(false);
                GenericResourceView.this.getEngineActionBuilder().getActionStartEngine().run();
                GenericResourceView.this.refreshView(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.engineStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.engineStopButton.setEnabled(false);
                GenericResourceView.this.getEngineActionBuilder().getActionStopEngine().run();
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.databaseStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.databaseStartButton.setEnabled(false);
                GenericResourceView.this.startDatabase();
                GenericResourceView.this.refreshView(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.databaseStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.databaseStopButton.setEnabled(false);
                GenericResourceView.this.stopDatabase();
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.commandReceiveStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.commandReceiveStartButton.setEnabled(false);
                try {
                    EngineThreadList.getInstance().removeThreadList("Command receive");
                    CommnadReceiveServer.getInstance().startThread();
                    EngineThreadList.getInstance().setThreadList("Command receive", CommnadReceiveServer.getInstance().getCommandReceiveThread());
                }
                catch (IOException e1) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Abort command receive thread start ", (String)e1.getMessage());
                    logger.warning("Abort command receive thread start " + e1.getMessage());
                    shell.dispose();
                }
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.commandReceiveStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.commandReceiveStopButton.setEnabled(false);
                CommnadReceiveServer.getInstance().stopReceiving();
                EngineThreadList.getInstance().removeThreadList("Command receive");
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.trapReceiveStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.trapReceiveStartButton.setEnabled(false);
                TrapListenerImpl listener = TrapListenerImpl.getInstance();
                TrapReceiveThread trapthread = TrapReceiveThread.getInstance();
                try {
                    EngineThreadList.getInstance().removeThreadList("Trap receive");
                    trapthread.startReceiving();
                    trapthread.addTrapListener(listener);
                    EngineThreadList.getInstance().setThreadList("Trap receive", trapthread.getTrapReceiveThread());
                }
                catch (SocketException e1) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Abort trap receive thread start ", (String)e1.getMessage());
                    logger.warning("Abort trap receive thread start " + e1.getMessage());
                    shell.dispose();
                }
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.trapReceiveStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.trapReceiveStopButton.setEnabled(false);
                EngineThreadList.getInstance().removeThreadList("Trap receive");
                TrapReceiveThread trapthread = TrapReceiveThread.getInstance();
                trapthread.stopReceiving();
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.xmlSocketReceiveStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.xmlSocketReceiveStartButton.setEnabled(false);
                try {
                    EngineThreadList.getInstance().removeThreadList("XML Socket");
                    XMLSocketServer.getInstance().startXMLSocketServerThread();
                    EngineThreadList.getInstance().setThreadList("XML Socket", XMLSocketServer.getInstance().getXmlSocketServerThread());
                }
                catch (IOException e1) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Abort XML socket receive thread start ", (String)e1.getMessage());
                    logger.warning("Abort XML socket receive thread start " + e1.getMessage());
                    shell.dispose();
                }
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.xmlSocketReceiveStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.xmlSocketReceiveStopButton.setEnabled(false);
                XMLSocketServer.getInstance().stopXMLSocketServerReceiving();
                EngineThreadList.getInstance().removeThreadList("XML Socket");
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.mailGuardStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.mailGuardStartButton.setEnabled(false);
                EngineThreadList.getInstance().removeThreadList("Mail guard");
                if (ThreadMailSendGuard.getInstance().startThread()) {
                    EngineThreadList.getInstance().setThreadList("Mail guard", ThreadMailSendGuard.getInstance().getMailGuardThread());
                } else {
                    MessageDialog.openError((Shell)GenericResourceView.this.getSite().getShell(), (String)"Error", (String)"Abort Mail send guard time thread start");
                    logger.warning("Abort XML socket receive thread start");
                }
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.mailGuardStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.mailGuardStopButton.setEnabled(false);
                ThreadMailSendGuard.getInstance().stopReceiving();
                EngineThreadList.getInstance().removeThreadList("Mail guard");
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.dataHoldPeriodStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.dataHoldPeriodStartButton.setEnabled(false);
                EngineThreadList.getInstance().removeThreadList("Database limit check");
                ThreadPeriodHoldCheck.getInstance().startThread();
                EngineThreadList.getInstance().setThreadList("Database limit check", ThreadPeriodHoldCheck.getInstance().getPeriodHoldCheckThread());
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.dataHoldPeriodStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.this.dataHoldPeriodStopButton.setEnabled(false);
                ThreadPeriodHoldCheck.getInstance().stopReceiving();
                EngineThreadList.getInstance().removeThreadList("Database limit check");
                GenericResourceView.this.refreshView(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GenericResourceView.logger = Logger.getLogger(this.getClass().getName());
                GenericResourceView.this.refreshButton.setEnabled(false);
                GenericResourceView.this.refreshView(true);
                GenericResourceView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.snmpAwakeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForDefaultSnmpMib.getInstance().setPause(false);
                QueueForStatisticsMib.getInstance().setPause(false);
                GenericResourceView.this.snmpStatusText.setText(GenericResourceView.AWAKE);
                GenericResourceView.this.snmpAwakeButton.setEnabled(false);
                GenericResourceView.this.snmpSleepButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.snmpSleepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForDefaultSnmpMib.getInstance().setPause(true);
                QueueForStatisticsMib.getInstance().setPause(true);
                GenericResourceView.this.snmpStatusText.setText(GenericResourceView.SLEEP);
                GenericResourceView.this.snmpAwakeButton.setEnabled(true);
                GenericResourceView.this.snmpSleepButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.pingAwakeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForPing.getInstance().setPause(false);
                GenericResourceView.this.pingStatusText.setText(GenericResourceView.AWAKE);
                GenericResourceView.this.pingAwakeButton.setEnabled(false);
                GenericResourceView.this.pingSleepButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.pingSleepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForPing.getInstance().setPause(true);
                GenericResourceView.this.pingStatusText.setText(GenericResourceView.SLEEP);
                GenericResourceView.this.pingAwakeButton.setEnabled(true);
                GenericResourceView.this.pingSleepButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.httpAwakeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForHTTP.getInstance().setPause(false);
                GenericResourceView.this.httpStatusText.setText(GenericResourceView.AWAKE);
                GenericResourceView.this.httpAwakeButton.setEnabled(false);
                GenericResourceView.this.httpSleepButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.httpSleepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForHTTP.getInstance().setPause(true);
                GenericResourceView.this.httpStatusText.setText(GenericResourceView.SLEEP);
                GenericResourceView.this.httpAwakeButton.setEnabled(true);
                GenericResourceView.this.httpSleepButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.smtpAwakeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForSmtp.getInstance().setPause(false);
                GenericResourceView.this.smtpStatusText.setText(GenericResourceView.AWAKE);
                GenericResourceView.this.smtpAwakeButton.setEnabled(false);
                GenericResourceView.this.smtpSleepButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.smtpSleepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForSmtp.getInstance().setPause(true);
                GenericResourceView.this.smtpStatusText.setText(GenericResourceView.SLEEP);
                GenericResourceView.this.smtpAwakeButton.setEnabled(true);
                GenericResourceView.this.smtpSleepButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.pop3AwakeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForPop3.getInstance().setPause(false);
                GenericResourceView.this.pop3StatusText.setText(GenericResourceView.AWAKE);
                GenericResourceView.this.pop3AwakeButton.setEnabled(false);
                GenericResourceView.this.pop3SleepButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.pop3SleepButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                QueueForPop3.getInstance().setPause(true);
                GenericResourceView.this.pop3StatusText.setText(GenericResourceView.SLEEP);
                GenericResourceView.this.pop3AwakeButton.setEnabled(true);
                GenericResourceView.this.pop3SleepButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void setFocus() {
        this.refreshButton.setEnabled(false);
        this.refreshView(true);
        this.refreshButton.setEnabled(true);
    }

    public void setDisableAllButton() {
        this.engineStartButton.setEnabled(false);
        this.engineStopButton.setEnabled(false);
        this.databaseStartButton.setEnabled(false);
        this.databaseStopButton.setEnabled(false);
        this.trapReceiveStartButton.setEnabled(false);
        this.trapReceiveStopButton.setEnabled(false);
        this.commandReceiveStartButton.setEnabled(false);
        this.commandReceiveStopButton.setEnabled(false);
        this.xmlSocketReceiveStartButton.setEnabled(false);
        this.xmlSocketReceiveStopButton.setEnabled(false);
        this.mailGuardStartButton.setEnabled(false);
        this.mailGuardStopButton.setEnabled(false);
        this.dataHoldPeriodStartButton.setEnabled(false);
        this.dataHoldPeriodStopButton.setEnabled(false);
        this.snmpAwakeButton.setEnabled(false);
        this.snmpSleepButton.setEnabled(false);
        this.pingAwakeButton.setEnabled(false);
        this.pingSleepButton.setEnabled(false);
        this.httpAwakeButton.setEnabled(false);
        this.httpSleepButton.setEnabled(false);
        this.smtpAwakeButton.setEnabled(false);
        this.smtpSleepButton.setEnabled(false);
        this.pop3AwakeButton.setEnabled(false);
        this.pop3SleepButton.setEnabled(false);
    }

    public void refreshView(boolean isDatabaseTest) {
        String databaseKind;
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        if (EngineStatus.getInstance().isEngine()) {
            this.engineStatusText.setText(ACITIVE);
            this.engineStartButton.setEnabled(false);
            this.engineStopButton.setEnabled(true);
        } else {
            this.engineStatusText.setText(INACITIVE);
            this.engineStartButton.setEnabled(true);
            this.engineStopButton.setEnabled(false);
        }
        this.databaseNameText.setText(this.info.getDatabaseName());
        this.commandReceivePortText.setText(this.info.getEnginePort());
        this.xmlSocketPortText.setText(this.info.getXmlSocketPort());
        this.trapReceivePortText.setText(Integer.toString(this.info.getSnmpTrapPort()));
        this.mailGuardTimeText.setText(this.info.getMailGuardTime());
        this.dataHoldPeriodThreadPeriodText.setText(Long.toString(60L));
        if (isDatabaseTest) {
            DatabaseTest databaseTest = new DatabaseTest(this.info.getDatabaseName());
            String[] testResult = databaseTest.checkDatabase(this.info.getDatabaseDriver(), this.info.getDatabaseUrl(), this.info.getDatabaseUser(), this.info.getDatabasePassword());
            int okPos = 0;
            this.databaseStatusText.setText(ACITIVE);
            int i = 0;
            while (i < testResult.length) {
                logger.info("Phase " + i + " : " + testResult[i]);
                okPos = testResult[i].indexOf("OK");
                if (okPos < 0 && i != 0) {
                    this.databaseStatusText.setText(INACITIVE);
                    break;
                }
                ++i;
            }
        }
        if ((databaseKind = this.info.getDatabaseName()).equals("HSQLDB") || databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby")) {
            if (this.databaseStatusText.getText().equals(ACITIVE)) {
                this.databaseStartButton.setEnabled(false);
                this.databaseStopButton.setEnabled(true);
            } else {
                this.databaseStartButton.setEnabled(true);
                this.databaseStopButton.setEnabled(false);
            }
        } else {
            this.databaseStartButton.setEnabled(false);
            this.databaseStopButton.setEnabled(false);
        }
        Thread trapThread = (Thread)EngineThreadList.getInstance().getThread("Trap receive");
        if (trapThread == null) {
            this.trapReceiveStatusText.setText(INACITIVE);
            this.trapReceiveStartButton.setEnabled(true);
            this.trapReceiveStopButton.setEnabled(false);
        } else if (trapThread.isAlive()) {
            this.trapReceiveStatusText.setText(ACITIVE);
            this.trapReceiveStartButton.setEnabled(false);
            this.trapReceiveStopButton.setEnabled(true);
        } else {
            this.trapReceiveStatusText.setText(INACITIVE);
            this.trapReceiveStartButton.setEnabled(true);
            this.trapReceiveStopButton.setEnabled(false);
        }
        Thread commandThread = (Thread)EngineThreadList.getInstance().getThread("Command receive");
        if (commandThread == null) {
            this.commandReceiveStatusText.setText(INACITIVE);
            this.commandReceiveStartButton.setEnabled(true);
            this.commandReceiveStopButton.setEnabled(false);
        } else if (commandThread.isAlive()) {
            this.commandReceiveStatusText.setText(ACITIVE);
            this.commandReceiveStartButton.setEnabled(false);
            this.commandReceiveStopButton.setEnabled(true);
        } else {
            this.commandReceiveStatusText.setText(INACITIVE);
            this.commandReceiveStartButton.setEnabled(true);
            this.commandReceiveStopButton.setEnabled(false);
        }
        Thread xmlThread = (Thread)EngineThreadList.getInstance().getThread("XML Socket");
        if (xmlThread == null) {
            this.xmlSocketStatusText.setText(INACITIVE);
            this.xmlSocketReceiveStartButton.setEnabled(true);
            this.xmlSocketReceiveStopButton.setEnabled(false);
        } else if (xmlThread.isAlive()) {
            this.xmlSocketStatusText.setText(ACITIVE);
            this.xmlSocketReceiveStartButton.setEnabled(false);
            this.xmlSocketReceiveStopButton.setEnabled(true);
        } else {
            this.xmlSocketStatusText.setText(INACITIVE);
            this.xmlSocketReceiveStartButton.setEnabled(true);
            this.xmlSocketReceiveStopButton.setEnabled(false);
        }
        Thread mailGuardThread = (Thread)EngineThreadList.getInstance().getThread("Mail guard");
        if (mailGuardThread == null) {
            this.mailGuardStatusText.setText(INACITIVE);
            this.mailGuardStartButton.setEnabled(true);
            this.mailGuardStopButton.setEnabled(false);
        } else if (mailGuardThread.isAlive()) {
            this.mailGuardStatusText.setText(ACITIVE);
            this.mailGuardStartButton.setEnabled(false);
            this.mailGuardStopButton.setEnabled(true);
        } else {
            this.mailGuardStatusText.setText(INACITIVE);
            this.mailGuardStartButton.setEnabled(true);
            this.mailGuardStopButton.setEnabled(false);
        }
        Thread dataHoldPeriodThraed = (Thread)EngineThreadList.getInstance().getThread("Database limit check");
        if (dataHoldPeriodThraed == null) {
            this.dataHoldPeriodThreadStatusText.setText(INACITIVE);
            this.dataHoldPeriodStartButton.setEnabled(true);
            this.dataHoldPeriodStopButton.setEnabled(false);
        } else if (dataHoldPeriodThraed.isAlive()) {
            this.dataHoldPeriodThreadStatusText.setText(ACITIVE);
            this.dataHoldPeriodStartButton.setEnabled(false);
            this.dataHoldPeriodStopButton.setEnabled(true);
        } else {
            this.dataHoldPeriodThreadStatusText.setText(INACITIVE);
            this.dataHoldPeriodStartButton.setEnabled(true);
            this.dataHoldPeriodStopButton.setEnabled(false);
        }
        if (QueueForDefaultSnmpMib.getInstance().isPause() && QueueForStatisticsMib.getInstance().isPause()) {
            this.snmpStatusText.setText(SLEEP);
            this.snmpAwakeButton.setEnabled(true);
            this.snmpSleepButton.setEnabled(false);
        } else {
            this.snmpStatusText.setText(AWAKE);
            this.snmpAwakeButton.setEnabled(false);
            this.snmpSleepButton.setEnabled(true);
        }
        if (QueueForPing.getInstance().isPause()) {
            this.pingStatusText.setText(SLEEP);
            this.pingAwakeButton.setEnabled(true);
            this.pingSleepButton.setEnabled(false);
        } else {
            this.pingStatusText.setText(AWAKE);
            this.pingAwakeButton.setEnabled(false);
            this.pingSleepButton.setEnabled(true);
        }
        if (QueueForHTTP.getInstance().isPause()) {
            this.httpStatusText.setText(SLEEP);
            this.httpAwakeButton.setEnabled(true);
            this.httpSleepButton.setEnabled(false);
        } else {
            this.httpStatusText.setText(AWAKE);
            this.httpAwakeButton.setEnabled(false);
            this.httpSleepButton.setEnabled(true);
        }
        if (QueueForSmtp.getInstance().isPause()) {
            this.smtpStatusText.setText(SLEEP);
            this.smtpAwakeButton.setEnabled(true);
            this.smtpSleepButton.setEnabled(false);
        } else {
            this.smtpStatusText.setText(AWAKE);
            this.smtpAwakeButton.setEnabled(false);
            this.smtpSleepButton.setEnabled(true);
        }
        if (QueueForPop3.getInstance().isPause()) {
            this.pop3StatusText.setText(SLEEP);
            this.pop3AwakeButton.setEnabled(true);
            this.pop3SleepButton.setEnabled(false);
        } else {
            this.pop3StatusText.setText(AWAKE);
            this.pop3AwakeButton.setEnabled(false);
            this.pop3SleepButton.setEnabled(true);
        }
    }

    private void startDatabase() {
        String databaseKind = this.info.getDatabaseName();
        if (databaseKind.equals("HSQLDB")) {
            logger.info("HSQLDB Start task");
            try {
                HsqldbControl.getInstance().startHsqlDB();
            }
            catch (HsqldbException e3) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Hsqldb Status", (String)e3.getMessage());
                shell.dispose();
            }
        } else if (databaseKind.equals("Apache Derby")) {
            try {
                ApacheDerbyNetworkServer.getInstance().startDerbyNetworkServer();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Abort start Apache Derby " + e.getMessage()));
                shell.dispose();
            }
        } else if (databaseKind.equals("Embedded Derby")) {
            try {
                ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Apache Derby Status", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private void stopDatabase() {
        String databaseKind = this.info.getDatabaseName();
        if (databaseKind.equals("HSQLDB")) {
            try {
                HsqldbControl.getInstance().stopHsqlDB();
                this.databaseStatusText.setText(INACITIVE);
            }
            catch (ClassNotFoundException e3) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e3.getMessage());
                shell.dispose();
            }
            catch (SQLException e3) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e3.getMessage());
                shell.dispose();
            }
        } else if (databaseKind.equals("Apache Derby")) {
            try {
                ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
            }
            catch (Exception e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        } else if (databaseKind.equals("Embedded Derby")) {
            try {
                ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
            }
            catch (Exception e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(false);
    }

    private ActionBuilderEngine getEngineActionBuilder() {
        return this.actionBuilderEngine;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.getEngineActionBuilder().getActionStartEngine());
        toolBar.add(this.getEngineActionBuilder().getActionStopEngine());
        toolBar.add(this.actionBuilderEditorPart.actionCloseAllEditors());
        IMenuManager menu = actionBars.getMenuManager();
        MenuManager hsqldbSubMenu = new MenuManager("HSQLDB");
        menu.add((IContributionItem)hsqldbSubMenu);
        hsqldbSubMenu.add(this.getDatabaseActionBuilder().getActionStartHSQLDB());
        hsqldbSubMenu.add(this.getDatabaseActionBuilder().getActionStopHSQLDB());
        MenuManager hsqldbManagerSubMenu = new MenuManager("HSQLDB Manager");
        hsqldbSubMenu.add((IContributionItem)hsqldbManagerSubMenu);
        hsqldbManagerSubMenu.add(this.getDatabaseActionBuilder().getActionStartHSQLDBManager());
        hsqldbManagerSubMenu.add(this.getDatabaseActionBuilder().getActionStopHSQLDBManager());
        menu.add((IContributionItem)new Separator());
        MenuManager embeddedApacheDerbySubMenu = new MenuManager("Embedded Apache Derby");
        menu.add((IContributionItem)embeddedApacheDerbySubMenu);
        embeddedApacheDerbySubMenu.add(this.getApacheDerbyActionBuilder().getActionEmbeddedStartApacheDerby());
        embeddedApacheDerbySubMenu.add(this.getApacheDerbyActionBuilder().getActionEmbeddedStopApacheDerby());
        menu.add((IContributionItem)new Separator());
        MenuManager apacheDerbySubMenu = new MenuManager("Apache Derby Network server");
        menu.add((IContributionItem)apacheDerbySubMenu);
        apacheDerbySubMenu.add(this.getApacheDerbyActionBuilder().getActionStartApacheDerby());
        apacheDerbySubMenu.add(this.getApacheDerbyActionBuilder().getActionStopApacheDerby());
        apacheDerbySubMenu.add(this.getApacheDerbyActionBuilder().getActionSysInfoApacheDerby());
        menu.add((IContributionItem)new Separator());
        menu.add(this.getDatabaseActionBuilder().getActionStartDatabase());
    }

    private ActionBuilderDatabase getDatabaseActionBuilder() {
        return this.actionBuilderDatabase;
    }

    private ActionBuilderApacheDerby getApacheDerbyActionBuilder() {
        return this.actionBuilderApacheDerby;
    }
}

