/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.common;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.common.EditorNodeChartMouseListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractEditorNodeChart
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Chart";
    protected static final String ALL_DRAW_MODE = "all";
    public static final int OFFSET = 20;
    private int[] scrollCompositeSize = new int[2];
    public static final int X_POINT0 = 50;
    private int chartXScall;
    private int chartYScall;
    private int[] pointXY0 = new int[2];
    private int[] xAxisPoint = new int[2];
    private static final int[] Y_AXIS_POINT = new int[]{50, 50};
    private static final int Y_NOCTH = 10;
    private static final int X_SCALL_MIN_PITCH = 5;
    private static final int DATE_YEAR_CUTLENGTH = 5;
    private static Color whiteColor = new Color(null, 255, 255, 255);
    private static Color blackColor = new Color(null, 0, 0, 0);
    private static Color redColor = new Color(null, 255, 0, 0);
    private static Color blueColor = new Color(null, 0, 0, 255);
    private static Color limeColor = new Color(null, 0, 255, 0);
    private static Color navyColor = new Color(null, 0, 0, 128);
    private static Color yellowColor = new Color(null, 255, 255, 0);
    private static Color tealColor = new Color(null, 0, 128, 128);
    private static Color greenColor = new Color(null, 0, 128, 0);
    private static final Color X_LINE_COLOR = navyColor;
    private static final Color Y_LINE_COLOR = navyColor;
    private static final Color Y_SCALL_COLOR = navyColor;
    private static final Color[] LINE_COLOR = new Color[]{limeColor, redColor, blueColor, yellowColor, greenColor, tealColor, blackColor, navyColor};
    private static final int[] LINE_STYLE = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4};
    protected static String mode = "all";
    private static Logger logger;
    protected int selectNo = 0;
    protected Canvas canvas;
    private GC gc;
    protected NodeInformation targetNodeInfo;
    protected String inputOid;
    protected String[] maxData;
    protected String[] minData;
    protected Menu popUpMenu;
    private double maxDataDouble;
    private double minDataDouble;
    private float yNotch = 10.0f;
    protected ArrayList allStatisticsDataList;
    protected ArrayList dateList;
    protected ArrayList itemNameList;
    protected EditorNodeChartMouseListener mouseListener;
    protected ScrolledComposite scrollComposite;
    protected Image zoominImage;
    protected Image zoomoutImage;

    public AbstractEditorNodeChart() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.setCanvasSize();
        EditorInputNodeChart nodeViewEditorInput = (EditorInputNodeChart)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        this.maxData = nodeViewEditorInput.getMaxData();
        this.minData = nodeViewEditorInput.getMinData();
        this.allStatisticsDataList = nodeViewEditorInput.getDataList();
        this.dateList = nodeViewEditorInput.getDateList();
        this.itemNameList = nodeViewEditorInput.getItemNameList();
        this.inputOid = nodeViewEditorInput.getOid();
        if (this.maxData == null) {
            try {
                this.getChartData();
            }
            catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        this.scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, true);
        this.scrollComposite.setLayout((Layout)layout);
        this.scrollComposite.setBackground(whiteColor);
        this.canvas = new Canvas((Composite)this.scrollComposite, 0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                AbstractEditorNodeChart.this.redraw();
            }
        });
        this.gc = new GC((Drawable)this.canvas);
        this.gc.setBackground(this.scrollComposite.getBackground());
        this.scrollComposite.setContent((Control)this.canvas);
        this.scrollComposite.setMinSize(this.scrollCompositeSize[0], this.scrollCompositeSize[1]);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        this.mouseListener = new EditorNodeChartMouseListener(this.scrollComposite, parent.getDisplay(), parent, this.canvas, this.gc, this, false);
        this.scrollComposite.addMouseListener((MouseListener)this.mouseListener);
        this.canvas.addMouseListener((MouseListener)this.mouseListener);
        this.setPopupMenu(parent);
        this.createZoomImage();
    }

    private void setCanvasSize() {
        this.chartXScall = CanvasViewConfigFileParse.getInstance().getChartXScall();
        this.chartYScall = CanvasViewConfigFileParse.getInstance().getChartYScall();
        this.pointXY0[0] = 50;
        this.pointXY0[1] = this.chartYScall;
        this.xAxisPoint[0] = this.chartXScall;
        this.xAxisPoint[1] = this.chartYScall;
        this.scrollCompositeSize[0] = CanvasViewConfigFileParse.getInstance().getChartWidth();
        this.scrollCompositeSize[1] = CanvasViewConfigFileParse.getInstance().getChartHeight();
    }

    protected abstract void setPopupMenu(Composite var1);

    protected abstract void getChartData() throws DatabaseConnectionException, SQLException;

    protected void redraw() {
        int height = this.canvas.getClientArea().height - 1;
        int width = this.canvas.getClientArea().width - 1;
        this.gc.setForeground(tealColor);
        this.gc.drawLine(0, 0, width, 0);
        this.gc.drawLine(0, 0, 0, height);
        this.gc.setForeground(whiteColor);
        this.gc.drawLine(width, 0, width, height);
        this.gc.drawLine(0, height, width, height);
        this.gc.setForeground(blackColor);
        this.gc.fillRectangle(this.canvas.getClientArea());
        this.gc.drawString(this.getTitle(), 5, 5);
        this.drawChart();
        this.setZoomButton();
    }

    protected void drawChart() {
        double xScallShowTextPos;
        double[] checkMaxData = new double[this.maxData.length];
        double[] checkMinData = new double[this.minData.length];
        int i = 0;
        while (i < this.maxData.length) {
            if (this.maxData[i] == null) {
                return;
            }
            checkMaxData[i] = Double.parseDouble(this.maxData[i]);
            checkMinData[i] = Double.parseDouble(this.minData[i]);
            ++i;
        }
        if (mode.equals(ALL_DRAW_MODE)) {
            this.maxDataDouble = checkMaxData[0];
            if (this.maxData.length > 1) {
                i = 0;
                while (i < this.maxData.length - 1) {
                    int j = this.maxData.length - 1;
                    while (j > i) {
                        double work0 = checkMaxData[j];
                        double work1 = checkMaxData[j - 1];
                        if (work0 > work1) {
                            double work = checkMaxData[j - 1];
                            checkMaxData[j - 1] = checkMaxData[j];
                            checkMaxData[j] = work;
                        }
                        --j;
                    }
                    ++i;
                }
                this.maxDataDouble = checkMaxData[0];
            }
        } else {
            this.maxDataDouble = checkMaxData[this.selectNo];
            this.minDataDouble = checkMinData[this.selectNo];
        }
        double dataYMax = this.createYMaxScall(this.maxDataDouble, this.minDataDouble);
        this.gc.setLineStyle(1);
        this.gc.setForeground(X_LINE_COLOR);
        this.gc.drawLine(this.pointXY0[0], this.pointXY0[1], this.xAxisPoint[0], this.xAxisPoint[1]);
        double xScallPitch = (double)(this.xAxisPoint[0] - this.pointXY0[0]) / (double)this.dateList.size();
        double plotX = this.pointXY0[0];
        double xNotch = xScallPitch;
        if (xScallPitch < 5.0) {
            xNotch = 5.0;
        }
        if ((xScallShowTextPos = (double)(this.dateList.size() / 9 + 1)) > 10.0) {
            xScallShowTextPos = 10.0;
        }
        double sghowTextToggleFlag = 0.0;
        double i2 = 0.0;
        while (i2 <= (double)this.dateList.size() && plotX <= (double)this.xAxisPoint[0] - xNotch) {
            this.gc.drawLine((int)plotX, this.pointXY0[1] - 5, (int)plotX, this.pointXY0[1]);
            if (i2 % xScallShowTextPos == 0.0) {
                this.gc.drawLine((int)plotX, this.pointXY0[1], (int)plotX, this.pointXY0[1] + 5);
                this.gc.setLineStyle(3);
                this.gc.drawLine((int)plotX, this.pointXY0[1], (int)plotX, Y_AXIS_POINT[1] - 20);
                this.gc.setLineStyle(1);
                String dateWork = (String)this.dateList.get((int)i2);
                String dateText = dateWork.length() >= 5 ? dateWork.substring(5, dateWork.length()) : dateWork;
                if (sghowTextToggleFlag % 2.0 == 0.0) {
                    this.gc.drawString(dateText, (int)plotX, this.pointXY0[1] + 10);
                } else {
                    this.gc.drawString(dateText, (int)plotX, this.pointXY0[1] + 24);
                }
                sghowTextToggleFlag += 1.0;
            }
            plotX += xNotch;
            i2 += 1.0;
        }
        this.gc.setLineStyle(1);
        this.gc.setForeground(Y_LINE_COLOR);
        this.gc.drawLine(this.pointXY0[0], this.pointXY0[1], Y_AXIS_POINT[0], Y_AXIS_POINT[1] - 20);
        double pichData = mode.equals(ALL_DRAW_MODE) ? (double)this.picth(dataYMax, this.yNotch) : (dataYMax - this.minDataDouble >= 0.0 ? (double)this.picth(dataYMax - this.minDataDouble, this.yNotch) : (double)this.picth(dataYMax, this.yNotch));
        this.gc.setLineStyle(3);
        this.gc.setForeground(Y_SCALL_COLOR);
        double plotDataY = dataYMax;
        if (mode.equals(ALL_DRAW_MODE)) {
            while (plotDataY >= pichData) {
                double yScall = 100.0 - plotDataY / dataYMax * 100.0;
                double yScallPosition = yScall * (double)(this.pointXY0[1] - Y_AXIS_POINT[1]) / 100.0 + (double)Y_AXIS_POINT[1];
                this.gc.drawLine(this.pointXY0[0], (int)yScallPosition, this.xAxisPoint[0], (int)yScallPosition);
                this.gc.drawString(Double.toString(plotDataY), this.xAxisPoint[0] + 5, (int)yScallPosition - 10);
                plotDataY -= pichData;
            }
        } else {
            int count = 0;
            while (this.yNotch >= (float)count) {
                double yScall = (float)count / this.yNotch;
                double yScallPosition = yScall * (double)(this.pointXY0[1] - Y_AXIS_POINT[1]) + (double)Y_AXIS_POINT[1];
                this.gc.drawLine(this.pointXY0[0], (int)yScallPosition, this.xAxisPoint[0], (int)yScallPosition);
                this.gc.drawString(Double.toString(plotDataY), this.xAxisPoint[0] + 5, (int)yScallPosition - 10);
                plotDataY = dataYMax - pichData * (double)(++count);
            }
        }
        if (mode.equals(ALL_DRAW_MODE)) {
            if (this.itemNameList != null) {
                int i3 = 0;
                while (i3 < this.itemNameList.size()) {
                    this.introNotes(i3, i3);
                    ++i3;
                }
            }
        } else {
            this.introNotes(0, this.selectNo);
        }
        ArrayList[] statisticsDataList = null;
        statisticsDataList = new ArrayList[this.allStatisticsDataList.size()];
        int instanceCount = 0;
        while (instanceCount < this.allStatisticsDataList.size()) {
            statisticsDataList[instanceCount] = (ArrayList)this.allStatisticsDataList.get(instanceCount);
            ++instanceCount;
        }
        if (mode.equals(ALL_DRAW_MODE)) {
            int j = 0;
            while (j < statisticsDataList.length) {
                this.drawLine(j, statisticsDataList[j], dataYMax, xScallPitch);
                ++j;
            }
        } else {
            this.drawLine(this.selectNo, statisticsDataList[this.selectNo], dataYMax, xScallPitch);
        }
    }

    protected void createZoomImage() {
        this.zoominImage = ImageDescriptor.createFromURL((URL)NetJFWatcherPlugin.getInstance().getBundle().getEntry("icons/zoomin.gif")).createImage();
        this.zoomoutImage = ImageDescriptor.createFromURL((URL)NetJFWatcherPlugin.getInstance().getBundle().getEntry("icons/zoomout.gif")).createImage();
    }

    protected void setZoomButton() {
        Point canvaPoint = this.canvas.getLocation();
        int canvaAbsPointX = Math.abs(canvaPoint.x);
        int canvaAbsPointY = Math.abs(canvaPoint.y);
        Point mapScrollCompositePoint = this.scrollComposite.getSize();
        int overviewPointX = canvaAbsPointX;
        int overviewPointY = canvaAbsPointY + mapScrollCompositePoint.y - this.zoominImage.getBounds().height - 20;
        this.gc.drawImage(this.zoominImage, overviewPointX, overviewPointY);
        this.gc.drawImage(this.zoomoutImage, overviewPointX + 20, overviewPointY);
    }

    protected void introNotes(int drawCount, int selectNo) {
        int colorNum = selectNo & 7;
        this.gc.setForeground(LINE_COLOR[colorNum]);
        int styleNum = selectNo & 0xF;
        this.gc.setLineStyle(LINE_STYLE[styleNum]);
        this.gc.drawLine(this.xAxisPoint[0] + 100, Y_AXIS_POINT[1] + drawCount * 20, this.xAxisPoint[0] + 130, Y_AXIS_POINT[1] + drawCount * 20);
        this.gc.setForeground(blackColor);
        this.gc.drawString((String)this.itemNameList.get(selectNo), this.xAxisPoint[0] + 140, Y_AXIS_POINT[1] + drawCount * 20 - 7);
    }

    protected void drawLine(int drawCount, ArrayList list, double dataYMax, double xScallPitch) {
        double relatiData;
        double relatiX;
        int i;
        double[] data = new double[list.size()];
        if (mode.equals(ALL_DRAW_MODE)) {
            i = 0;
            while (i < list.size()) {
                double dataFloat = Double.parseDouble((String)list.get(i));
                relatiX = 100.0 - dataFloat / dataYMax * 100.0;
                data[i] = relatiData = relatiX * (double)(this.pointXY0[1] - Y_AXIS_POINT[1]) / 100.0 + (double)Y_AXIS_POINT[1];
                ++i;
            }
        } else {
            i = 0;
            while (i < list.size()) {
                double dataDouble = Double.parseDouble((String)list.get(i));
                if (this.maxDataDouble == this.minDataDouble && dataDouble - this.minDataDouble <= 0.0) {
                    relatiX = dataDouble == 0.0 ? (double)(1.0f / this.yNotch * 100.0f) : 100.0 - dataDouble / dataYMax * 100.0;
                } else {
                    double denomi = 0.0;
                    denomi = dataYMax - this.minDataDouble > 0.0 ? dataYMax - this.minDataDouble : this.minDataDouble - dataYMax;
                    relatiX = 100.0 - (dataDouble - this.minDataDouble) / denomi * 100.0;
                }
                data[i] = relatiData = relatiX * (double)(this.pointXY0[1] - Y_AXIS_POINT[1]) / 100.0 + (double)Y_AXIS_POINT[1];
                ++i;
            }
        }
        double timePlotX = this.pointXY0[0];
        int colorNum = drawCount & 7;
        this.gc.setForeground(LINE_COLOR[colorNum]);
        int styleNum = drawCount & 0xF;
        this.gc.setLineStyle(LINE_STYLE[styleNum]);
        int i2 = 0;
        while (i2 < data.length - 1) {
            this.gc.drawLine((int)timePlotX, (int)data[i2], (int)(timePlotX + xScallPitch), (int)data[i2 + 1]);
            timePlotX += xScallPitch;
            ++i2;
        }
    }

    protected double createYMaxScall(double maxData, double minData) {
        if (maxData < 1.0) {
            maxData = 1.0;
        }
        double maxYData = 0.0;
        if (maxData > 2.0) {
            long workMaxdata = (long)maxData;
            String stringCreateMaxData = Long.toString(workMaxdata);
            String stringSourceMaxData = Long.toString(workMaxdata);
            if (stringSourceMaxData.length() > 6) {
                int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
                int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
                int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));
                if (chk3 >= 5) {
                    ++chk2;
                    chk3 = 0;
                }
                if (chk2 >= 10) {
                    ++chk1;
                    chk2 = 0;
                }
                stringCreateMaxData = "" + chk1 + chk2 + chk3;
                int i = 0;
                while (i < stringSourceMaxData.length() - 3) {
                    stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                    ++i;
                }
                float checkMinYData = Float.parseFloat(stringCreateMaxData);
                if (minData > (double)checkMinYData || maxData > (double)checkMinYData) {
                    if (++chk3 >= 5) {
                        ++chk2;
                        chk3 = 0;
                    }
                    if (chk2 >= 10) {
                        ++chk1;
                        chk2 = 0;
                    }
                    stringCreateMaxData = "" + chk1 + chk2 + chk3;
                    int i2 = 0;
                    while (i2 < stringSourceMaxData.length() - 3) {
                        stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                        ++i2;
                    }
                }
            } else if (stringSourceMaxData.length() > 3) {
                int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
                int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
                int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));
                if (chk3 >= 5) {
                    ++chk2;
                }
                if (chk2 >= 10) {
                    ++chk1;
                    chk2 = 0;
                }
                stringCreateMaxData = "" + chk1 + chk2;
                int i = 0;
                while (i < stringSourceMaxData.length() - 2) {
                    stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                    ++i;
                }
                float checkMinYData = Float.parseFloat(stringCreateMaxData);
                if (minData > (double)checkMinYData || maxData > (double)checkMinYData) {
                    stringCreateMaxData = "" + chk1 + ++chk2;
                    int i3 = 0;
                    while (i3 < stringSourceMaxData.length() - 2) {
                        stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                        ++i3;
                    }
                }
            } else if (stringSourceMaxData.length() == 3) {
                float checkMinYData;
                int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
                int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
                int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));
                if (chk3 >= 5) {
                    ++chk2;
                }
                if (chk2 >= 10) {
                    ++chk1;
                    chk2 = 0;
                }
                if (minData > (double)(checkMinYData = Float.parseFloat(stringCreateMaxData = "" + chk1 + chk2 + "0")) || maxData > (double)checkMinYData) {
                    stringCreateMaxData = "" + chk1 + ++chk2 + "0";
                }
            } else if (stringSourceMaxData.length() == 2) {
                float checkMinYData;
                int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
                int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
                if (chk2 >= 5) {
                    ++chk1;
                }
                if (minData > (double)(checkMinYData = Float.parseFloat(stringCreateMaxData = chk1 + "0"))) {
                    stringCreateMaxData = ++chk1 + "0";
                }
            }
            maxYData = Float.parseFloat(stringCreateMaxData);
        } else {
            maxYData = (float)maxData;
        }
        if (maxData > maxYData) {
            maxYData += maxYData;
        }
        return maxYData;
    }

    protected long picth(double dataYMax, float kizami) {
        long yScall = (long)(dataYMax * (double)(1.0f / kizami));
        if (yScall < 1L) {
            yScall = 1L;
        }
        long workMaxdata = yScall;
        String stringCreateMaxData = Long.toString(workMaxdata);
        String stringSourceMaxData = Long.toString(workMaxdata);
        if (stringSourceMaxData.length() > 3) {
            int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
            int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
            int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));
            if (chk3 >= 5) {
                ++chk2;
            }
            if (chk2 >= 10) {
                ++chk1;
                chk2 = 0;
            }
            stringCreateMaxData = "" + chk1 + chk2;
            int i = 0;
            while (i < stringSourceMaxData.length() - 2) {
                stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                ++i;
            }
        } else if (stringSourceMaxData.length() == 3) {
            int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
            int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
            int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));
            if (chk3 >= 5) {
                ++chk2;
            }
            if (chk2 >= 10) {
                ++chk1;
                chk2 = 0;
            }
            stringCreateMaxData = "" + chk1;
            int i = 0;
            while (i < stringSourceMaxData.length() - 1) {
                stringCreateMaxData = String.valueOf(stringCreateMaxData) + "0";
                ++i;
            }
        } else if (stringSourceMaxData.length() == 2) {
            int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
            int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
            if (chk2 >= 5) {
                ++chk1;
            } else if (chk1 > 5) {
                ++chk1;
            }
            stringCreateMaxData = chk1 + "0";
        }
        yScall = Long.parseLong(stringCreateMaxData);
        return yScall;
    }

    public void setChartXScall(int chartXScall) {
        this.chartXScall = chartXScall;
        this.xAxisPoint[0] = chartXScall;
    }

    public void setChartYScall(int chartYScall) {
        this.chartYScall = chartYScall;
        this.xAxisPoint[1] = chartYScall;
        this.pointXY0[1] = chartYScall;
    }

    public int getChartXScall() {
        return this.chartXScall;
    }

    public int getChartYScall() {
        return this.chartYScall;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.zoominImage != null && !this.zoominImage.isDisposed()) {
            this.zoominImage.dispose();
        }
        if (this.zoomoutImage != null && !this.zoomoutImage.isDisposed()) {
            this.zoomoutImage.dispose();
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }
}

