/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.util.logging.Logger;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpagent.AbstractAgentView;
import netjfwatcher.snmpagent.model.AgentMIBCountUpThread;
import netjfwatcher.snmpagent.model.AgentThreadInfo;
import netjfwatcher.snmpagent.model.AgentThreadInfoMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class AgentInstanceControlOperationView
extends AbstractAgentView {
    private static final int TEXT_WIDTH = 200;
    private static final int LIST_WIDTH = 200;
    private static final int LIST_VERTICAL_SPAN = 7;
    private static final int LIST_HEIGHT_HINT = 5;
    private static Logger logger;
    private static final int[] SCROLL_COMPOSITE_SIZE;
    private List threadList;
    private Text oidText;
    private Text descriptionText;
    private Text valueText;
    private Text typeText;
    private Text accessText;
    private Text periodText;
    private Text countUpValueText;
    private Button startButton;
    private Button stopButton;
    private Color textBackColor;

    static {
        SCROLL_COMPOSITE_SIZE = new int[]{800, 300};
    }

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = whiteColor;
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(256));
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("OID");
        label.setLayoutData((Object)new GridData());
        this.oidText = new Text(composite, 2048);
        this.oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.oidText.setEnabled(false);
        this.oidText.setBackground(this.textBackColor);
        this.oidText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Thread List");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("Description");
        label.setLayoutData((Object)new GridData());
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.descriptionText.setEnabled(false);
        this.descriptionText.setBackground(this.textBackColor);
        this.descriptionText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.threadList = new List(composite, 2052);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.threadList.getItemHeight() * 5;
        this.threadList.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("Value");
        label.setLayoutData((Object)new GridData());
        this.valueText = new Text(composite, 2048);
        this.valueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.valueText.setEnabled(false);
        this.valueText.setBackground(this.textBackColor);
        this.valueText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Type");
        label.setLayoutData((Object)new GridData());
        this.typeText = new Text(composite, 2048);
        this.typeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.typeText.setEnabled(false);
        this.typeText.setBackground(this.textBackColor);
        this.typeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Access");
        label.setLayoutData((Object)new GridData());
        this.accessText = new Text(composite, 2048);
        this.accessText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.accessText.setEnabled(false);
        this.accessText.setBackground(this.textBackColor);
        this.accessText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Period(Sec)");
        label.setLayoutData((Object)new GridData());
        this.periodText = new Text(composite, 2048);
        this.periodText.setText("60");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.periodText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Count up value");
        label.setLayoutData((Object)new GridData());
        this.countUpValueText = new Text(composite, 2048);
        this.countUpValueText.setText("10");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.countUpValueText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(2, false);
        Composite compositeBottonAndCommunity = new Composite(baseComposite, 0);
        compositeBottonAndCommunity.setLayoutData((Object)new GridData(256));
        compositeBottonAndCommunity.setLayout((Layout)gridLayout2);
        this.startButton = new Button(compositeBottonAndCommunity, 0);
        this.startButton.setText("Thread Start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.startButton.setLayoutData((Object)gridData);
        this.stopButton = new Button(compositeBottonAndCommunity, 0);
        this.stopButton.setText("Thread Stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.stopButton.setLayoutData((Object)gridData);
        this.stopButton.setEnabled(false);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AgentInstanceControlOperationView.this.stopButton.setEnabled(false);
                if (AgentInstanceControlOperationView.this.oidText.getText().equals("")) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal OID");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.oidText.setFocus();
                    return;
                }
                if (AgentInstanceControlOperationView.this.valueText.getText().equals("")) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal OID value");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.valueText.setFocus();
                    return;
                }
                String oidType = AgentInstanceControlOperationView.this.typeText.getText();
                if (!(oidType.equals("INTEGER") || oidType.equals("Counter32") || oidType.equals("Counter64") || oidType.equals("Gauge32") || oidType.equals("Uinteger32"))) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal OID Type : " + oidType);
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.valueText.setFocus();
                    return;
                }
                try {
                    Integer.parseInt(AgentInstanceControlOperationView.this.valueText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal OID value");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.valueText.setFocus();
                    return;
                }
                int period = 0;
                try {
                    period = Integer.parseInt(AgentInstanceControlOperationView.this.periodText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal period value");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.periodText.setFocus();
                    return;
                }
                if (period < 60) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Please set count period >= 60");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.periodText.setFocus();
                    return;
                }
                int countData = 0;
                try {
                    countData = Integer.parseInt(AgentInstanceControlOperationView.this.countUpValueText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox alertMessageBox = new MessageBox(AgentInstanceControlOperationView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal count up value");
                    alertMessageBox.open();
                    AgentInstanceControlOperationView.this.countUpValueText.setFocus();
                    return;
                }
                AgentInstanceControlOperationView.this.createAgentMIBCountUpThread(period, countData);
                AgentInstanceControlOperationView.this.stopButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = AgentInstanceControlOperationView.this.threadList.getSelectionIndex();
                if (index != -1) {
                    AgentThreadInfo threadInfo = AgentThreadInfoMap.getInstance().getAgentInstanceInfo(AgentInstanceControlOperationView.this.threadList.getItem(index));
                    threadInfo.getAgentThread().interrupt();
                    AgentInstanceControlOperationView.this.threadList.remove(index);
                    AgentInstanceControlOperationView.this.threadList.redraw();
                    AgentInstanceControlOperationView.this.stopButton.setEnabled(false);
                    logger.info("Thread stop oid=" + threadInfo.getAgentThreadControl().getOidInfo().getOid() + "(" + threadInfo.getAgentThreadControl().getOidInfo().getDescrip() + ")");
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.threadList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = AgentInstanceControlOperationView.this.threadList.getSelectionIndex();
                AgentThreadInfo threadInfo = AgentThreadInfoMap.getInstance().getAgentInstanceInfo(AgentInstanceControlOperationView.this.threadList.getItem(index));
                if (threadInfo == null) {
                    return;
                }
                MibInfo oidInfo = threadInfo.getAgentThreadControl().getOidInfo();
                AgentInstanceControlOperationView.this.oidText.setText(oidInfo.getOid());
                AgentInstanceControlOperationView.this.descriptionText.setText(oidInfo.getDescrip());
                AgentInstanceControlOperationView.this.valueText.setText(oidInfo.getValue());
                AgentInstanceControlOperationView.this.typeText.setText(oidInfo.getSyntax());
                AgentInstanceControlOperationView.this.accessText.setText(oidInfo.getAccess());
                AgentInstanceControlOperationView.this.periodText.setText(Integer.toString(threadInfo.getAgentThreadControl().getPeriod()));
                AgentInstanceControlOperationView.this.countUpValueText.setText(Integer.toString(threadInfo.getAgentThreadControl().getIncrementData()));
                AgentInstanceControlOperationView.this.stopButton.setEnabled(true);
            }
        });
    }

    private void createAgentMIBCountUpThread(int period, int countData) {
        AgentMIBCountUpThread agentCountUpThread = new AgentMIBCountUpThread(this.oidText.getText(), period, countData);
        Thread thread = new Thread(agentCountUpThread);
        AgentThreadInfo threadInfo = new AgentThreadInfo();
        threadInfo.setAgentThreadControl(agentCountUpThread);
        threadInfo.setAgentThread(thread);
        AgentThreadInfoMap.getInstance().setAgentInstanceMap(this.oidText.getText(), threadInfo);
        this.threadList.add(this.oidText.getText());
        thread.start();
        logger.info("Thread start oid=" + threadInfo.getAgentThreadControl().getOidInfo().getOid() + "(" + threadInfo.getAgentThreadControl().getOidInfo().getDescrip() + ")");
    }

    public Text getAccessText() {
        return this.accessText;
    }

    public Text getDescriptionText() {
        return this.descriptionText;
    }

    public Text getOidText() {
        return this.oidText;
    }

    public Text getTypeText() {
        return this.typeText;
    }

    public Text getValueText() {
        return this.valueText;
    }
}

