/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.snmpmanager.TrapTableTimerProcessor;
import netjfwatcher.snmpmanager.TrapTableViewContentProvider;
import netjfwatcher.snmpmanager.TrapTableViewLabelProvider;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;
import netjfwatcher.snmpmanager.trap.ThreadTrapReceive;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class TrapReceiveTableView
extends AbstractTableView {
    public static final String TRAP_ALIVE_MESSAGE = "Trap receive status is active";
    public static final String TRAP_DEAD_MESSAGE = "Trap receive status is stop";
    private static final int TRAP_RECEIVE_TIMER = 1000;
    private static boolean isCol0Direction = false;
    private static boolean isCol1Direction = true;
    private static boolean isCol2Direction = true;
    private static boolean isCol3Direction = true;
    private static boolean isCol4Direction = true;
    private static boolean isCol5Direction = true;
    private static boolean isCol6Direction = true;
    private TableColumn col0;
    private TableColumn col1;
    private TableColumn col2;
    private TableColumn col3;
    private TableColumn col4;
    private TableColumn col5;
    private TableColumn col6;
    private static final float COLUMN0NO = 0.03f;
    private static final float COLUMN1VERSION = 0.1f;
    private static final float COLUMN2ENTERPRSE = 0.2f;
    private static final float COLUMN3ADDORESS = 0.1f;
    private static final float COLUMN4GENERIC = 0.1f;
    private static final float COLUMN5SPECIFIC = 0.05f;
    private static final float COLUMN6TIMESTAMP = 0.2f;
    private Table table;
    private TableViewer viewer;
    private TrapTableTimerProcessor timerProcessor;
    private SubStatusLineManager statusLineManager;
    private ActionBuilderTrapReceiveTable actionTrapReceiveTableBuilder;
    private Display display;

    public ActionBuilderTrapReceiveTable getActionBuilder() {
        return this.actionTrapReceiveTableBuilder;
    }

    public void setFocus() {
        this.setStatusLine();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new TrapTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TrapTableViewLabelProvider());
        this.actionTrapReceiveTableBuilder = new ActionBuilderTrapReceiveTable(this.display, this.table, this.statusLineManager);
        this.createContextMenu();
        this.initActions();
        this.startTimer();
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.03f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.2f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.05f);
    }

    private int computeCol6Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.2f);
    }

    private void createTable(Composite parent) {
        this.setStatusLine();
        this.table = new Table(parent, 66304);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.col0 = new TableColumn(this.table, 16384);
        this.col0.setText(TrapTableViewLabelProvider.COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.table, 16384);
        this.col1.setText(TrapTableViewLabelProvider.COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.table, 16384);
        this.col2.setText(TrapTableViewLabelProvider.COLUMNS[2]);
        this.col2.setWidth(this.computeCol1Width());
        this.col3 = new TableColumn(this.table, 16384);
        this.col3.setText(TrapTableViewLabelProvider.COLUMNS[3]);
        this.col3.setWidth(this.computeCol1Width());
        this.col4 = new TableColumn(this.table, 16384);
        this.col4.setText(TrapTableViewLabelProvider.COLUMNS[4]);
        this.col4.setWidth(this.computeCol1Width());
        this.col5 = new TableColumn(this.table, 16384);
        this.col5.setText(TrapTableViewLabelProvider.COLUMNS[5]);
        this.col5.setWidth(this.computeCol1Width());
        this.col6 = new TableColumn(this.table, 16384);
        this.col6.setText(TrapTableViewLabelProvider.COLUMNS[6]);
        this.col6.setWidth(this.computeCol6Width());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                TrapReceiveTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol0Direction = TrapReceiveTableView.this.sortIntegerTable(TrapReceiveTableView.this.table, 0, isCol0Direction);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol1Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 1, isCol1Direction);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol2Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 2, isCol2Direction);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol3Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 3, isCol3Direction);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol4Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 4, isCol4Direction);
            }
        });
        this.col5.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol5Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 5, isCol5Direction);
            }
        });
        this.col6.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol6Direction = TrapReceiveTableView.this.sortTable(TrapReceiveTableView.this.table, 6, isCol6Direction);
            }
        });
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null && this.getSite().getShell().getSize() != null) {
            this.col0.setWidth(this.computeCol0Width());
            this.col1.setWidth(this.computeCol1Width());
            this.col2.setWidth(this.computeCol2Width());
            this.col3.setWidth(this.computeCol3Width());
            this.col4.setWidth(this.computeCol4Width());
            this.col5.setWidth(this.computeCol5Width());
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().getActionStartTrap());
        manager.add(this.getActionBuilder().getActionStopTrap());
        manager.add(this.getActionBuilder().getActionResetTrapTable());
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TrapReceiveTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionBuilder().getActionRestartTrap());
        toolBarManager.add(this.getActionBuilder().getActionStopTrap());
        toolBarManager.add(this.getActionBuilder().getActionStartTrap());
        toolBarManager.add(this.getActionBuilder().getActionResetTrapTable());
    }

    private void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        ThreadTrapReceive trapthread = ThreadTrapReceive.getInstance();
        Thread trapThread = (Thread)EngineThreadList.getInstance().getThread("Trap receive");
        if (trapThread == null || !trapThread.isAlive()) {
            if (trapthread.checkThread()) {
                this.statusLineManager.setMessage(TRAP_ALIVE_MESSAGE);
            } else {
                this.statusLineManager.setMessage(TRAP_DEAD_MESSAGE);
            }
        } else {
            this.statusLineManager.setMessage("Engine Trap receive status is active");
        }
    }

    private void startTimer() {
        TrapTableTimerProcessor.getInstance().setDisplay(this.display);
        TrapTableTimerProcessor.getInstance().setTable(this.table);
        this.timerProcessor = TrapTableTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }
}

