/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.nodetree;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import netjfwatcher.webbrowser.model.DocumentParseErrorHandler;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NodeListXmlParse {
    public static final int NODENAME_NUMBER = 0;
    public static final int IPADDRESS_NUMBER = 1;
    public static final int GROUP_NUMBER = 2;
    public static final int ENGINE_ADDRESS_NUMBER = 3;
    public static final int NODE_X_NUMBER = 4;
    public static final int NODE_Y_NUMBER = 5;
    public static final int NODEKIND_NUMBER = 6;
    public static final int PING_PERIOD_NUMBER = 7;
    public static final int PING_THRESHHOLD_NUMBER = 8;
    public static final int SNMP_VERSION_NUMBER = 9;
    public static final int SNMP_LEVEL_NUMBER = 10;
    public static final int SNMP_PERIOD_NUMBER = 11;
    public static final int SNMP_ROCOMMUNITY_NUMBER = 12;
    public static final int SNMP_RWCOMMUNITY_NUMBER = 13;
    public static final int SNMP_TIMEOUT_NUMBER = 14;
    public static final String[] NODE_INFO_DESCRIBE_ARRAY = new String[]{"NodeName", "IPAddress", "Group", "EngineAddress", "Node_X", "Node_Y", "NodeKind", "Ping_Period", "PingThreshHold", "SNMPVersion", "SNMPLevel", "SNMPPeriod", "SNMPROCommunity", "SNMPRWOCommunity", "SNMPTimeout"};
    public static final int BUFF_SIZE = 512000;
    public static final int NODE_MAX = 500;
    public static final int NODE_LINK_MAX = 500;
    private static Logger logger = null;

    private NodeListXmlParse() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ArrayList loadAndParseNodeList() {
        ArrayList nodeInfoList = null;
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        try {
            dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(true);
            builder = dbfactory.newDocumentBuilder();
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(HttpAccessPreference.getInstance().getNodeListImportUrl());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        if (dom != null) {
            Element root = dom.getDocumentElement();
            Node firstChildNode = root.getFirstChild();
            nodeInfoList = this.parseNode(firstChildNode);
        }
        return nodeInfoList;
    }

    private ArrayList parseNode(Node firstChildNode) {
        Node childNode = firstChildNode;
        while (childNode != null) {
            try {
                if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equals("Node")) {
                    childNode = childNode.getFirstChild();
                    break;
                }
                childNode = childNode.getNextSibling();
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                e.printStackTrace();
            }
        }
        ArrayList<String[]> nodeList = new ArrayList<String[]>();
        while (childNode != null) {
            try {
                if (childNode != null && childNode.getNodeType() == 1) {
                    if (childNode.getNodeName().equals("Node_Property")) {
                        Node nodeInfoChildNodeLeaf = childNode.getFirstChild();
                        boolean hit = false;
                        String[] nodeInfo = new String[NODE_INFO_DESCRIBE_ARRAY.length];
                        while (nodeInfoChildNodeLeaf != null) {
                            if (nodeInfoChildNodeLeaf.getNodeType() == 1) {
                                int i = 0;
                                while (i < NODE_INFO_DESCRIBE_ARRAY.length) {
                                    if (nodeInfoChildNodeLeaf.getNodeName().equals(NODE_INFO_DESCRIBE_ARRAY[i])) {
                                        Node firstNodeText = null;
                                        String leafItemValue = null;
                                        if (nodeInfoChildNodeLeaf != null && (firstNodeText = nodeInfoChildNodeLeaf.getFirstChild()) != null) {
                                            leafItemValue = firstNodeText.getNodeValue();
                                        }
                                        nodeInfo[i] = leafItemValue;
                                        hit = true;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            nodeInfoChildNodeLeaf = nodeInfoChildNodeLeaf.getNextSibling();
                        }
                        if (hit) {
                            nodeList.add(nodeInfo);
                        }
                    }
                    childNode = childNode.getNextSibling();
                }
                childNode = childNode.getNextSibling();
            }
            catch (DOMException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        return nodeList;
    }

    private ArrayList parseLink(Node firstChildNode) {
        ArrayList<String[]> linkList = new ArrayList<String[]>();
        String[] nodeLinkInfo = null;
        Node childNode = firstChildNode;
        while (childNode != null) {
            if (childNode != null && childNode.getNodeType() == 1 && childNode.getNodeName().equals("Link")) {
                childNode = childNode.getFirstChild();
                break;
            }
            childNode = childNode.getNextSibling();
        }
        while (childNode != null) {
            if (childNode != null && childNode.getNodeType() == 1) {
                if (childNode.getNodeName().equals("Link_Property")) {
                    Node nodeInfoChildNodeLeaf = childNode.getFirstChild();
                    boolean hit = false;
                    nodeLinkInfo = new String[2];
                    while (nodeInfoChildNodeLeaf != null) {
                        if (nodeInfoChildNodeLeaf.getNodeType() == 1) {
                            String leafItemValue;
                            Node firstNodeText;
                            if (nodeInfoChildNodeLeaf.getNodeName().equals("NodeX")) {
                                firstNodeText = nodeInfoChildNodeLeaf.getFirstChild();
                                nodeLinkInfo[0] = leafItemValue = firstNodeText.getNodeValue();
                                hit = true;
                            }
                            if (nodeInfoChildNodeLeaf.getNodeName().equals("NodeY")) {
                                firstNodeText = nodeInfoChildNodeLeaf.getFirstChild();
                                nodeLinkInfo[1] = leafItemValue = firstNodeText.getNodeValue();
                                hit = true;
                            }
                        }
                        nodeInfoChildNodeLeaf = nodeInfoChildNodeLeaf.getNextSibling();
                    }
                    if (hit) {
                        linkList.add(nodeLinkInfo);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            childNode = childNode.getNextSibling();
        }
        return linkList;
    }

    public static NodeListXmlParse getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ NodeListXmlParse(NodeListXmlParse nodeListXmlParse) {
        this();
    }

    private static class SingletonResource {
        static final NodeListXmlParse RESOURCE = new NodeListXmlParse(null);

        private SingletonResource() {
        }
    }
}

