/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;

public class CoyoteInputStream
extends ServletInputStream {
    private boolean closed = false;
    private Request coyoteRequest;
    private ByteChunk readChunk = new ByteChunk();
    private int pos = -1;
    private int end = -1;
    private byte[] readBuffer = null;

    void setRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
    }

    void recycle() {
        this.closed = false;
        this.pos = -1;
        this.end = -1;
        this.readBuffer = null;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while (this.pos >= this.end) {
            if (this.readBytes() >= 0) continue;
            return -1;
        }
        return this.readBuffer[this.pos++] & 0xFF;
    }

    public int available() throws IOException {
        if (this.pos < this.end) {
            return this.end - this.pos;
        }
        return 0;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while (this.pos >= this.end) {
            if (this.readBytes() >= 0) continue;
            return -1;
        }
        int n = -1;
        n = this.end - this.pos > len ? len : this.end - this.pos;
        System.arraycopy(this.readBuffer, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        return super.readLine(b, off, len);
    }

    public void close() {
        this.closed = true;
    }

    protected int readBytes() throws IOException {
        int result = this.coyoteRequest.doRead(this.readChunk);
        if (result > 0) {
            this.readBuffer = this.readChunk.getBytes();
            this.end = this.readChunk.getEnd();
            this.pos = this.readChunk.getStart();
        }
        return result;
    }
}

