/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application;

import javax.xml.parsers.FactoryConfigurationError;

import netjfwatcher.engine.top.TopPerspective;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;

/**
 * [Nx`AhoCUNXłB \`̏yяIȂǂs܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetJFWatcherAdvisor extends WorkbenchAdvisor {
	/** [Nx`EBhETitle */
	public static final String TITLE = "NetJFWatcher";

	/** [Nx`\`vtFX */
	public static final String WORKBENCH_CONFIGURER = "WorkbenchConfigurer";

	/** [Nx`EBhEĨvvg\tOvtFX */
	public static final String PROMPT_ON_EXIT_PREFERENCE = "net.sourceforge.eclipsetrader.promptOnExit";

	/* [Nx`EBhEI̊mFbZ[W */
	private static final String CONFIRM_EXIT_MESSAGE = "Exit Eclipse NetJFWatcher ?";

	/* MO */
	private static Logger logger;

	/**
	 * AhoCU[NXCX^X𐶐܂B
	 * 
	 */
	public NetJFWatcherAdvisor() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchAdvisor#initialize(org.eclipse.ui.
	 *      application.IWorkbenchConfigurer)
	 */
	public void initialize(IWorkbenchConfigurer configurer) {
		super.initialize(configurer);

		IPreferenceStore store = NetJFWatcherPlugin.getDefault()
				.getPreferenceStore();

		boolean workBenchConfigSet = store.getBoolean(WORKBENCH_CONFIGURER);

		/*
		 * Workbench̍\`i[AN̍\Ƃ
		 */
		configurer.setSaveAndRestore(workBenchConfigSet);
	
		initLog4j();
	}

	/**
	 * ŏ̃[Nx`EEBhÊ߂Ƀp[XyNeBuID Ԃ܂B ̃\bh́A
	 * AvP[VJnɃ[Nx`쐬鎞ɌĂяo܂B
	 * 
	 * @return p[XyNeBuID
	 */
	public String getInitialWindowPerspectiveId() {
		return TopPerspective.class.getName();
	}

	/**
	 * CxgE[vŗ\ȂO OɋL^邾łB
	 * 
	 * @param exception
	 *            Throwable
	 */
	public void eventLoopException(Throwable exception) {
		logger.error("Unhandled event loop exception.", exception);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchAdvisor#fillActionBars(org.eclipse.ui.
	 *      IWorkbenchWindow, org.eclipse.ui.application.IActionBarConfigurer,
	 *      int)
	 */
	public void fillActionBars(IWorkbenchWindow window,
			IActionBarConfigurer configurer, int flags) {
		if (flags != 0) {
			NetJFWatcherMenuManager.getInstance().fillMenuBar(window,
					configurer);
		}

		if (flags != 0) {
			ICoolBarManager coolBar = configurer.getCoolBarManager();
			coolBar
					.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		}
	}

	/**
	 * [Nx`EBhE̐ݒs܂B
	 * 
	 * @param configurer
	 *            IWorkbenchWindowConfigurer
	 */
	public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.application.WorkbenchAdvisor#preShutdown()
	 */
	public boolean preShutdown() {
		/* [Nx`EBhETCY */
		Point p = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getShell().getSize();
		NetJFWatcherPreference.WORKBENCH_WIDTH.putInt(p.x);
		NetJFWatcherPreference.WORKBENCH_HEIGHT.putInt(p.y);

		/*
		 * [Nx`IɂāAHSQLDBT[oN Shutdown
		 */
		NetJFWatcherMenuManager.getInstance().stopHsqlDB();

		return true;
	}

	/**
	 * Aŏ̃EBhEJOɌĂ΂郁\bhłB
	 * 
	 */
	public void preStartup() {
		super.preStartup();
	}

	/**
	 * [Nx`EBhẼRXgN^Ă΂܂B [Nx`EBhE̍\`s܂B
	 * 
	 * @param configurer
	 *            IWorkbenchWindowConfigurer
	 * 
	 */
	public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
		/* \`ݒ */
		configurer.setInitialSize(new Point(
				NetJFWatcherPreference.WORKBENCH_WIDTH.getInt(),
				NetJFWatcherPreference.WORKBENCH_HEIGHT.getInt()));
		configurer.setTitle(TITLE);

		configurer.setShowMenuBar(true);
		configurer.setShowCoolBar(false);
		configurer.setShowPerspectiveBar(true);
		configurer.setShowStatusLine(true);
		configurer.setShowProgressIndicator(true);
	}

	/**
	 * WorkbenchWindowIɌĂ΂AImFConfirm_CAO\܂B
	 * 
	 * @param configurer
	 *            IWorkbenchWindowConfigurer
	 * @return true allow the window to close.
	 */
	public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
		IPreferenceStore store = NetJFWatcherPlugin.getDefault()
				.getPreferenceStore();
		boolean promptOnExit = store.getBoolean(PROMPT_ON_EXIT_PREFERENCE);

		if (promptOnExit) {
			MessageDialogWithToggle msgDialog = MessageDialogWithToggle
					.openOkCancelConfirm(configurer.getWindow().getShell(),
							"Confirm Exit", CONFIRM_EXIT_MESSAGE,
							"Always exit without prompt", false, null, null);

			if (msgDialog.getReturnCode() != IDialogConstants.OK_ID) {
				return false;
			}

			if (msgDialog.getToggleState()) {
				store.setValue(PROMPT_ON_EXIT_PREFERENCE, false);
				NetJFWatcherPlugin.getDefault().savePluginPreferences();
			}
		}

		return true;
	}

	private void initLog4j() throws FactoryConfigurationError {
		// PreferenceStore`t@CƂĂēǂݍ
		BasicConfigurator.configure();
	}
}
