/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import java.text.Collator;
import java.util.Locale;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;


/**
 * ee[ur[̋@\郁\bh钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractTableView extends ViewPart {
    /** Display */
    protected Display display;

    /** Table */
    protected Table table;

    /** TableViewer */
    protected TableViewer viewer;

    /** 摜肷邽߂PluginResource bundle */
    protected final Bundle bundle =
        NetJFWatcherPlugin.getInstance().getBundle();

    /** Table View̃ANV */
    public ActionBuilder actionBuilder = new ActionBuilder();

    /* TableItem */
    private TableItem[] items;

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#setFocus()
     */
    public void setFocus() {
    }

    /**
     * e[uViewi\`̌ځjԂ܂B
     *
     *
     * @return viewer TableViewer
     */
    public TableViewer getViewer() {
        return viewer;
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
    }

    /**
     * TableԂ܂B
     *
     * @return table Table
     */
    public Table getTable() {
        return table;
    }

    /**
     *
     * @param table \[gΏۃe[u
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @return \[gɃ\[g𔽓]
     */
    public boolean sortIntegerTable(
        Table table, int column, boolean isDirection) {
        return sortIntegerTable(table, column, isDirection, null);
    }

    /**
     * e[uł̃\[g@\ƂInteger^̃\[g@\s\bhłB
     *
     * @param paraTable Table
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @param imageColumn Image܂ރJԍz
     * @return \[gtO𔽓]boolean
     */
    public boolean sortIntegerTable(
        Table paraTable, int column, boolean isDirection, int[] imageColumn) {
        items = paraTable.getItems();

        Object[] array = new Object[items.length];
        Image[][] image = null;

        if (imageColumn != null) {
            image = new Image[items.length][imageColumn.length];
        } else {
            image = new Image[items.length][0];
        }

        for (int i = 0; i < items.length; i++) {
            array[i] = (String[]) (items[i].getData());

            if (imageColumn != null) {
                for (int j = 0; j < imageColumn.length; j++) {
                    image[i][j] = items[i].getImage(imageColumn[j]);
                }
            }
        }

        if (items.length < 2) {
            return isDirection;
        }

        /* \[gɕă\[g */
        if (isDirection) {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];

                    int value1 = Integer.parseInt(work0[column]);
                    int value2 = Integer.parseInt(work1[column]);

                    if (value1 > value2) {
                        array = swap(array, j);
                    }
                }
            }

            isDirection = false;
        } else {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];
                    int value1 = Integer.parseInt(work0[column]);
                    int value2 = Integer.parseInt(work1[column]);

                    if (value1 < value2) {
                        array = swap(array, j);
                    }
                }
            }

            isDirection = true;
        }

        for (int i = 0; i < items.length; i++) {
            String[] strs = (String[]) array[i];
            setTableItem(paraTable, items[i], strs);
        }

        paraTable.redraw();

        return isDirection;
    }

    /**
     * e[uł̃\[g@\ƂDouble^̃\[g@\s\bhłB
     *
     * @param table \[gΏۃe[u
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @return \[gɃ\[g𔽓]
     */
    public boolean sortDoubleTable(
        Table table, int column, boolean isDirection) {
        return sortDoubleTable(table, column, isDirection, null);
    }

    /**
     * e[uł̃\[g@\ƂDouble^̃\[g@\s\bhłB
     *
     * @param paraTable \[gΏۃe[u
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @param imageColumn \[gɂĉ摜f[^܂ރJԍz
     * @return \[gɃ\[g𔽓]
     */
    public boolean sortDoubleTable(
        Table paraTable, int column, boolean isDirection, int[] imageColumn) {
        items = paraTable.getItems();

        Object[] array = new Object[items.length];
        Image[][] image = null;

        if (imageColumn != null) {
            image = new Image[items.length][imageColumn.length];
        } else {
            image = new Image[items.length][0];
        }

        for (int i = 0; i < items.length; i++) {
            array[i] = (String[]) (items[i].getData());

            if (imageColumn != null) {
                for (int j = 0; j < imageColumn.length; j++) {
                    image[i][j] = items[i].getImage(imageColumn[j]);
                }
            }
        }

        if (items.length < 2) {
            return isDirection;
        }

        if (isDirection) {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];

                    double value1 = Double.parseDouble(work0[column]);
                    double value2 = Double.parseDouble(work1[column]);

                    if (value1 > value2) {
                        array = swap(array, j);
                    }
                }
            }

            isDirection = false;
        } else {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];
                    double value1 = Double.parseDouble(work0[column]);
                    double value2 = Double.parseDouble(work1[column]);

                    if (value1 < value2) {
                        array = swap(array, j);
                    }
                }
            }

            isDirection = true;
        }

        for (int i = 0; i < items.length; i++) {
            // items[i].dispose();
            // items[i] = new TableItem(_table, SWT.NONE);
            String[] strs = (String[]) array[i];

            // items[i].setText(strs);
            // items[i].setData(strs);
            setTableItem(paraTable, items[i], strs);
        }

        paraTable.redraw();

        return isDirection;
    }

    /**
     * e[uł̃\[g@\ƂString^̃\[g@\s\bhłB
     *
     * @param table \[gΏۃe[u
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @return \[gɃ\[g𔽓]
     */
    public boolean sortTable(Table table, int column, boolean isDirection) {
        return sortTable(table, column, isDirection, null);
    }

    /**
     * e[uł̃\[g@\ƂString^̃\[g@\s\bhłB
     *
     * @param paraTable \[gΏۃe[u
     * @param column \[gΏۃJ
     * @param isDirection \[g
     * @param imageColumn 摜܂ރJԍz
     * @return \[gɃ\[g𔽓]
     */
    public boolean sortTable(
        Table paraTable, int column, boolean isDirection, int[] imageColumn) {
        items = paraTable.getItems();

        Object[] array = new Object[items.length];
        Image[][] image = null;

        if (imageColumn != null) {
            image = new Image[items.length][imageColumn.length];
        } else {
            image = new Image[items.length][0];
        }

        for (int i = 0; i < items.length; i++) {
            array[i] = (String[]) (items[i].getData());

            if (imageColumn != null) {
                for (int j = 0; j < imageColumn.length; j++) {
                    image[i][j] = items[i].getImage(imageColumn[j]);
                }
            }
        }

        Collator collator = Collator.getInstance(Locale.getDefault());

        if (isDirection) {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];

                    if (collator.compare(work0[column], work1[column]) < 0) {
                        array = swap(array, j);
                    } else if (
                        collator.compare(work0[column], work1[column]) == 0) {
                        array = reswap(array, j, isDirection);
                    }
                }
            }

            isDirection = false;
        } else {
            for (int i = 0; i < (items.length - 1); i++) {
                for (int j = items.length - 1; j > i; j--) {
                    String[] work0 = (String[]) array[j];
                    String[] work1 = (String[]) array[j - 1];

                    if (collator.compare(work0[column], work1[column]) > 0) {
                        array = swap(array, j);
                    } else if (
                        collator.compare(work0[column], work1[column]) == 0) {
                        array = reswap(array, j, isDirection);
                    }
                }
            }

            isDirection = true;
        }

        for (int i = 0; i < items.length; i++) {
            // items[i].dispose();
            // items[i] = new TableItem(_table, SWT.NONE);
            String[] strs = (String[]) array[i];

            setTableItem(paraTable, items[i], strs);
        }

        paraTable.redraw();

        return isDirection;
    }

    /**
     * TableViewrpNXŃI[o[Chꂽꍇɂ́A
     * e[ũJ/ẼtHAOh/obNOhColor
     * ̐ݒȂǂs܂B
     *
     * @param paraTable Table
     * @param item TableItem
     * @param strs TableItemɃZbg镶z
     * @return TableItem
     */
    protected TableItem setTableItem(
        final Table paraTable, TableItem item, final String[] strs) {
        item.dispose();
        item = new TableItem(paraTable, SWT.NONE);

        item.setText(strs);
        item.setData(strs);

        return item;
    }

    /**
     * Objectz̎wʒuswapĕԂ܂B
     *
     * @param object swapObjectz
     * @param rowPosition swapObjectzʒu
     * @return swapObjectz
     */
    protected Object[] swap(Object[] object, int rowPosition) {
        Object work = object[rowPosition];
        object[rowPosition] = object[rowPosition - 1];
        object[rowPosition - 1] = work;

        TableItem workItem = items[rowPosition];
        items[rowPosition] = items[rowPosition - 1];
        items[rowPosition - 1] = workItem;

        return object;
    }

    /**
     * Objectzswap܂B
     * (\[grœꌋʂ̏ꍇɕʏɂčă\[gꍇɌĂ΂܂)
     *
     * @param object \[gIuWFNgz
     * @param rowPosition \[gsʒu
     * @param isDirection \[g
     * @return \[g̃IuWFNgz
     */
    protected Object[] reswap(
        Object[] object, int rowPosition, boolean isDirection) {
        String[] work0 = (String[]) object[rowPosition];
        String[] work1 = (String[]) object[rowPosition - 1];

        int value1 = 0;
        int value2 = 0;

        try {
            value1 = Integer.parseInt(work0[0]);
            value2 = Integer.parseInt(work1[0]);
        } catch (NumberFormatException e) {
            // nothing
        }

        if (isDirection) {
            if (value1 < value2) {
                Object work = object[rowPosition];
                object[rowPosition] = object[rowPosition - 1];
                object[rowPosition - 1] = work;

                TableItem workItem = items[rowPosition];
                items[rowPosition] = items[rowPosition - 1];
                items[rowPosition - 1] = workItem;
            }
        } else {
            if (value1 > value2) {
                Object work = object[rowPosition];
                object[rowPosition] = object[rowPosition - 1];
                object[rowPosition - 1] = work;

                TableItem workItem = items[rowPosition];
                items[rowPosition] = items[rowPosition - 1];
                items[rowPosition - 1] = workItem;
            }
        }

        return object;
    }

    /**
     * Table ViewANVNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionBuilder {
    }
    
    
    protected abstract void setResizedTableColumnWidth();
    
    
}