/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;


/**
 * JVM GarbageCollection[f[^e[u𑀍삷郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableGarbageCollection extends DBTableBase {
    /** Ko[WRNVe[u */
    public static final String GARBAGECOLLECTION_TABLE =
        "garbageCollection_table";

    /** ID J */
    public static final String ID = "id";

    /** g[^[ J */
    public static final String TOTAL_MEMORY = "total_memory";

    /** t[[ J */
    public static final String FREE_MEMORY = "free_memory";

    /** `FbN J */
    public static final String CHECK_DATE = "check_date";

    /* MO */
    private static Logger logger = null;

    /* tH[}bg */
    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * VOgCX^X𐶐܂B
     *
     */
    private DBTableGarbageCollection() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * VOgCX^XԂ܂B
     *
     * @return CX^X
     */
    public static DBTableGarbageCollection getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * Alarme[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {
        // DatabaseAccess databaseAccess = new DatabaseAccess();
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        // e[u폜
        try {
            this.deleteTable(databaseAccess, GARBAGECOLLECTION_TABLE);
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        try {
            // e[ũV[PXe[u폜iPostgreSQLpj
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropGarbageCollectionSequenceSQL());

            // e[u
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateGarbageCollectionTableSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Alarme[u폜܂B
     * ܂Af[^x[XPostgreSQL̏ꍇ́AV[PXe[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            this.deleteTable(databaseAccess, GARBAGECOLLECTION_TABLE);

            // this.dropSequence(databaseAccess, dataaccessobject.getDrop_alarm_table_sequence());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * GarbageCollection[e[uɃ[TCYi[܂B
     *
     * @param totalMemory GarbageCollection g[^[
     * @param freeMemory GarbageCollectiont[[
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void put(final String totalMemory, final String freeMemory)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            Date date = Calendar.getInstance().getTime();

            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                databaseAccess.executeUpdate(
                    "insert into " + GARBAGECOLLECTION_TABLE + "( "
                    + TOTAL_MEMORY + ", " + FREE_MEMORY + ", " + CHECK_DATE
                    + " )" + " VALUES( " + totalMemory + "," + freeMemory
                    + "," + " '" + simpleDateformat.format(date) + "'" + ")");
            } else {
                databaseAccess.executeUpdate(
                    "insert into " + GARBAGECOLLECTION_TABLE + "( "
                    + TOTAL_MEMORY + ", " + FREE_MEMORY + ", " + CHECK_DATE
                    + " )" + " VALUES( " + "'" + totalMemory + "'," + "'"
                    + freeMemory + "'," + " '" + simpleDateformat.format(date)
                    + "'" + ")");
            }

            // databaseAccess.executeUpdate("commit");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }

    }

    /**
     * wԓ̍̎Ag[^AFreeAIDCX^X
     * ɃZbgXgf[^Ԃ܂B
     *
     * @param startTime Jn
     * @param endTime I
     * @return garbageCollectionInfoList GarbageCollection[񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findAll(
        final String startTime, final String endTime)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList garbageCollectionInfoList = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            /* sql̍쐬
             */
            String sql;

            if ((startTime == null) || (endTime == null)) {
                sql = "SELECT * from " + GARBAGECOLLECTION_TABLE + " order by "
                    + CHECK_DATE + " desc";
            } else {
                sql = "SELECT * from " + GARBAGECOLLECTION_TABLE + " where "
                    + CHECK_DATE + " between " + "'" + startTime + "'"
                    + " and " + "'" + endTime + "'" + " order by " + CHECK_DATE
                    + " desc";
            }

            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);
            garbageCollectionInfoList = new ArrayList();

            while (rs.next()) {
                GarbageCollectionInfo garbageCollectionInfo =
                    new GarbageCollectionInfo();

                /* ̎Zbg */
                garbageCollectionInfo.setCheckDate(
                    (Date) rs.getObject(CHECK_DATE));

                /* g[^lZbg */
                garbageCollectionInfo.setTotalMemory(
                    Long.parseLong(rs.getObject(TOTAL_MEMORY).toString()));

                /* FreelZbg */
                garbageCollectionInfo.setFreeMemory(
                    Long.parseLong(rs.getObject(FREE_MEMORY).toString()));

                /* ̎IDZbg */
                garbageCollectionInfo.setCheckId(
                    Long.parseLong(rs.getObject(ID).toString()));

                garbageCollectionInfoList.add(garbageCollectionInfo);
            }
        } catch (DatabaseConnectionException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return garbageCollectionInfoList;
    }

    /**
     *  GarbageCollection[e[üȉ̃f[^擾܂B
     *
     * Ef[^
     * Eőyэŏf[^
     * E̎
     *
     * @return garProperty GarbageCollection[
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized GarbageCollectionControl getDataCount()
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        GarbageCollectionControl garProperty = new GarbageCollectionControl();

        try {
            // SQLXe[ggIuWFNg̍쐬
            //sql̍쐬
            String sql =
                "select count(*) from "
                + DBTableGarbageCollection.GARBAGECOLLECTION_TABLE;

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            rs.next();

            long count = -1;
            count = rs.getInt(1);

            garProperty.setTotalDataCount(count);

            sql = "select min(" + FREE_MEMORY + "), max(" + FREE_MEMORY
                + "), min(" + TOTAL_MEMORY + "), max(" + TOTAL_MEMORY
                + ") from " + DBTableGarbageCollection.GARBAGECOLLECTION_TABLE;
            rs = stmt.executeQuery(sql);
            rs.next();

            long freeMemoryMin = -1;
            freeMemoryMin = rs.getLong(1);

            long freeMemoryMax = -1;
            freeMemoryMax = rs.getLong(2);
            garProperty.setFreeMemoryMinData(freeMemoryMin);
            garProperty.setFreeMemoryMaxData(freeMemoryMax);

            long totalMemoryMin = -1;
            totalMemoryMin = rs.getLong(3);

            long totalMemoryMax = -1;
            totalMemoryMax = rs.getLong(4);
            garProperty.setTotalMemoryMinData(totalMemoryMin);
            garProperty.setTotalMemoryMaxData(totalMemoryMax);

            /* ̎JnyэŐV̎Zbg */
            sql = "select min(" + CHECK_DATE + "), max(" + CHECK_DATE
                + ") from " + DBTableGarbageCollection.GARBAGECOLLECTION_TABLE;
            rs = stmt.executeQuery(sql);
            rs.next();

            garProperty.setStartDate((Date) rs.getObject(1));
            garProperty.setEndDate((Date) rs.getObject(2));
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return garProperty;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableGarbageCollection RESOURCE =
            new DBTableGarbageCollection();
    }
}
