/*
 * Created on 2004/04/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;



/**
 * f[^x[X܂B
 *
 * f[^x[XMySQL̏ꍇɂ́Agpf[^x[Xinodewatchj𐶐܂B
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MySQLDatabaseInit {
    /** MySQLp̃f[^x[XSQL */
    public static final String CREATE =
        "CREATE DATABASE " + AbstractDataAccessObject.MYSQL_USE_DATABASE;

    /** MySQLp̃f[^x[X폜SQL */
    public static final String DROP =
        "DROP DATABASE IF EXISTS " + AbstractDataAccessObject.MYSQL_USE_DATABASE;

    /*  */
    private static Logger logger = null;

    /**
     * f[^x[XMySQL̏ꍇɃf[^x[X𐶐܂B
     *
     * @throws IllegalAccessException JDBChCoCX^X
     * sꍇ
     * @throws InstantiationException JDBChCoCX^X
     * sꍇ
     * @throws ClassNotFoundException JDBChCoȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void createDatabase()
        throws IllegalAccessException, InstantiationException,
            ClassNotFoundException, SQLException {
        String jdbcdriver;
        String url;
        String username;
        String password;

        logger = Logger.getLogger(this.getClass().getName());

        /* f[^x[XvpeB擾 */
        AbstractDataAccessObject databaseProp =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        jdbcdriver = databaseProp.getDriver();
        url = databaseProp.getDatabaseurl();
        username = databaseProp.getUser();
        password = databaseProp.getPassword();

        Statement stmt = null;
        Connection con = null;

        try {
            // JDBC Driver ̓o^
            Class.forName(jdbcdriver).newInstance();

            // f[^x[Xւ̐ڑ
            con = DriverManager.getConnection(url, username, password);

            // SQL Xe[ggEIuWFNg̍쐬
            stmt = con.createStatement();
            logger.info(
                "Database Kind : "
                + DatabaseAccessControlKind.getInstance().getDatabaseName());

            // f[^x[X폜
            stmt.executeUpdate(DROP);

            // f[^x[X쐬 nodewatch
            stmt.executeUpdate(CREATE);
        } catch (SQLException e) {
            logger.warning(
                "URL = " + url + " : User = " + username + " : Password = "
                + password);
            logger.severe(e.getMessage());
            e.printStackTrace();
            throw e;
        } catch (IllegalAccessException e) {
            logger.severe(
                "IllegalAccessException " + jdbcdriver + " " + e.getMessage());
            throw e;
        } catch (InstantiationException e) {
            logger.severe(
                "InstantiationException " + jdbcdriver + " " + e.getMessage());
            throw e;
        } catch (ClassNotFoundException e) {
            logger.severe(
                "ClassNotFoundException " + jdbcdriver + " " + e.getMessage());

            throw e;
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (con != null) {
                try {
                    con.close();
                } catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }
}
