/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.control;

import java.util.HashMap;
import java.util.logging.Logger;


/**
 * R}h}bsOe[u
 * {@link suncertify.command.CommandMappingTableResource} 
 * R}hIDɑΉR}hsCX^X擾邽
 * ̃NXłB<BR>
 *
 * ̃NXCX^X͂̓VOgEIuWFNgłB<BR>
 *
 * R}hsR}hRg[
 * {@link suncertify.command.ControllerCommand} ɁAIDɑΉ
 * R}hۃNX̃CX^X񋟂܂B<BR>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class CommandMappingTableController {
    /*
     * R}h}bsOe[uAR}hIDL[Ƃ
     * R}hۃNX̃CX^Xi[Hashe[u
     */
    private static HashMap<Object, Object> commandMap = new HashMap<Object, Object>();

    /* logging */
    private static Logger logger;

    /**
     * R}h}bsOe[u\[XǂݍŁAR}hID
     * L[ƂR}hۃNX̃CX^XHashe[u
     * ɓo^܂B<BR>
     *
     */
    private CommandMappingTableController() {
        CommandMappingTable mappingTbaleResource =
            new CommandMappingTable();

        /* R}h}bsOe[uIDƃCX^X1Zbg
         * 2z */
        Object[][] mappingTable = mappingTbaleResource.getCommandMappingTable();

        /* IDL[ƂăCX^XHashɓo^ */
        for (int i = 0; i < mappingTable.length; i++) {
            commandMap.put(mappingTable[i][0], mappingTable[i][1]);
        }
    }

    /**
     * R}h}bsOe[uRg[NX̃CX^X
     * Ԃ܂BiNXێĂVOgEIuWF
     * NgԂ܂j<BR>
     *
     * @return uniqueInstance R}h}bsOe[uRg[
     * NX̃CX^X
     */
    public static CommandMappingTableController getInstance() {
        return SingletonCommandMappingTableController.uniqueInstance;
    }

    /**
     * R}hIDɑΉR}hۃNX̃CX^XԂ
     * ܂B<BR>
     *
     * @param commandId R}hID
     * @return commandInstance R}hۃCX^X
     */
    public ICommand getCommandInstance(final String commandId) {
        ICommand commandInstance = null;
        logger = Logger.getLogger(this.getClass().getName());

        if (commandMap.containsKey(commandId)) {
            commandInstance = (ICommand) commandMap.get(commandId);
        } else {
            // assert false : "Abort Command@Instance";
            logger.warning("Not found in Command mapping table : " + commandId);
        }

        return commandInstance;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonCommandMappingTableController {
        private static CommandMappingTableController uniqueInstance =
            new CommandMappingTableController();
    }
}
