/*
 * Created on 2005/01/05
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.preference.SnmpPreference;

/**
 * m[hSnmp VXeMIByуC^tF[XMIB̎悵Af[^x[XXV܂B
 * ́Am[hViewł̃f[^XV{^ȂǂŋN܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandGetNodeSnmp extends TemplateCommandImpl {

	private static Logger logger;

	/**
	 * SystemyуC^tF[XMIB̎sAf[^x[Xe[uɊi[܂B
	 * 
	 * @param com
	 *            R}h
	 * @param ois
	 *            ̓Xg[
	 * @param oos
	 *            o̓Xg[
	 */
	public void doInvoke(CommandInfo com, ObjectInputStream ois,
			ObjectOutputStream oos) {
		logger = Logger.getLogger(this.getClass().getName());

		NodeInformation nodeInfo = null;

		DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
				.getInstance();

		try {
			ArrayList list = nodeRegisterDBTable.findTarget(com.getIpaddress());

			if (list.size() > 0) {
				nodeInfo = (NodeInformation) list.get(0);
			}
		} catch (SQLException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} catch (Exception e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} finally {
			nodeRegisterDBTable = null;
		}

		/*
		 * wm[h̃f[^x[XSystem MIByуC^tF[XMIbXV if[^x[XXV݂̂Webւ̉Ƃ͂Ȃj
		 */
		String snmpVersion = nodeInfo.getSnmpVersion();
		int version = 0;

		if (snmpVersion.equals("SNMPV1")) {
			version = SnmpPreference.SNMP_VERSION_1;
		} else if (snmpVersion.equals("SNMPV2C")) {
			version = SnmpPreference.SNMPV2C;
		} else if (snmpVersion.equals("SNMPV3")) {
			version = SnmpPreference.SNMPV3;
		} else {
			logger.warning("Bad snmp version : " + snmpVersion);
		}

		SnmpSystemMibGet systemMib = null;
		SnmpInterfacesMibGet mibInterfacesGet = null;

		try {
			// logger.info("System MIB");

			// wm[hSystem MIB擾
			systemMib = new SnmpSystemMibGet();
			systemMib.setSnmpSystemMibGet(nodeInfo.getIpaddress(), version,
					nodeInfo.getRoCommunity());
			systemMib.getSystemMIB();
			// logger.info("Interfaces MIB");

			// wm[hInterfaces MIB擾
			mibInterfacesGet = new SnmpInterfacesMibGet();
			mibInterfacesGet.setSnmpInterfacesMibGet(nodeInfo.getIpaddress(),
					version, nodeInfo.getRoCommunity());
			mibInterfacesGet.getInterfacesMIB();
		} catch (UnknownHostException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (SocketException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} catch (SnmpMIBGetException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		}
        // Printerm[h̏ꍇPrinter MIB擾
		if (nodeInfo.getNodeKind().equals(NodeKind.PRINTER)) {
			SnmpPrintMibGet printMibGetInstance = new SnmpPrintMibGet();
			printMibGetInstance.setSnmpPrintMibGet(nodeInfo.getIpaddress(),
					version, nodeInfo.getRoCommunity());
			try {
				printMibGetInstance.getPrintMIB();
			} catch (Exception e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		sendResponse(nodeInfo, ois, oos);
	}
}
