/*
 * Created on 2004/05/02
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.server.protocol.snmp.ExecuteStatisticsMibGet;



/**
 * SNMPvMIB̎sThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckStatisticsMibGet implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger;

    /**
     * SNMPvMIB̎sThreadNXCX^X𐶐܂B
     *
     */
    public ThreadQueueCheckStatisticsMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IɃL[`FbNAL[Ƀf[^ΓvMIB̎s܂B
     *
     */
    public void run() {
        ExecuteStatisticsMibGet statisticsMibGet =
            new ExecuteStatisticsMibGet();

        //IQueue Check[v
        while (!Thread.interrupted()) {
            // L[Pop
            OidGetInfo oidGetInfo =
                QueueForStatisticsMib.getInstance().popQueue();

            NodeWatchInfo checkIPAddress = null;

            if (oidGetInfo != null) {
                checkIPAddress =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        oidGetInfo.getTargetIpAddress());
            }

            // L[Ƀf[^Statistics Mib Gets
            if ((oidGetInfo != null) && (checkIPAddress != null)) {
                String targetIpAddress = oidGetInfo.getTargetIpAddress();
                String targetOid = oidGetInfo.getTargetOid();
                String community = oidGetInfo.getROCommunity();
                int version = oidGetInfo.getVersion();
                statisticsMibGet.execute(
                    targetIpAddress, version, community, targetOid,
                    oidGetInfo.getThreshHold(), oidGetInfo.getThreshHoldType());
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
