/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.snmp.preference.SnmpPreference;



/**
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ManagerMPQueue {
    /*  */
    private static Map flyweightMap =
        Collections.synchronizedMap(new HashMap());

    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    private ManagerMPQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * w̃G[WFgAddressSnmp versionManager Message
     * ProcessingCX^X𐶐ĕԂ܂B
     *
     * @param addressKey Agnetm[hIPAhX
     * @param version SNMPo[W
     * @return mp SNMP}l[WbZ[WvZX
     */
    public synchronized AbstractManagerMessageProcessingSubsystem popQueue(
        String addressKey, int version) {
        /*  */
        String versionString = Integer.toString(version);

        if (flyweightMap.containsKey(addressKey + versionString)) {
            return (AbstractManagerMessageProcessingSubsystem) flyweightMap.get(
                addressKey + versionString);
        }

        AbstractManagerMessageProcessingSubsystem mp = null;

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            mp = new ManagerV1MP();

            break;

        case SnmpPreference.SNMPV2C:
            mp = new ManagerV2MP();

            break;

        case SnmpPreference.SNMPV3:
            mp = new ManagerV3MP();

            break;

        default:
            logger.warning("Bad Snmp version: " + version);

            return null;
        }

        flyweightMap.put(addressKey + versionString, mp);

        return mp;
    }

    /**
     * 
     * 
     * @param addressKey
     */
    public synchronized void removeMP(String addressKey) {
        flyweightMap.remove(addressKey);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ManagerMPQueue getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ManagerMPQueue DBPOOL = new ManagerMPQueue();
    }
}
