/*
 * Created on 2003/08/02
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.Serializable;
import java.util.ArrayList;

import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.socket.info.AuthenticationInfo;
import netjfwatcher.engine.socket.info.DatabasePropertyInfoList;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.InterfaceControl;
import netjfwatcher.engine.socket.info.InterfaceData;
import netjfwatcher.engine.socket.info.MailSendTestInformation;
import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.socket.info.PingCommandInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * GWƒʐM邽߂̃R}hێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandInfo implements Serializable {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 2401227939639378625L;

    /* R}hR[h */
    private String code;

    /* ^[QbgƂȂm[hIPAhX */
    private String ipaddress;

    /* m[hĎ */
    private NodeInformation nodeInformation;

    /* m[hĎ */
    private ArrayList nodeInformationList;

    /* A[ */
    private AlarmInformation alarmInformation;

    /* A[tB^[ */
    private AlarmViewFilter alarmFilterInfo;

    /* m[hMapN */
    private NodeMapLinkInformation nodeMapLinkInfo;

    /* SNMP MIB */
    private MibInfo mibInfo;

    /* SNMP Interface */
    private InterfaceData interfaceData;

    /* SNMP Interface */
    private InterfaceControl interfaceControl;

    /* SNMPvMIB */
    private StatisticsMibProperty statisticsMibInfo;

    /* SNMPvMIB */
    private StatisticsMibControl statisticsMibControl;

    /* PingĎ */
    private PingCommandInfo pingCommandInfo;

    /* ^XNXPW[ */
    private TaskScheduleInfo taskScheduleInfo;

    /* \[X */
    private ResourceInfo resourceInfo;

    /* MailMeXg */
    private MailSendTestInformation mailSendtestInfo;

    /* f[^x[XvpeBXg */
    private DatabasePropertyInfoList databasePropList;

    /* GarbageCollection̎搧 */
    private GarbageCollectionControl garbageCollectionControlInfo;

    private AuthenticationInfo authInfo;
    /**
     * R}hR[hԂ܂B
     *
     * @return Code R}hR[h
     */
    public String getCode() {
        return code;
    }

    /**
     * IPAhXԂ܂B
     *
     * @return ipaddress IPAhX
     */
    public String getIpaddress() {
        return ipaddress;
    }

    /**
     * R}hR[hZbg܂B
     *
     * @param string R}hR[h
     */
    public void setCode(String string) {
        code = string;
    }

    /**
     * IPAhXZbg܂B
     *
     * @param string IPAhX
     */
    public void setIpaddress(String string) {
        ipaddress = string;
    }

    /**
     * \[XԂ܂B
     *
     * @return resourceInfo \[X
     */
    public ResourceInfo getResourceInfo() {
        return resourceInfo;
    }

    /**
     * \[XZbg܂B
     *
     * @param info \[X
     */
    public void setResourceInfo(ResourceInfo info) {
        resourceInfo = info;
    }

    /**
     * MailMeXgԂ܂B
     *
     * @return mailSendtestInfo MailMeXg
     */
    public MailSendTestInformation getMailSendtestInfo() {
        return mailSendtestInfo;
    }

    /**
     * MailMeXgZbg܂B
     *
     * @param information MailMeXg
     */
    public void setMailSendtestInfo(MailSendTestInformation information) {
        mailSendtestInfo = information;
    }

    /**
     * f[^x[XvpeBXgԂ܂B
     *
     * @return databasePropList f[^x[XvpeBXg
     */
    public DatabasePropertyInfoList getDatabasePropList() {
        return databasePropList;
    }

    /**
     * f[^x[XvpeBXgZbg܂B
     *
     * @param list f[^x[XvpeBXg
     */
    public void setDatabasePropList(DatabasePropertyInfoList list) {
        databasePropList = list;
    }

    /**
     * ^XNXPW[Ԃ܂B
     *
     * @return taskScheduleInfo ^XNXPW[
     */
    public TaskScheduleInfo getTaskScheduleInfo() {
        return taskScheduleInfo;
    }

    /**
     * ^XNXPW[Zbg܂B
     *
     * @param info ^XNXPW[
     */
    public void setTaskScheduleInfo(TaskScheduleInfo info) {
        taskScheduleInfo = info;
    }

    /**
     * MIB̎Ԃ܂B
     *
     * @return mibInfo MIB̎
     */
    public MibInfo getMibInfo() {
        return mibInfo;
    }

    /**
     * MIB̎Zbg܂B
     *
     * @param info MIB̎
     */
    public void setMibInfo(MibInfo info) {
        mibInfo = info;
    }

    /**
     * GarbageCollection̎搧Ԃ܂B
     *
     * @return garbageCollectionControlInfo GarbageCollection̎搧
     */
    public GarbageCollectionControl getGarbageCollectionControlInfo() {
        return garbageCollectionControlInfo;
    }

    /**
     * GarbageCollection̎搧Zbg܂B
     *
     * @param control GarbageCollection̎搧
     */
    public void setGarbageCollectionControlInfo(
        GarbageCollectionControl control) {
        garbageCollectionControlInfo = control;
    }

    /**
     * PingĎԂ܂B
     *
     * @return pingCommandInfo PingĎ
     */
    public PingCommandInfo getPingCommandInfo() {
        return pingCommandInfo;
    }

    /**
     * PingĎZbg܂B
     *
     * @param info PingĎ
     */
    public void setPingCommandInfo(PingCommandInfo info) {
        pingCommandInfo = info;
    }

    /**
     * SNMP MIBvԂ܂B
     *
     * @return statisticsMibInfo SNMP MIBv
     */
    public StatisticsMibProperty getStatisticsMibInfo() {
        return statisticsMibInfo;
    }

    /**
     * SNMP MIBvZbg܂B
     *
     * @param property SNMP MIBv
     */
    public void setStatisticsMibInfo(StatisticsMibProperty property) {
        statisticsMibInfo = property;
    }

    /**
     * SNMP MIBv̎ݒԂ܂B
     *
     * @return statisticsMibControl SNMP MIBv̎ݒ
     */
    public StatisticsMibControl getStatisticsMibControl() {
        return statisticsMibControl;
    }

    /**
     * SNMP MIBv̎ݒZbg܂B
     *
     * @param control SNMP MIBv̎ݒ
     */
    public void setStatisticsMibControl(StatisticsMibControl control) {
        statisticsMibControl = control;
    }

    /**
     * m[hĎԂ܂B
     *
     * @return  nodeInformation m[hĎ
     */
    public NodeInformation getNodeInformation() {
        return nodeInformation;
    }

    /**
     * m[hĎZbg܂B
     *
     * @param information m[hĎ
     */
    public void setNodeInformation(NodeInformation information) {
        nodeInformation = information;
    }

    /**
     * m[hMapNԂ܂B
     *
     * @return m[hMapN
     */
    public NodeMapLinkInformation getNodeMapLinkInfo() {
        return nodeMapLinkInfo;
    }

    /**
     * m[hMapNZbg܂B
     *
     * @param information m[hMapN
     */
    public void setNodeMapLinkInfo(NodeMapLinkInformation information) {
        nodeMapLinkInfo = information;
    }

    /**
     * Interface MIBݒԂ܂B
     *
     * @return interfaceControl Interface MIBݒ
     */
    public InterfaceControl getInterfaceControl() {
        return interfaceControl;
    }

    /**
     * Interface MIBԂ܂B
     *
     * @return interfaceData@Interface MIB
     */
    public InterfaceData getInterfaceData() {
        return interfaceData;
    }

    /**
     * Interface MIBݒZbg܂B
     *
     * @param control Interface MIBݒ
     */
    public void setInterfaceControl(InterfaceControl control) {
        interfaceControl = control;
    }

    /**
     * Interface MIBZbg܂B
     *
     * @param data Interface MIB
     */
    public void setInterfaceData(InterfaceData data) {
        interfaceData = data;
    }

    /**
     * A[Ԃ܂B
     *
     * @return alarmInformation@A[
     */
    public AlarmInformation getAlarmInformation() {
        return alarmInformation;
    }

    /**
     * A[Zbg܂B
     *
     * @param information A[
     */
    public void setAlarmInformation(AlarmInformation information) {
        alarmInformation = information;
    }

    /**
     * A[tB^[Ԃ܂B
     * @return alarmFilterInfo A[tB^[
     */
    public AlarmViewFilter getAlarmFilterInfo() {
        return alarmFilterInfo;
    }

    /**
     * A[tB^[Zbg܂B
     *
     * @param filter A[tB^[
     */
    public void setAlarmFilterInfo(AlarmViewFilter filter) {
        alarmFilterInfo = filter;
    }

    /**
     * m[hĎ񃊃XgԂ܂B
     *
     * @return nodeInformationList m[hĎ񃊃Xg
     */
    public ArrayList getNodeInformationList() {
        return nodeInformationList;
    }

    /**
     * m[hĎ񃊃XgZbg܂B
     *
     * @param nodeInformationList m[hĎ񃊃Xg
     */
    public void setNodeInformationList(ArrayList nodeInformationList) {
        this.nodeInformationList = nodeInformationList;
    }

	public AuthenticationInfo getAuthInfo() {
		return authInfo;
	}

	public void setAuthInfo(AuthenticationInfo authInfo) {
		this.authInfo = authInfo;
	}
}
