/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;



/**
 * SNMP PDUƂĈȉ̏񂩂\PDUێNXłB
 *
 * +--------+--------------+-------------+------------+
 * |   ID   | Error Status | Erroe Index |   varList  |
 * +--------+--------------+-------------+------------+
 */
public class SnmpPDU extends SnmpSequence {
    /** PDUł̃NGXgID̈ʒu */
    public static final int PDU_REQUEST_ID_POS = 0;

    /** PDUł̃G[Xe[^Ẍʒu */
    public static final int PDU_ERROR_STATUS_POS = 1;

    /** PDUł̃G[Indeẍʒu */
    public static final int PDU_ERROR_INDEX_POS = 2;

    /** PDUłVar Lisẗʒu */
    public static final int PDU_VARLIST_POS = 3;

    /* PDU Contentsێ郊Xg */
    private List contents;

    /**
     * SNMP PDUIuWFNgCX^X𐶐܂B
     *
     */
    public SnmpPDU() {
        super();
        contents = Collections.synchronizedList(new ArrayList());
    }

    /**
     * SNMP PDUIuWFNgCX^X𐶐܂B
     *
     * @param pduType PDU Type
     * @param requestID NGXgID
     * @param errorStatus Error status
     * @param errorIndex Error Index
     * @param varList Variable List
     * @throws SnmpBadValueException p[^ُȏꍇ
     */
    public SnmpPDU(
        final byte pduType, final int requestID, final int errorStatus,
        final int errorIndex, final SnmpSequence varList)
        throws SnmpBadValueException {
        super();

        contents = Collections.synchronizedList(new ArrayList());
        tag = pduType;
        contents.add(PDU_REQUEST_ID_POS, new SnmpInteger(requestID));
        contents.add(PDU_ERROR_STATUS_POS, new SnmpInteger(errorStatus));
        contents.add(PDU_ERROR_INDEX_POS, new SnmpInteger(errorIndex));
        contents.add(PDU_VARLIST_POS, varList);
        this.setValue(contents);
    }

    /**
     * ASN.1 BERGR[fBOoCgzf[^PDU^CvSNMP PDU
     * IuWFNg𐶐܂B
     *
     * @param enc BERGR[fBOoCgzf[^
     * @param pduType PDU^Cv
     * @throws SnmpBadValueException SNMP PDUɎsꍇ
     */
    public SnmpPDU(byte[] enc, byte pduType) throws SnmpBadValueException {
        tag = pduType;
        extractFromBEREncoding(enc);
    }

    /**
     * SNMP PDU̒lZbg܂B
     *
     * @param pduType PDU^Cv
     * @param requestID NGXgID
     * @param errorStatus G[Xe[^X
     * @param errorIndex G[Index
     * @param varList var List
     * @throws SnmpBadValueException Zbglُȏꍇ
     */
    public void setSNMPPDU(
        final byte pduType, final int requestID, final int errorStatus,
        final int errorIndex, final SnmpSequence varList)
        throws SnmpBadValueException {
        contents.clear();
        tag = pduType;
        contents.add(PDU_REQUEST_ID_POS, new SnmpInteger(requestID));
        contents.add(PDU_ERROR_STATUS_POS, new SnmpInteger(errorStatus));
        contents.add(PDU_ERROR_INDEX_POS, new SnmpInteger(errorIndex));
        contents.add(PDU_VARLIST_POS, varList);
        this.setValue(contents);
    }

    /**
     * PDU^CvԂ܂B
     *
     * @return tag PDU^Cv
     */
    public byte getPDUType() {
        return tag;
    }

    /**
     * SNMP VarBindList(variable binding list)Ԃ܂B
     *
     * @return VarBindList
     */
    public SnmpSequence getVarBindList() {
        List contentsValueList = (List) (this.getValue());

        return (SnmpSequence) (contentsValueList.get(PDU_VARLIST_POS));
    }

    /**
     * NGXgIDԂ܂B
     *
    @* @return NGXgID
    @*/
    public int getRequestID() {
        List contentsValueList = (List) (this.getValue());

        return ((BigInteger) ((SnmpInteger) (contentsValueList.get(
            PDU_REQUEST_ID_POS))).getValue()).intValue();
    }

    /**
     * G[Xe[^XԂ܂B
     * G[Xe[^XR[h͈ȉ̒ʂłB
     *
     * -1 : "FormatError"
     * 0 : "NoError"
     * 1 : "TooBig"
     * 2 : "NoSuchName"
     * 3 : "BadValue"
     * 4 : "ReadOnly"
     * 5 : "GenError"
     * Else : "UnknownError
     *
     * @return G[Xe[^XR[h
    */
    public int getErrorStatus() {
        List contentsValueList = (List) (this.getValue());

        return ((BigInteger) ((SnmpInteger) (contentsValueList.get(
            PDU_ERROR_STATUS_POS))).getValue()).intValue();
    }

    /**
     * G[IndexԂ܂B
     *
     * @return G[Index
     */
    public int getErrorIndex() {
        List contentsValueList = (List) (this.getValue());

        return ((BigInteger) ((SnmpInteger) (contentsValueList.get(
            PDU_ERROR_INDEX_POS))).getValue()).intValue();
    }
}
