/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.octetstring;

import java.io.ByteArrayOutputStream;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;



/**
 * ASN.1 Type(^O)ɂOCTETSTRING(^Oԍ 0x04)ɑΉSNMPIuWFNg
 * 삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpOctetString extends AbstractSnmpObject {
    /** SNMP OCTET STRINGf[^i[ */
    protected byte[] dataArray;

    /**
     * i0jSNMP OCTET STRINGIuWFNg𐶐܂B
     *
     */
    public SnmpOctetString() {
        dataArray = new byte[0];

        /* SNMP OCTET STRING TAGԍyTAGDescriptionZbg */
        tag = SnmpBERCodec.SNMPOCTETSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPOCTETSTRING;
    }

    /**
     * Octet String񂩂oCgɕϊSNMP OCTET STRING
     * IuWFNg𐶐܂B
     *
     * @param stringData Octet String
     */
    public SnmpOctetString(String stringData) {
        this.dataArray = stringData.getBytes();
        tag = SnmpBERCodec.SNMPOCTETSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPOCTETSTRING;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP OCTET STRINGIuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     */
    public SnmpOctetString(byte[] enc) {
        this.extractFromBEREncoding(enc);
        tag = SnmpBERCodec.SNMPOCTETSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPOCTETSTRING;
    }

    /**
     * Octets Stringf[^ƂĕێĂoCgf[^Ԃ܂B
     *
     * @return data oCgf[^
     */
    public Object getValue() {
        return dataArray;
    }

    /**
     * SNMP OCTET STRINGIuWFNgɃf[^Zbg܂B
    *
    * @param data ZbgIuWFNgl
    * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object data) throws SnmpBadValueException {
        if (data instanceof byte[]) {
            this.dataArray = (byte[]) data;
        } else if (data instanceof String) {
            this.dataArray = ((String) data).getBytes();
        } else {
            throw new SnmpBadValueException(
                " Octet String: bad object supplied to set value ");
        }
    }

    /**
     * ێĂSNMP Octet StringoCgzf[^ASN.1 BERGR[fBO
     * ɂoCgzԂ܂B
     *
     * @return oCgz
     */
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();

        // calculate encoding for length of data
        byte[] len = this.encodeLength(dataArray.length);

        // encode T,L,V info
        outBytes.write(tag);
        outBytes.write(len, 0, len.length);
        outBytes.write(dataArray, 0, dataArray.length);

        return outBytes.toByteArray();
    }

    /**
     * oCgzɊi[ꂽOctet Stringf[^CX^Xo[Ƃ
     * Zbg܂B
     *
     * @param enc oCgz
     */
    protected void extractFromBEREncoding(byte[] enc) {
        dataArray = new byte[enc.length];

        // copy data
        for (int i = 0; i < enc.length; i++) {
            dataArray[i] = enc[i];
        }
    }

    /**
     * ێĂOctets Stringf[^𕶎ɕϊĕԂ܂B
     *
     * @return returnString 
     */
    public String toString() {
        String returnString;

        /*
         * oCgR[hASCII\邩oCgR[ĥ܂HEX\
         * 邩̔
         * 擪R[h\oCgR[hłASCIIϊHEX
         * R[hŕ\
         * Exp. MACAhX͂ɂ
         * oCg`FbN̂́AhrPrinterDetectedErrorState\̂
         */
        if (
            (dataArray.length > 0) && !(dataArray.length <= 1) && (dataArray[0] <= 0x7F)
                && (dataArray[0] >= 0x20)) {
            returnString = new String(dataArray);
        } else {
            if (dataArray.length > 2) {
                returnString = "0x";
            } else {
                returnString = "";
            }

            for (int i = 0; i < dataArray.length; i++) {
                // non-printable code convert
                returnString += hexByte(dataArray[i]);
            }
        }

        return returnString;
    }
}
