/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.opaque;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;


/**
 * ASN.1 Type(^O)ɂOPAQUE_DOUBLE(^O 0x79)ɑΉSNMPIuWFNg
 * 𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpOpaqueDouble extends SnmpOpaque {
    /** l(64bits _(double)) */
    private double opaqueDoubleValue;

    /**
     * <p>OpaqueDoubleData ̃CX^X𐶐܂B</p>
     *
     * @param value l
     */
    protected SnmpOpaqueDouble(double value) {
        this.opaqueDoubleValue = value;
    }

    /**
     * <p>OpaqueDoubleData ̃CX^X𐶐܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    protected SnmpOpaqueDouble(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        opaqueDoubleValue = decode(data, offset, length);
    }

    /**
     * <p>̃IuWFNg̒l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @return ϊ byte 
     */
    public byte[] encode() {
        return encode(opaqueDoubleValue);
    }

    /**
     * <p>w肳ꂽ double l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @param value l
     * @return ϊ byte 
     */
    public byte[] encode(double value) {
        long longValue = Double.doubleToLongBits(value);
        byte[] array = new byte[13];
        array[0] = (byte) 0x44;
        array[1] = (byte) 11;
        array[2] = (byte) 0x9f;
        array[3] = (byte) SnmpBERCodec.OPAQUE_DOUBLE;
        array[4] = (byte) 8;
        array[5] = (byte) ((longValue >> 56) & MASK_0XFF);
        array[6] = (byte) ((longValue >> 48) & MASK_0XFF);
        array[7] = (byte) ((longValue >> 40) & MASK_0XFF);
        array[8] = (byte) ((longValue >> 32) & MASK_0XFF);
        array[9] = (byte) ((longValue >> 24) & MASK_0XFF);
        array[10] = (byte) ((longValue >> 16) & MASK_0XFF);
        array[11] = (byte) ((longValue >> 8) & MASK_0XFF);
        array[12] = (byte) (longValue & MASK_0XFF);

        return array;
    }

    /**
     * <p>w肳ꂽ byte  Basic Encoding Rule ɏ] double lɕϊ܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @return ϊ̒l
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    public double decode(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        if (length != 8) {
            throw new SnmpBadValueException(
                new StringBuffer().append("length is not 8: ").append(length)
                                  .toString());
        }

        long longValue = 0;

        try {
            for (int i = 0; i < length; i++) {
                longValue <<= 8;
                longValue |= (data[offset + i] & MASK_0XFF);
            }
        } catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }

        return Double.longBitsToDouble(longValue);
    }

    /**
     * OpaqueIuWFNgԂ܂B
     *
     * @return obj OpaqueIuWFNg
     */
    public Object getValue() {
        Double valued = new Double(opaqueDoubleValue);

        return valued;
    }

    /**
     * OpaqueIuWFNg𕶎ɕϊĕԂ܂B
     *
     * @return 
     */
    public String toString() {
        return Double.toString(opaqueDoubleValue);
    }
}
