/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;



/**
 * SNMP V2AgentɕKvȃ\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentV2MP extends AbstractAgentMessageProcessing {
    /* MO */
    private static Logger logger;

    /* SNMP Agent\` */
    private static SnmpAgentConfigInfo info;

    /**
     * SNMP V2 TrapMɌĂ΂AAgentCX^X𐶐܂B
     *
     * @throws SocketException SocketɎsꍇ
     */
    public AgentV2MP() throws SocketException {
        super();
        logger = Logger.getLogger(this.getClass().getName());
        this.version = SnmpPreference.SNMPV2C;
    }

    /**
     * SNMP V2AgentɕKvȃ\bhNX
     * CX^X𐶐܂B
     *
     * @param dSocket DatagramSocket
     * @throws SocketException SocketɎsꍇ
     */
    public AgentV2MP(final DatagramSocket dSocket) throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = SnmpPreference.SNMPV2C;
        info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        this.resSendDatagramSocket = dSocket;
    }

    /**
     * SNMP V2R}hMłB
     *
     * @param inPacket f[^MDatagramPacket
     * @param encodedMessage Mf[^oCg
     * @param receiveLength Mf[^
     * @throws SnmpErrorStatusException MG[Xe[^XłȂꍇ
     * @throws SnmpBadValueException Mf[^͂ňُ킪ꍇ
     * @throws IOException MɎsꍇ
     */
    public void process(
        final DatagramPacket inPacket, final byte[] encodedMessage,
        final int receiveLength)
        throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        this.inPacket = inPacket;

        byte command = 0;
        String community = "";
        SnmpMessage receivedMessage = null;

        // MR}ho
        try {
            receivedMessage = new SnmpMessage();

            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);

            byte[] versionByte = receivedMessage.getVersion();
            byte[] communityByte = receivedMessage.getCommunity();
            community = bytetoChar(communityByte);
            command = receivedMessage.getCommand();

            logger.info("Version : " + versionByte[0]);
            logger.info("Community : " + bytetoChar(communityByte));
            logger.info("Command : " + hexByte(command));
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            throw e;
        }

        this.receivedMessage = receivedMessage;

        switch (command) {
        case SnmpBERCodec.SNMPGETREQUEST:

            if (community.equals(info.getReadCommunity())) {
                this.getRequest(
                    version, info.getReadCommunity(), inPacket, receivedMessage);
            } else {
                logger.warning(
                    "Receive read community : " + community
                    + " Allow read community : " + info.getReadCommunity());
            }

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:

            if (community.equals(info.getReadCommunity())) {
                this.getNextRequest(
                    version, info.getReadCommunity(), inPacket, receivedMessage);
            } else {
                logger.warning(
                    "Receive read community : " + community
                    + " Allow read community : " + info.getReadCommunity());
            }

            break;

        case SnmpBERCodec.SNMPSETREQUEST:

            if (community.equals(info.getWriteCommunity())) {
                this.setRequest(
                    version, info.getWriteCommunity(), inPacket, receivedMessage);
            } else {
                logger.warning(
                    "Receive write community : " + community
                    + " Allow write community : " + info.getReadCommunity());
            }

            break;

        default:
            logger.warning("Bad command : " + command);
        }
    }

    /**
      * Trap𑗐M܂B
      *
      * @param hostAddress AhX
      * @param community R~jeB
      * @param pdu SNMP SequencebZ[W
      * @throws SnmpBadValueException Trapf[^ňُ킪ꍇ
      * @throws UnknownHostException MAhXُȏꍇ
      * @throws IOException MɎsꍇ
      */
    public void sendTrap(
        final String hostAddress, final String community, final SnmpSequence pdu)
        throws SnmpBadValueException, UnknownHostException, IOException {
        /* ʎq */
        int requestID = 0;

        InetAddress targetAddress = null;

        try {
            targetAddress = InetAddress.getByName(hostAddress);
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        SnmpSequence message = null;

        if (pdu instanceof SnmpTrap2PDU) {
            message =
                createTrap2Message(requestID, community, (SnmpTrap2PDU) pdu);
        } else {
            throw new SnmpBadValueException("Illegal Trap pdu");
        }

        byte[] messageEncoding = message.getBEREncoding();

        DatagramPacket outPacket =
            new DatagramPacket(
                messageEncoding, messageEncoding.length, targetAddress, trapPort);

        trapDatagramSocket.send(outPacket);
    }

    /**
     * Trap2 SNMP SequencebZ[W𐶐܂B
     *
     * @param trapRequestID ʎq
     * @param community R~jeB
     * @param pdu Trap2 PDU
     * @return sendSNMPSequence Trap SNMP Sequence
     */
    public SnmpSequence createTrap2Message(
        final int trapRequestID, final String community, final SnmpTrap2PDU pdu) {
        int snmpVersion = SnmpPreference.SNMPV2C;
        SnmpSequence sendSNMPSequence = new SnmpSequence();

        /* Trap2 PDUɃf[^Zbg */
        int errorStatus = 0;
        int errorIndex = 0;
        sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
        sendSNMPSequence.addSNMPObject(new SnmpOctetString(community));
        pdu.setPDU(trapRequestID, errorStatus, errorIndex);

        /* Trap2 SNMP SequencebZ[WZbg */
        sendSNMPSequence.addSNMPObject(pdu);

        return sendSNMPSequence;
    }
}
