/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.net.InetAddress;
import java.net.UnknownHostException;

import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpCommandOperation;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;


/**
 * SNMP V1/V2/V3 ManagerView`钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
abstract class AbstractSnmpOperationView extends ViewPart {
    /** GetNextRequest{^x */
    protected static final String GETNEXTREQUEST_BUTTON = "GetNext";

    /** GetRequest{^x */
    protected static final String GETREQUEST_BUTTON = "Get";

    /** ftHgSNMP Read Community */
    protected static final String READ_COMMUNITY = "public";

    /** ftHgSNMP Read/Write Community */
    protected static final String READ_WRITE_COMMUNITY = "private";

    /** Text */
    protected static final int TEXT_WIDTH = 200;

    /** ZbgText */
    protected static final int SET_VALUE_TEXT_WIDTH = 250;

    /* Scroll CompositeTCY */
    protected static final int[] SCROLL_COMPOSITE_SIZE = { 800, 200 };

    /** Agent IPAhXText */
    protected Text targetIPText;

    /** OID */
    protected Text oidText;

    /** Access Type */
    protected Text accessTypeText;

    /** Snmp Set Request Value */
    protected Text setValueText;

    /** Snmp Set Request Value Type */
    protected Combo snmpValueTypeCombo;

    /** Read Community */
    protected Text roCommunityText;

    /** Write Community */
    protected Text rwCommunityText;

    /** Snmp GetNextRequest Button */
    protected Button getNextButton;

    /** Snmp GetRequest Button */
    protected Button getRequestButton;

    /** Snmp SetRequest Button */
    protected Button snmpSetButton;

    /** Snmp data Holder */
    protected SnmpOperationDataHolder dataHolder;

    /** m[heLXg\BackGroundFi[ */
    protected Color textBackColor;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public abstract void createPartControl(Composite parent);

    /**
     * GetRquest{^̏łB
     *
     */
    public void getRequestButtonListener() {
        /* Target(Agent)IPAhX̐퐫`FbN */
        if (!checkIPAddress()) {
            /* IPAhXُ펞ɂ͉Return */
            return;
        }

        getRequestButton.setEnabled(false);
        getNextButton.setEnabled(false);
        snmpSetButton.setEnabled(false);

        /* f[^z_[Zbg */
        dataHolder.setViewSite(getViewSite());
        dataHolder.setTargetIP(targetIPText.getText());
        dataHolder.setRoCommunity(roCommunityText.getText());
        dataHolder.setTargetOid(oidText.getText());

        /*
         * Busy IndicatorZbg
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    SnmpCommandOperation.getInstance().getRequest(dataHolder);
                }
            });
        getRequestButton.setEnabled(true);
        getNextButton.setEnabled(true);
        snmpSetButton.setEnabled(true);
    }

    /**
     * GetNextRequest{^̏łB
     *
     */
    public void getNextRequestButtonListener() {
        /* Target(Agent)IPAhX̐퐫`FbN */
        if (!checkIPAddress()) {
            /* IPAhXُ펞ɂ͉Return */
            return;
        }

        getRequestButton.setEnabled(false);
        getNextButton.setEnabled(false);
        snmpSetButton.setEnabled(false);

        /* f[^z_[Zbg */
        dataHolder.setViewSite(getViewSite());
        dataHolder.setTargetIP(targetIPText.getText());
        dataHolder.setRoCommunity(roCommunityText.getText());
        dataHolder.setTargetOid(oidText.getText());

        /*
         * Busy IndicatorZbg
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    SnmpCommandOperation.getInstance().getNextRequest(
                        dataHolder);
                }
            });
        getRequestButton.setEnabled(true);
        getNextButton.setEnabled(true);
        snmpSetButton.setEnabled(true);
    }

    /**
     * Set Reques{^̏łB
     *
     */
    public void setRequestButtonListener() {
        /* Target(Agent)IPAhX̐퐫`FbN */
        if (!checkIPAddress()) {
            /* IPAhXُ펞ɂ͉Return */
            return;
        }

        snmpSetButton.setEnabled(false);
        getNextButton.setEnabled(false);
        dataHolder.setViewSite(getViewSite());
        dataHolder.setTargetIP(targetIPText.getText());
        dataHolder.setRwCommunity(rwCommunityText.getText());
        dataHolder.setTargetOid(oidText.getText());
        dataHolder.setSetValue(setValueText.getText());

        dataHolder.setSetType(
            SnmpV1ValueTypeSelection.getInstance().getSnmpValueType());

        /*
         * Busy IndicatorZbg
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    SnmpCommandOperation.getInstance().setRequest(dataHolder);
                }
            });

        snmpSetButton.setEnabled(true);
        getNextButton.setEnabled(true);
    }

    /*
     * Target(Agent)IPAhXÓł邩`FbN܂B
     *
     * @return isOKAddress PAhXÓł邩`FbN
     */
    private boolean checkIPAddress() {
        boolean isOKAddress = false;
        int snmpVersion = dataHolder.getSnmpVersion();
        String targetIPAddress = targetIPText.getText();

        /* Target(Agent)IPAhX͂`FbN */
        if (targetIPAddress.equals("")) {
            if (snmpVersion == SnmpPreference.SNMPV3) {
                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", "Select Agent Address");
                shell.dispose();
                targetIPText.setFocus();

                return isOKAddress;
            }

            Shell shell = new Shell();
            MessageDialog.openError(shell, "Error", "Input Agent Address");
            shell.dispose();
            targetIPText.setFocus();

            return isOKAddress;
        }

        /* Target(Agent)IPAhXÓł邩`FbN */
        String ipAddress = "";

        try {
            InetAddress host = InetAddress.getByName(targetIPAddress);
            ipAddress = host.getHostAddress();
        } catch (UnknownHostException e2) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Error",
                "UnknownHostException" + " IP Address = "
                + targetIPText.getText());
            shell.dispose();
            targetIPText.setFocus();

            return isOKAddress;
        }

        /*
         * SNMP V3̏ꍇŁATarget(Agent)IPAhXSNMP V3
         * }l[Wɓo^Ă邩`FbN
         */
        if (snmpVersion == SnmpPreference.SNMPV3) {
            if (
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(ipAddress) == null) {
                /*
                     * Target(Agent)IPAhXSNMP V3
                 * }l[Wɓo^ĂȂAlert\
                 */
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Error",
                    "Not found SNMP V3 Agent Address = " + ipAddress);
                shell.dispose();

                return isOKAddress;
            }
        }

        isOKAddress = true;

        return isOKAddress;
    }

    /**
    * tH[JXZbgꂽ̏łB
    */
    public void setFocus() {
    }

    /**
     * Text\f[^̏lZbg܂B
     *
     */
    public void setInitText() {
        oidText.setText(OidTreeView.INIT_SELECT_OID);

        snmpValueTypeCombo.setText(SnmpBERCodec.SNMPOCTETSTRING);

        accessTypeText.setText(OidTreeListener.READ_ONLY_DESCRIPTION);
    }

    /**
     * Xe[^XCZbg܂B
     *
     */
    protected abstract void setStatusLine();

    /**
     * OID TextԂ܂B
     *
     * @return oidText OID Text
     */
    public Text getOidText() {
        return oidText;
    }

    /**
     * SNMP Value Type Combo BoxԂ܂B
     *
     * @return snmpValueTypeCombo SNMP Value Type Combo Box
     */
    public Combo getSnmpValueTypeCombo() {
        return snmpValueTypeCombo;
    }

    /**
     * Access Type TextԂ܂B
     *
     * @return accessTypeText  Access Type Text
     */
    public Text getAccessTypeText() {
        return accessTypeText;
    }

    /**
     * Set Requestp̒lݒpTextԂ܂B
     *
     * @return setValueText Set Requestp̒lݒpText
     */
    public Text getSetValueText() {
        return setValueText;
    }
}
