/*
 * Created on 2004/03/26
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpmanager.SnmpManagerQueue;
import netjfwatcher.snmpmanager.TrapTableViewLabelProvider;

/**
 * TrapMJnɃXi[ƂẴCX^Xo^A TrapM̃ANV܂B
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TrapListenerImpl extends DataStringDisplay implements
		ITrapListener {
	/* MO */
	private static Logger logger;

	/*
	 * SNMP V2CyV3 Trap PDÜʒu
	 *  | Version
	 *  +----------------------
	 *  | Community
	 *  +----------------------
	 *  | PDU
	 *  | ------------------ 
	 *  |
	 *  | ID
	 *  | ------------------
	 *  |
	 *  | Error Index
	 *  | ------------------
	 *  |
	 *  | Error Status
	 *  | ------------------
	 *  |
	 *  | varBindList
	 *  +----------------------
	 */
	private static final int TRAP2_PDU_ID_POS = 0;

	private static final int TRAP2_PDU_ERROR_INDEX_POS = 1;

	private static final int TRAP2_PDU_ERROR_STATUS_POS = 2;

	private static final int TRAP2_PDU_VARBIND_LIST_POS = 3;

	/* Trap V1Mf[^i[z */
	private String[] trapData = new String[TrapTableViewLabelProvider.TRAP_ARRAY_COUNT];

	/* Trap V2Mf[^i[z */
	private String[] trap2Data = new String[TrapTableViewLabelProvider.TRAP_ARRAY_COUNT];

	/*
	 * TrapMG[WFgAhXɑΉSNMP V3\i[ (coldStart/warmStartMAgent
	 * DiscoveryԂZbg 邽߂Ɏgp)
	 */
	private SnmpV3ManagerConfigInfo snmpV3ConfInfo;

	/*
	 * TrapMJE^[(TrapMɃJEgAbv)TrapMe[u MԍƂĕ\܂
	 */
	private int trapConter;

	/*
	 * Trap v2
	 */
	private String trapV2AgentAddress;

	private String trapV2GenericTrap;

	private String trapV2SysUpTime;

	private String trapV2VarListOIDDiscription;

	private String trapV2EnterpriseOIDString;

	/* MIB` */
	private ManagerMibTree mibtree = ManagerMibTree.getInstance();

	/* TrapMtH[}bg */
	private final DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

	/**
	 * SNMP TrapMCX^X𐶐܂B
	 * 
	 */
	private TrapListenerImpl() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * SNMP V1 TrapMCxgŃR[܂B<BR>
	 * 
	 * 
	 * +--------------------------
	 * |Enterprise OID : ID(@x_[̃IuWFNgID)
	 * +--------------------------
	 * |Agent Address
	 * +--------------------------
	 * |Generic No. : Trapԍ
	 * +--------------------------
	 * |Specific No. : gTrapԍ(enterpriseSpecific Trap
	 * | Ɍ肷ԍ)
	 * +--------------------------
	 * |Timestamp
	 * +--------------------------
	 * |VarBindList
	 * | ---------------
	 * | Data
	 * | OID
	 * |
	 * +-------
	 * |
	 * | Value
	 * 
	 * @param trapPDU
	 *            Trap PDU
	 * @param trapPDU
	 *            Trap PDU
	 * @param sourceAddress
	 *            Trap Sorce Address
	 */
	public void processTrap(final String community, final SnmpTrapPDU trapPDU,
			final String sourceAddress) {
		trapConter++; // TrapMJE^JEgAbv

		byte snmpCommandCode = trapPDU.getPDUType();

		/* Logging/Monitor set */
		logger
				.info("Trap PDU-Type : "
						+ getCommandDescription(snmpCommandCode));
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Trap PDU-Type : " + hexByte(snmpCommandCode) + "("
						+ getCommandDescription(snmpCommandCode) + ")");

		Date date = Calendar.getInstance().getTime();
		logger.info("Receive Trap date : " + dateformat.format(date)
				+ " : Data length : " + trapPDU.getBEREncoding().length
				+ "Byte");
		logger.info(hexBytetoString(trapPDU.getBEREncoding(), trapPDU
				.getBEREncoding().length));

		/* TrapMOIDɑΉDescription(Lqe)i[ */
		String receiveOidDiscription = "";

		/*
		 * TrapMvarBindXg
		 */
		SnmpSequence varBindSequence = trapPDU.getVarBindList();

		for (int i = 0; i < varBindSequence.size(); i++) {
			SnmpSequence varBindValueSequence = (SnmpSequence) varBindSequence
					.getSNMPObjectAt(i);
			SnmpObjectIdentifier varBindOID = (SnmpObjectIdentifier) varBindValueSequence
					.getSNMPObjectAt(0);

			/*
			 * TrapMOIDɊYOID`ADescriptiono
			 */
			int oidwork = varBindOID.toString().lastIndexOf(".");
			String leaf = varBindOID.toString().substring(oidwork);
			String searchoid = varBindOID.toString().substring(0, oidwork);

			if (mibtree.getOidHashMap().containsKey(searchoid)) {
				MibInfo miboid = (MibInfo) mibtree.getOidHashMap().get(
						searchoid);
				receiveOidDiscription = miboid.getDescrip() + leaf;
			} else {
				logger.warning("Unknown OID : " + searchoid);
			}
		}

		String trapV1AgentAddress = "";

		if (trapPDU.getAgentAddress() != null) {
			trapV1AgentAddress = trapPDU.getAgentAddress().toString();
		}

		String trapV1EnterpriseOID = "";

		if (trapPDU.getEnterpriseOID() != null) {
			trapV1EnterpriseOID = trapPDU.getEnterpriseOID().toString();
		}

		/*
		 * TrapMf[^e[u\
		 */
		trapData[TrapTableViewLabelProvider.TRAP_NO] = Integer
				.toString(trapConter);
		trapData[TrapTableViewLabelProvider.SNMPVERSION] = SnmpPreference.SNMPV1_DESCRIPTION;

		Map enterpriseOidMap = EnterpriseOIDConfig.getInstance()
				.getEnterpriseOidHashMap();
		String enterpriseOid = TrapForward.getInstance().extractEnterpriseOid(trapV1EnterpriseOID);
		if (enterpriseOid == null) {
			trapData[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV1EnterpriseOID;
		} else {
			EnterpriseOIDInfo enterpriseOidInfo = (EnterpriseOIDInfo) enterpriseOidMap
					.get(enterpriseOid);
			if(enterpriseOidInfo != null) {
				trapData[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV1EnterpriseOID
					+ " (" + enterpriseOidInfo.getCompany() + ")";
			} else {
				trapData[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV1EnterpriseOID;
			}
		}

		trapData[TrapTableViewLabelProvider.AGENT_ADDRESS] = trapV1AgentAddress
				+ " (Source=" + sourceAddress + ")";
		trapData[TrapTableViewLabelProvider.GENERIC_TRAP_CODE] = checkGenericTrapCode(
				trapV1AgentAddress, trapPDU.getGenericTrap(),
				receiveOidDiscription);
		trapData[TrapTableViewLabelProvider.SPECIFIC_TRAP] = Integer
				.toString(trapPDU.getSpecificTrap());
		trapData[TrapTableViewLabelProvider.TIMESTAMP] = trapPDU.getTimestamp()
				.toString();
		this.showTable(trapData);

		// AlarmMessageResource.get
		String message = trapData[TrapTableViewLabelProvider.SNMPVERSION]
				+ " Eenterprise OID:"
				+ trapData[TrapTableViewLabelProvider.ENTERPRISE_OID]
				+ " Agent address:"
				+ trapData[TrapTableViewLabelProvider.AGENT_ADDRESS]
				+ " Generic trap:"
				+ trapData[TrapTableViewLabelProvider.GENERIC_TRAP_CODE]
				+ " Specific trap:"
				+ trapData[TrapTableViewLabelProvider.SPECIFIC_TRAP]
				+ " Timestamp:"
				+ trapData[TrapTableViewLabelProvider.TIMESTAMP]
				+ " (Source Adr.=" + sourceAddress + ")";

		/*
		 * TrapMA[Zbg
		 */
		AlarmMessageMake alarm = AlarmMessageMake.getInstance();
		alarm.setTrapReceive(trapV1AgentAddress, message);

		/* Logging/MonitorTrapMf[^\ */
		logger.info("Trap receive Source Address=" + sourceAddress + " : "
				+ message);
		date = Calendar.getInstance().getTime();
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Trap receive date : " + dateformat.format(date));
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"SNMP Version   = "
						+ trapData[TrapTableViewLabelProvider.SNMPVERSION]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Source Address = " + sourceAddress);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Enterprise OID = "
						+ trapData[TrapTableViewLabelProvider.ENTERPRISE_OID]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Agent address  = "
						+ trapData[TrapTableViewLabelProvider.AGENT_ADDRESS]);
		SnmpManagerQueue
				.getInstance()
				.pushSnmpManagerQueue(
						"Generic trap   = "
								+ trapData[TrapTableViewLabelProvider.GENERIC_TRAP_CODE]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Specific trap  = "
						+ trapData[TrapTableViewLabelProvider.SPECIFIC_TRAP]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Timestamp      = "
						+ trapData[TrapTableViewLabelProvider.TIMESTAMP]);

		if (TrapForward.getInstance().filterTrapForward(enterpriseOid)) {
			TrapForward.getInstance().forwardTrap(community, trapPDU,
					SnmpPreference.SNMP_VERSION_1, sourceAddress);
		}
	}

	/**
	 * SNMP V2CyV3 Trap
	 *  | Version
	 *  +----------------------
	 *  | Community
	 *  +----------------------
	 *  | PDU
	 *  | ------------------
	 *  |
	 *  | ID
	 *  | ------------------
	 *  |
	 *  | Error Index
	 *  | ------------------
	 *  |
	 *  | Error Status
	 *  | ------------------
	 *  |
	 *  | varBindList
	 *  +----------------------
	 * 
	 *  varBindList
	 *  +---------------------------------------
	 *  | sysUpTime // {1.3.6.1.2.1.1.3.0}
	 *  +---------------------------------------
	 *  | snmpTrapOID // {1.3.6.1.6.3.1.1.4.1.0}
	 *  +---------------------------------------
	 *  | varList
	 *  +---------------------------------------
	 * 
	 * 
	 * @param trap2PDU
	 *            Trap2 PDU
	 * @param snmpVersion
	 *            SNMPo[W
	 * @param sourceAddress
	 *            Trap\[XAhX
	 */
	public void processTrapV2(final SnmpTrap2PDU trap2PDU,
			final String snmpVersion, final String sourceAddress) {
		trapConter++; // TrapMJE^JEgAbv

		SnmpObjectIdentifier enterpriseOID = null;
		byte snmpCommandCode = trap2PDU.getPDUType();
		logger.info("Trap Source Address : " + sourceAddress);
		logger
				.info("Trap PDU-Type : "
						+ getCommandDescription(snmpCommandCode));
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Trap PDU-Type : " + hexByte(snmpCommandCode) + "("
						+ getCommandDescription(snmpCommandCode) + ")");

		SnmpInteger trapID = (SnmpInteger) trap2PDU
				.getSNMPObjectAt(TRAP2_PDU_ID_POS);
		SnmpInteger errorIndex = (SnmpInteger) trap2PDU
				.getSNMPObjectAt(TRAP2_PDU_ERROR_INDEX_POS);
		SnmpInteger errorStatus = (SnmpInteger) trap2PDU
				.getSNMPObjectAt(TRAP2_PDU_ERROR_STATUS_POS);
		logger.info("Trap receive ID : " + trapID.toString());
		logger.info("Trap receive error Index : " + errorIndex.toString());
		logger.info("Trap receive error Status : " + errorStatus.toString());

		/*
		 * Trap V2AhXZbg
		 */
		trapV2AgentAddress = "";

		if (trap2PDU.getAgentAddress() != null) {
			trapV2AgentAddress = trap2PDU.getAgentAddress().toString();
		}

		/*
		 * varBind List
		 */
		SnmpSequence varBindSequence = null;
		varBindSequence = (SnmpSequence) trap2PDU
				.getSNMPObjectAt(TRAP2_PDU_VARBIND_LIST_POS);

		trapV2GenericTrap = "";
		trapV2SysUpTime = "";
		trapV2VarListOIDDiscription = "";
		trapV2EnterpriseOIDString = "";

		SnmpSequence varBindValueSequence = null;
		SnmpObjectIdentifier varBindOID = null;
		AbstractSnmpObject varBindValue = null;

		/*
		 * PDUvarBindXg sysUpTime.0 (1.3.6.1.2.1.1.3.0)snmpTrapOID.0
		 * (1.3.6.1.6.3.1.1.4.1.0)varBindɊ܂܂邩 `FbN
		 */
		for (int varBindSeqCount = 0; varBindSeqCount < varBindSequence.size(); varBindSeqCount++) {
			/*
			 * Trap PDUvarBind[v()ŉ
			 */
			varBindValueSequence = (SnmpSequence) varBindSequence
					.getSNMPObjectAt(varBindSeqCount);
			varBindOID = (SnmpObjectIdentifier) varBindValueSequence
					.getSNMPObjectAt(0);
			varBindValue = varBindValueSequence.getSNMPObjectAt(1);

			/*
			 * varBind̈ڂSysUpTime OIDߍ܂Ă邩`FbNA SysUpTime
			 * OID̏ꍇɂ͒lێAe[u\
			 */
			if (varBindSeqCount == 0) {
				/*
				 * system(1)O[v̂sysUptime(3)OID (1.3.6.1.2.1.1.3.0)`FbN
				 */
				if (varBindOID.toString().equals(
						SnmpPreference.SNMP_SYSUPTIME_OID)) {
					trapV2SysUpTime = varBindValue.toString();
					logger.info("sysUpTime OID : " + varBindOID.toString());
					logger.info("sysUpTime Value : " + varBindValue.toString());
				} else {
					/* sysUptime OIDłȂꍇ */
					logger.warning("No sysUptime OID, "
							+ "Trap varBindValue Sequence No.0 varBindOID = "
							+ varBindOID.toString());
				}
			}

			/*
			 * varBind̓ڂsnmpTrapOIDߍ܂Ă邩`FbNA Trap OID̏ꍇɂ͒lێAe[u\
			 */
			if (varBindSeqCount == 1) {
				enterpriseOID = varBindOID;
				/*
				 * snmpTrapOID(1.3.6.1.6.3.1.1.4.1.0)`FbN
				 */
				checkSnmpTrapOID(enterpriseOID, varBindValue);
			}

			/*
			 * varList(sysUpTime,snmpTrapOID̎)
			 */
			if (varBindSeqCount >= 2) {
				int oidwork = varBindOID.toString().lastIndexOf(".");
				String leaf = varBindOID.toString().substring(oidwork);
				String searchoid = varBindOID.toString().substring(0, oidwork);

				if (mibtree.getOidHashMap().containsKey(searchoid)) {
					MibInfo varListOIDInfo = (MibInfo) mibtree.getOidHashMap()
							.get(searchoid);
					trapV2VarListOIDDiscription = varListOIDInfo.getDescrip()
							+ leaf + " (" + varBindOID.toString() + ")"
							+ " value = " + varBindValue;
				} else {
					trapV2VarListOIDDiscription = "varBind OID = "
							+ varBindOID.toString() + " value = "
							+ varBindValue;
					logger.warning("Unknown varBind OID : " + searchoid);
				}
			}

			logger.info("Receive varBind " + "No." + varBindSeqCount
					+ " OID = " + varBindOID.toString());
			logger.info("Receive varBind " + "No." + varBindSeqCount
					+ " Value = " + varBindValue.toString());
		}

		/* Trap V2M\Zbg */
		setShowTrap2(snmpVersion, sourceAddress);
	}

	/*
	 * snmpTraps(OID = 1.3.6.1.6.3.1.1.5)O[v`FbN܂B
	 * 
	 * @param varBindOID @param varBindValue
	 */
	private void checkSnmpTrapOID(SnmpObjectIdentifier varBindOID,
			AbstractSnmpObject varBindValue) {
		if (varBindOID.toString().equals(SnmpPreference.SNMP_TRAP_OID)) {
			/*
			 * snmpTrapOID̊mF
			 */
			trapV2GenericTrap = varBindValue.toString();
			logger.info("SNMP Trap OID = " + varBindOID.toString());
			logger.info("SNMP Trap OID value= " + varBindValue.toString());

			String snmpTrapOidValueDescription = "";

			/*
			 * snmpTraps(OID = 1.3.6.1.6.3.1.1.5)O[v `FbN
			 */
			if (varBindValue.toString().equals(SnmpPreference.COLDSTART_OID)) {
				snmpTrapOidValueDescription = "coldStart" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString().equals(
					SnmpPreference.WARMSTART_OID)) {
				snmpTrapOidValueDescription = "warmStart" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString().equals(
					SnmpPreference.LINKDOWN_OID)) {
				snmpTrapOidValueDescription = "linkDown" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString()
					.equals(SnmpPreference.LINKUP_OID)) {
				snmpTrapOidValueDescription = "linkUp" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString().equals(
					SnmpPreference.AUTHENTICATIONFAILURE_OID)) {
				snmpTrapOidValueDescription = "authenticationFailure" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString().equals(
					SnmpPreference.EGPNEIGHBORLOS_OID)) {
				snmpTrapOidValueDescription = "egpNeighborLoss" + "("
						+ varBindValue.toString() + ")";
			} else if (varBindValue.toString().equals(
					SnmpPreference.ENTERPRISESPECIFIC_OID)) {
				snmpTrapOidValueDescription = "enterpriseSpecific" + "("
						+ varBindValue.toString() + ")";
			} else {
				/*
				 * snmpTraps(OID = 1.3.6.1.6.3.1.1.5) O[vłȂꍇsnmpTrapOIDPair
				 * ƂȂOID̋Lq
				 */
				int oidwork = varBindValue.toString().lastIndexOf(".");
				String leaf = varBindValue.toString().substring(oidwork);
				String searchoid = varBindValue.toString()
						.substring(0, oidwork);

				if (mibtree.getOidHashMap().containsKey(searchoid)) {
					/*
					 * snmpTrapOIDPairOIDqbg
					 */
					MibInfo varListOIDInfo = (MibInfo) mibtree.getOidHashMap()
							.get(searchoid);
					snmpTrapOidValueDescription = varListOIDInfo.getDescrip()
							+ leaf + "(" + varBindValue.toString() + ")";
				} else {
					/*
					 * snmpTrapOIDPairOIDȂ
					 */
					snmpTrapOidValueDescription = varBindValue.toString();
					logger.warning("Unknown OID : " + searchoid);
				}
			}

			/*
			 * snmpTrapOIDe[uenterprise̗ \ɃZbg
			 */
			trapV2EnterpriseOIDString = "snmpTrapOID.0 ("
					+ varBindOID.toString() + ") value = "
					+ snmpTrapOidValueDescription;
		} else {
			/*
			 * snmpTrapOIDłȂꍇ snmpTrapOIDe[uenterprise̗ \ɃZbg
			 */
			trapV2EnterpriseOIDString = "Not snmpTrapOID : "
					+ varBindOID.toString();
			logger.warning("Trap varBindValueSequence No.1 varBindOID = "
					+ varBindOID.toString());
		}
	}

	/*
	 * TrapMf[^͌ʂe[uAj^[\܂B
	 * 
	 * @param snmpVersion @param sourceAddress
	 */
	private void setShowTrap2(final String snmpVersion,
			final String sourceAddress) {
		/* MTrap͌ʂe[u\ */
		trap2Data[TrapTableViewLabelProvider.TRAP_NO] = Integer
				.toString(trapConter);
		trap2Data[TrapTableViewLabelProvider.SNMPVERSION] = snmpVersion;
		
		Map enterpriseOidMap = EnterpriseOIDConfig.getInstance()
		.getEnterpriseOidHashMap();
		String enterpriseOid = TrapForward.getInstance().extractEnterpriseOid(trapV2EnterpriseOIDString);
		if (enterpriseOid == null) {
			trap2Data[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV2EnterpriseOIDString;
		} else {
			EnterpriseOIDInfo enterpriseOidInfo = (EnterpriseOIDInfo) enterpriseOidMap
			.get(enterpriseOid);
			if(enterpriseOidInfo != null) {
				trap2Data[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV2EnterpriseOIDString
				+ " (" + enterpriseOidInfo.getCompany() + ")";
			} else {
				trap2Data[TrapTableViewLabelProvider.ENTERPRISE_OID] = trapV2EnterpriseOIDString;
			}
		}
		

		/*
		 * Trap2 PDUɁAAgent AddressȂꍇ͎MSource Address m[hAddressƂ
		 */
		if ((trapV2AgentAddress != null) && !trapV2AgentAddress.equals("")) {
			trap2Data[TrapTableViewLabelProvider.AGENT_ADDRESS] = trapV2AgentAddress;
		} else {
			trap2Data[TrapTableViewLabelProvider.AGENT_ADDRESS] = sourceAddress;
		}

		trap2Data[TrapTableViewLabelProvider.GENERIC_TRAP_CODE] = checkGenericTrapOID(
				trapV2AgentAddress, trapV2GenericTrap,
				trapV2VarListOIDDiscription);
		trap2Data[TrapTableViewLabelProvider.SPECIFIC_TRAP] = "";
		trap2Data[TrapTableViewLabelProvider.TIMESTAMP] = trapV2SysUpTime;

		/* Trapf[^e[u\ */
		this.showTable(trap2Data);

		String message = trap2Data[TrapTableViewLabelProvider.SNMPVERSION]
				+ " Enterprise OID:"
				+ trap2Data[TrapTableViewLabelProvider.ENTERPRISE_OID]
				+ " Agent address:"
				+ trap2Data[TrapTableViewLabelProvider.AGENT_ADDRESS]
				+ " Generic trap:"
				+ trap2Data[TrapTableViewLabelProvider.GENERIC_TRAP_CODE]
				+ " Specific trap:"
				+ trap2Data[TrapTableViewLabelProvider.SPECIFIC_TRAP]
				+ " Timestamp:"
				+ trap2Data[TrapTableViewLabelProvider.TIMESTAMP];

		/*
		 * Trap2MA[Zbg
		 */
		AlarmMessageMake alarm = AlarmMessageMake.getInstance();

		/*
		 * Trap2 PDUɁAAgent AddressȂꍇ͎MSource Address m[hAddressƂ
		 */
		if ((trapV2AgentAddress != null) && !trapV2AgentAddress.equals("")) {
			alarm.setTrapReceive(trapV2AgentAddress, message);
		} else {
			alarm.setTrapReceive(sourceAddress, message);
		}

		logger.info("Trap receive : " + message);

		/* MonitorTrapMf[^\ */
		Date date = Calendar.getInstance().getTime();
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Trap receive date : " + dateformat.format(date));
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"SNMP Version   = "
						+ trap2Data[TrapTableViewLabelProvider.SNMPVERSION]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Source Address = " + sourceAddress);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Enterprise OID = "
						+ trap2Data[TrapTableViewLabelProvider.ENTERPRISE_OID]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Agent address  = "
						+ trap2Data[TrapTableViewLabelProvider.AGENT_ADDRESS]);
		SnmpManagerQueue
				.getInstance()
				.pushSnmpManagerQueue(
						"Generic trap   = "
								+ trap2Data[TrapTableViewLabelProvider.GENERIC_TRAP_CODE]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Specific trap  = "
						+ trap2Data[TrapTableViewLabelProvider.SPECIFIC_TRAP]);
		SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
				"Timestamp      = "
						+ trap2Data[TrapTableViewLabelProvider.TIMESTAMP]);
	}

	/**
	 * GenericTrapR[h𔻕ʂ܂B R[hʂɂ蕶ƂĕԂ܂B
	 * ܂AGenericTrapR[hȉ̏ꍇɂ́AG[WFgDiscoveryZbg ܂B (1) coldStart (2)
	 * warmStart
	 * 
	 * @param address
	 *            AgentAhX
	 * @param code
	 *            GenericTrapR[h
	 * @param variableBind
	 *            Variable Bind
	 * @return genericTrapDisc GenericTrapLq
	 */
	private String checkGenericTrapCode(final String address, final int code,
			final String variableBind) {
		String genericTrapDisc = "";

		switch (code) {
		case SnmpPreference.COLDSTART:
			genericTrapDisc = TrapPreference.COLDSTART;
			snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance()
					.getResourceFileParse().getSnmpV3AgentInfo(address);

			if (snmpV3ConfInfo != null) {
				/* AgentwKς݃tOZbg */
				snmpV3ConfInfo.setLearned(false);
				logger.info("SnmpEngineBoots and SnmpEngineTime relearned at "
						+ address + " for " + TrapPreference.COLDSTART);
			}

			break;

		case SnmpPreference.WARMSTART:
			genericTrapDisc = TrapPreference.WARMSTART;
			snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance()
					.getResourceFileParse().getSnmpV3AgentInfo(address);

			if (snmpV3ConfInfo != null) {
				/* AgentwKς݃tOZbg */
				snmpV3ConfInfo.setLearned(false);
				logger.info("SnmpEngineBoots and SnmpEngineTime relearned at "
						+ address + " for " + TrapPreference.WARMSTART);
			}

			break;

		case SnmpPreference.LINKDOWN:
			genericTrapDisc = TrapPreference.LINKDOWN + variableBind;

			break;

		case SnmpPreference.LINKUP:
			genericTrapDisc = TrapPreference.LINKUP + variableBind;

			break;

		case SnmpPreference.AUTHENTICATIONFAILURE:
			genericTrapDisc = TrapPreference.AUTHENTICATION_FAILURE;

			break;

		case SnmpPreference.EGPNEIGHBORLOS:
			genericTrapDisc = TrapPreference.EGPNEIGHBORLOSS + variableBind;

			break;

		case SnmpPreference.ENTERPRISESPECIFIC:
			genericTrapDisc = TrapPreference.ENTERPRISESPECIFIC + variableBind;

			break;

		default:
			genericTrapDisc = Integer.toString(code);
		}

		return genericTrapDisc;
	}

	/**
	 * Generic Trap OID`FbN܂B ܂ATrapMɂAAgentDiscoveredԂZbg܂B
	 * 
	 * @param address
	 *            AgentAhX
	 * @param genericTrapOID
	 *            Generic Trap OID
	 * @param variableBind
	 *            variable Bind
	 * @return genericTrapDisc Generic Trap OID Discription
	 */
	private String checkGenericTrapOID(final String address,
			final String genericTrapOID, final String variableBind) {
		/* Generic Trap OID Discription */
		String genericTrapDisc = "";

		/* SNMP V3 Agent */
		snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance()
				.getResourceFileParse().getSnmpV3AgentInfo(address);

		if (snmpV3ConfInfo != null) {
			snmpV3ConfInfo.setLearned(false);
			logger.info("SnmpEngineBoots and SnmpEngineTime relearned at "
					+ address);
		}

		if (genericTrapOID.equals(SnmpPreference.COLDSTART_OID)) {
			genericTrapDisc = "coldStart";
		} else if (genericTrapOID.equals(SnmpPreference.WARMSTART_OID)) {
			genericTrapDisc = "warmStart";
		} else if (genericTrapOID.equals(SnmpPreference.LINKDOWN_OID)) {
			genericTrapDisc = "linkDown " + variableBind;
		} else if (genericTrapOID.equals(SnmpPreference.LINKUP_OID)) {
			genericTrapDisc = "linkUp " + variableBind;
		} else if (genericTrapOID
				.equals(SnmpPreference.AUTHENTICATIONFAILURE_OID)) {
			genericTrapDisc = "authenticationFailure";
		} else if (genericTrapOID.equals(SnmpPreference.EGPNEIGHBORLOS_OID)) {
			genericTrapDisc = "egpNeighborLoss " + variableBind;
		} else {
			genericTrapDisc = variableBind;
		}

		return genericTrapDisc;
	}

	/**
	 * MTrapTrapMe[uɕ\܂B TrapMe[u\Eclipse Viewɂĕ\ATrapMThread
	 * EclipseƂ͕ʃXbĥ߂ɁAł́AUL[Ɋi[A Eclipseł̃L[ǂݏoŕ\܂B
	 * 
	 * @param trapShowData
	 *            MTrap񕶎z
	 */
	public void showTable(final String[] trapShowData) {
		/*
		 * Mi\f[^jL[Ɋi[
		 */
		ArrayList<String[]> trapReceiveList = new ArrayList<String[]>();
		String[] trapDataClone = (String[]) trapShowData.clone();
		trapReceiveList.add(trapDataClone);
		TrapReceiveMessageQueue.getInstance().pushTrapData(trapReceiveList);
	}

	/*
	 * SNMPR}hMOs܂B
	 * 
	 * @param code SNMPR}hR[h
	 */
	private String getCommandDescription(final byte code) {
		String snmpCode = "";

		switch (code) {
		case SnmpBERCodec.SNMPTRAP:
			snmpCode = "Trap-PDU";

			break;

		case SnmpBERCodec.SNMPTRAP2:
			snmpCode = "Trap2-PDU";

			break;

		case SnmpBERCodec.SNMPINFORM:
			snmpCode = "Inform-PDU";

			break;

		case SnmpBERCodec.SNMPGETREQUEST:
			snmpCode = "GetRequest";

			break;

		case SnmpBERCodec.SNMPGETNEXTREQUEST:
			snmpCode = "GetNextRequest";

			break;

		case SnmpBERCodec.SNMPSETREQUEST:
			snmpCode = "SetRequest";

			break;

		case SnmpBERCodec.SNMPGETRESPONSE:
			snmpCode = "GetResponse";

			break;

		default:
			snmpCode = "Unknown";
			logger.warning("Undefined SNMP Command code : " + code);
		}

		return snmpCode;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static TrapListenerImpl getInstance() {
		return SingletonResource.TRAP_LISTENER_IMPL;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final TrapListenerImpl TRAP_LISTENER_IMPL = new TrapListenerImpl();
	}
}
