/*
 * Created on 2004/07/19
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.server.xmlsocket.XMLSocketThread;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/**
 * GWXML SocketڑAf[^Ms\bhThreadNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionEngineThread extends DataStringDisplay implements
		Runnable {

	private Map engineConnectStateMap;

	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	/* SocketǂݏoƂɃZbgMarkʒu */
	private static final int MARK_RESET = 0;

	private Socket socket = null;

	private InputStream inputStream = null;

	private BufferedInputStream bufferInStream = null;

	private String engineAddressString = "";

	private String enginePortString = "";

	/* Thread~wtO */
	private boolean isThreadRun = true;

	/* MXMLɃA[ꍇɃZbgtO */
	private boolean isAlarm = false;

	/* MO */
	private static Logger logger = null;

	public ConnectionEngineThread(Map engineConnectStateMap) {
		logger = Logger.getLogger(this.getClass().getName());
		this.engineConnectStateMap = engineConnectStateMap;

	}

	/**
	 * XML SocketڑGWAhXA|[gyу^CAEgl ZbgASocketڑ܂B
	 * 
	 * @param engineAddress
	 *            GWAhX
	 * @param enginePort
	 *            GW|[g
	 * @param timeOut
	 *            ^CAEgl
	 * @throws IOException
	 *             SocketڑɎsꍇ
	 */
	public void setXMLSocket(String engineAddress, int enginePort, int timeOut)
			throws IOException {
		engineAddressString = engineAddress;
		enginePortString = Integer.toString(enginePort);
		try {
			/* GWSocketڑ */
			InetAddress dstInetAddr = InetAddress.getByName(engineAddress);

			socket = new Socket(dstInetAddr, enginePort);
			socket.setSoTimeout(timeOut);

			OutputStream os = socket.getOutputStream();
			XMLOutputter outputter = XMLOutputterFormat.getInstance()
					.getXMLOutputterFormat();
			outputter.output(createDocument(), os);
			inputStream = socket.getInputStream();
			/*
			 * logger.info("Connect : " + " EngineAddress=" + engineAddress + "
			 * Port=" + enginePortString);
			 */
		} catch (UnknownHostException ex) {
			logger.warning("UnknownHostException : " + ex.getMessage()
					+ " EngineAddress=" + engineAddress + " Port="
					+ enginePortString);
			throw ex;
		} catch (ConnectException ex) {
			logger.warning("ConnectException : " + ex.getMessage()
					+ " EngineAddress=" + engineAddress + " Port="
					+ enginePortString);
			throw ex;
		} catch (IOException ex) {
			logger.warning("IOException : " + ex.getMessage()
					+ " EngineAddress=" + engineAddress + " Port="
					+ enginePortString);
			throw ex;
		}

	}

	/**
	 * GWXML SocketڑGWXML Socket͂܂B
	 * 
	 */
	public void run() {

		try {
			bufferInStream = new BufferedInputStream(inputStream);

			while (isThreadRun) {

				try {

					if (parseInputStream(bufferInStream)) {
						bufferInStream.mark(MARK_RESET);
						inputStream.mark(MARK_RESET);
					}
					Thread.sleep(WAIT_SLEEP_TIME);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					break;

				}
			}

		} finally {

			if (engineConnectStateMap.containsKey(engineAddressString)) {
				engineConnectStateMap.put(engineAddressString,
						XMLSocketConnectThread.UNCONNECT_MSG);
				logger.warning("Disconnect engine IP=" + engineAddressString);
			}
			if (bufferInStream != null) {
				try {
					bufferInStream.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}
			if (socket != null) {
				try {
					socket.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}
		}
	}

	/*
	 * M̓Xg[f[^ǂݏoXML͂܂B
	 * 
	 * @param buffInStream M̓Xg[
	 */
	private boolean parseInputStream(BufferedInputStream buffInStream) {
		boolean isParse = false;
		try {
			int availableCount = buffInStream.available();
			if (availableCount <= 1) {
				return isParse;
			}

			buffInStream.mark(availableCount);
			byte[] receiveBuff = new byte[availableCount];
			buffInStream.read(receiveBuff, 0, availableCount);
			/*
			 * logger.info( hexBytetoString(receiveBuff, availableCount));
			 */
			int startCount = 0;
			for (int i = 0; i < receiveBuff.length; i++) {
				if (receiveBuff[i] == 0x00) {
					isParse = true;
					byte[] parseBuff = new byte[(i - 1) - startCount];
					System.arraycopy(receiveBuff, startCount, parseBuff, 0,
							parseBuff.length);
					parseDocument(parseBuff);
					startCount = i + 1;

				}
			}
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}
		return isParse;

	}

	/*
	 * Mobt@XML͂ACxgoɂ̓A[ʒm܂B
	 * 
	 * @param receiveBuff XMLi[Mobt@
	 */
	private void parseDocument(byte[] receiveBuff) {

		Document doc = null;
		try {

			ByteArrayInputStream byteArrayInStream = new ByteArrayInputStream(
					receiveBuff);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(byteArrayInStream);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			logger.warning("ConnectException : " + e.getMessage()
					+ " EngineAddress=" + engineAddressString + " Port="
					+ enginePortString);
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			logger.warning("ConnectException : " + e.getMessage()
					+ " EngineAddress=" + engineAddressString + " Port="
					+ enginePortString);

		}

		if (doc == null) {
			return;
		}

		try {

			Element root = doc.getRootElement();
			String response_text = root
					.getAttributeValue(XMLSocketThread.RESP_STR);
			// logger.info("response_text : " + response_text);
			if (!response_text.equals(XMLSocketThread.CONNECT_CHECK)
					&& (response_text.indexOf("CONNECT") != 0)) {

				Pattern pattern;
				String[] xmlAlarmArray;
				pattern = Pattern.compile(":[ ]");
				xmlAlarmArray = pattern.split(response_text, 2);
				setAlarmInfo(engineAddressString, xmlAlarmArray[0],
						xmlAlarmArray[1]);
			}

		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/*
	 * GWvbVʒmꂽXML SocketA[QueueɃZbg ܂B
	 * 
	 * @param engineAddress GWAhX @param ipaddress A[om[hAhX @param
	 * message A[bZ[W
	 */
	private void setAlarmInfo(String engineAddress, String ipaddress,
			String message) {
		AlarmCodeInformation alarminfo = new AlarmCodeInformation();
		alarminfo.setEngineAddress(engineAddress);
		alarminfo.setIpaddress(ipaddress);
		alarminfo.setMessage(message);
		AlarmMessageQueue.getInstance().pushAlarmData(alarminfo);

		isAlarm = true;
		XMLSocketAlarmReceiveMessageQueue.getInstance().pushXMLAlarmData(
				alarminfo);

	}

	/*
	 * GWɑMDocument𐶐܂B
	 * 
	 * @return doc Document
	 */
	private Document createDocument() {

		Element confElement = new Element("send_info");
		Document doc = new Document(confElement);
		confElement.setAttribute(XMLSocketThread.SEND_TEXT,
				XMLSocketThread.ECLIPSE_RCP);

		return doc;
	}

	/**
	 * finalI[o[Ch܂B
	 * 
	 */
	protected void finalize() throws java.lang.Throwable {
		close();
		super.finalize();
	}

	/*
	 * \[XN[Y܂B
	 * 
	 */
	private void close() {
		if (bufferInStream != null) {
			try {
				bufferInStream.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
		if (inputStream != null) {
			try {
				inputStream.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
		if (socket != null) {
			try {
				socket.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
	}

	/**
	 * GWƂXML SocketڑĂThread~tO Zbg܂B
	 * 
	 * @param isThreadRun
	 *            Thread~tO
	 */
	public void setThreadRun(boolean isThreadRun) {
		this.isThreadRun = isThreadRun;
	}

	/**
	 * A[oۂ̃tOԂ܂B
	 * 
	 * @return isAlarm A[oۂ̃tO
	 */
	public boolean isAlarm() {
		return isAlarm;
	}

	/**
	 * A[otOZbg܂B
	 * 
	 * @param isAlarm
	 *            A[otOɃZbgtO
	 */
	public void setAlarm(boolean isAlarm) {
		this.isAlarm = isAlarm;
	}

	/**
	 * GWAhXԂ܂B
	 * 
	 * @return engineAddressString GWAhX
	 */
	public String getEngineAddress() {
		return engineAddressString;
	}

}
