/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

/**
 * Client[hɂGWƂXML Socketڑ𐧌䂷ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketEditorView extends AbstractEditorNodeView {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = "XML Socket Connection";

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 400, 300 };

	/* List widthhint */
	private static final int LIST_WIDTHHINT = 200;

	/* List verticalSpan */
	private static final int LIST_VERTIALSPAN = 7;

	/* List ItemHeight */
	private static final int LIST_ITEMHEIGHT = 10;

	/* GWAhXXg */
	private List detinationEngineAddressList;

	/* bZ[WXg */
	private List messageList;

	/* GWڑ񃊃Xg */
	private ArrayList engineList;

	/* GWڑMap */
	private HashMap engineMap;

	/* Display */
	private Display display;

	/* Logging */
	private static Logger logger;

	private XMLSocketConnectTimerProcessor timerProcessor;

	private Button connectButton;

	private Button disconnectButton;

	private Button messageResetButton;

	/* eLXg\BackGroundFi[ */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public XMLSocketEditorView() {
		logger = Logger.getLogger(this.getClass().getName());
		engineMap = new HashMap();
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();

		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		/* Button */
		connectButton = new Button(composite1, SWT.NONE);
		connectButton.setText("Connect");

		disconnectButton = new Button(composite1, SWT.NONE);
		disconnectButton.setText("Disconnect");

		GridLayout gridLayout2 = new GridLayout(6, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		Label label = new Label(composite2, SWT.NONE);
		label.setText("Engine List");
		label.setLayoutData(new GridData());

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("     ");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Message List");
		label.setLayoutData(new GridData());

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("     ");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		detinationEngineAddressList = new List(composite2, SWT.SINGLE
				| SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = LIST_VERTIALSPAN;
		data.widthHint = LIST_WIDTHHINT;
		data.heightHint = detinationEngineAddressList.getItemHeight()
				* LIST_ITEMHEIGHT;
		detinationEngineAddressList.setLayoutData(data);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("    ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = LIST_VERTIALSPAN;
		label.setLayoutData(gridData);

		messageResetButton = new Button(composite2, SWT.NONE);
		messageResetButton.setText("Message Reset");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = LIST_VERTIALSPAN;
		messageResetButton.setLayoutData(gridData);

		GridData data2 = new GridData(GridData.FILL_BOTH);
		messageList = new List(composite2, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);

		data2.horizontalSpan = 1;
		data2.verticalSpan = LIST_VERTIALSPAN;
		data2.widthHint = LIST_WIDTHHINT * 2;
		data2.heightHint = messageList.getItemHeight() * LIST_ITEMHEIGHT;

		messageList.setLayoutData(data2);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		disconnectButton.setEnabled(false);

		connectButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				startXMLSocket();

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		disconnectButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				disconnectButton.setEnabled(false);
				connectButton.setEnabled(true);
				try {
					startTimer();
					XMLSocketConnectThread.getInstance()
							.stopXMLSocketConnectThread();
				} catch (Exception e) {
					disconnectButton.setEnabled(true);
					e.printStackTrace();

				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		messageResetButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				messageResetButton.setEnabled(false);

				try {
					messageList.removeAll();

				} finally {
					messageResetButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		startXMLSocket();
		setList();
	}

	private void startXMLSocket() {
		engineList = EngineResourceConfig.getInstance().getEngineInfo()
				.getEngineInfoList();
		try {
			connectButton.setEnabled(false);
			disconnectButton.setEnabled(true);
			startTimer();
			XMLSocketConnectThread.getInstance().startXMLSocketConnectThread(
					engineList);
		} catch (Exception e) {
			connectButton.setEnabled(true);
			e.printStackTrace();

		}
	}

	private void setList() {

		engineList = EngineResourceConfig.getInstance().getEngineInfo()
				.getEngineInfoList();

		if (XMLSocketConnectThread.getInstance().checkThread()) {
			disconnectButton.setEnabled(true);
			connectButton.setEnabled(false);
			return;

		}
		detinationEngineAddressList.removeAll();

		String engineAddress = "";
		String enginePortString = "";
		engineMap.clear();

		for (int i = 0; i < engineList.size(); i++) {
			engineAddress = ((EngineResourceInfo) engineList.get(i))
					.getEngineIPaddress();
			enginePortString = ((EngineResourceInfo) engineList.get(i))
					.getEnginePort();

			detinationEngineAddressList.add(engineAddress
					+ XMLSocketConnectThread.UNCONNECT_MSG);

			engineMap.put(((EngineResourceInfo) engineList.get(i))
					.getEngineIPaddress(), engineList.get(i));
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	private void startTimer() {
		XMLSocketConnectTimerProcessor.getInstance().setDisplay(display);

		timerProcessor = XMLSocketConnectTimerProcessor.getInstance();
		timerProcessor.setEditorSite(getEditorSite());
		timerProcessor.setList(detinationEngineAddressList, messageList);

		display.timerExec(XMLSocketConnectTimerProcessor.TIMER, timerProcessor);
	}

	private void stopTimer() {

		display.timerExec(XMLSocketConnectTimerProcessor.TIMER_STOP,
				timerProcessor);
	}

	/**
	 * Colorj܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (textBackColor != null) {
			textBackColor.dispose();
		}
	}
}
