/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.application;

import javax.xml.parsers.FactoryConfigurationError;
import netjfwatcher.application.NetJFWatcherMenuManager;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.application.NetJFWatcherPreference;
import netjfwatcher.engine.top.TopPerspective;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class NetJFWatcherAdvisor
extends WorkbenchAdvisor {
    public static final String TITLE = "NetJFWatcher";
    public static final String WORKBENCH_CONFIGURER = "WorkbenchConfigurer";
    public static final String PROMPT_ON_EXIT_PREFERENCE = "net.sourceforge.eclipsetrader.promptOnExit";
    private static final String CONFIRM_EXIT_MESSAGE = "Exit Eclipse NetJFWatcher ?";
    private static Logger logger;

    public NetJFWatcherAdvisor() {
        logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        IPreferenceStore store = NetJFWatcherPlugin.getDefault().getPreferenceStore();
        boolean workBenchConfigSet = store.getBoolean(WORKBENCH_CONFIGURER);
        configurer.setSaveAndRestore(workBenchConfigSet);
        this.initLog4j();
    }

    public String getInitialWindowPerspectiveId() {
        return TopPerspective.class.getName();
    }

    public void eventLoopException(Throwable exception) {
        logger.error((Object)"Unhandled event loop exception.", exception);
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
        if (flags != 0) {
            NetJFWatcherMenuManager.getInstance().fillMenuBar(window, configurer);
        }
        if (flags != 0) {
            ICoolBarManager coolBar = configurer.getCoolBarManager();
            coolBar.add((IContributionItem)new GroupMarker("additions"));
        }
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean preShutdown() {
        Point p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getSize();
        NetJFWatcherPreference.WORKBENCH_WIDTH.putInt(p.x);
        NetJFWatcherPreference.WORKBENCH_HEIGHT.putInt(p.y);
        NetJFWatcherMenuManager.getInstance().stopHsqlDB();
        return true;
    }

    public void preStartup() {
        super.preStartup();
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        configurer.setInitialSize(new Point(NetJFWatcherPreference.WORKBENCH_WIDTH.getInt(), NetJFWatcherPreference.WORKBENCH_HEIGHT.getInt()));
        configurer.setTitle(TITLE);
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(false);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
        IPreferenceStore store = NetJFWatcherPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean(PROMPT_ON_EXIT_PREFERENCE);
        if (promptOnExit) {
            MessageDialogWithToggle msgDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)configurer.getWindow().getShell(), (String)"Confirm Exit", (String)CONFIRM_EXIT_MESSAGE, (String)"Always exit without prompt", (boolean)false, null, null);
            if (msgDialog.getReturnCode() != 0) {
                return false;
            }
            if (msgDialog.getToggleState()) {
                store.setValue(PROMPT_ON_EXIT_PREFERENCE, false);
                NetJFWatcherPlugin.getDefault().savePluginPreferences();
            }
        }
        return true;
    }

    private void initLog4j() throws FactoryConfigurationError {
        BasicConfigurator.configure();
    }
}

