/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.socket.info.ResourceInfo;

public class DBTableAlarmFilter
extends DBTableBase {
    public static final String ALARM_FILTER_TABLE = "alarm_filter_table";
    public static final String ALARM_ID = "id";
    public static final String NODENAME = "nodename";
    public static final String IPADDRESS = "ipaddress";
    public static final String ALARM_CODE = "alarm_code";
    public static final String ALARM_LEVEL = "alarm_level";
    public static final String ALARM_MESSAGE = "alarm_message";
    public static final String ALARM_CONFIRM = "alarm_confirm";
    public static final String ALARM_START_DATE = "alarm_start_date";
    public static final String ALARM_END_DATE = "alarm_end_date";
    public static final String ANY = "*";
    public static final String CONFIM = "unconfirm";
    private static Logger logger = null;
    private final String alarmID;

    public DBTableAlarmFilter() {
        logger = Logger.getLogger(this.getClass().getName());
        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        ResourceInfo resourceInfo = resourceset.getResourceInfo();
        String kind = resourceInfo.getDatabaseName();
        this.alarmID = kind.equals("HSQLDB") ? "'0'" : (kind.equals("Apache Derby") || kind.equals("Embedded Derby") ? "1" : "'1'");
    }

    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            this.deleteTable(databaseAccess, ALARM_FILTER_TABLE);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropAlarmFilterTableSequenceSQL());
            databaseAccess.executeUpdate(dataaccessobject.getCreateAlarmFilterTableSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, ALARM_FILTER_TABLE);
            this.dropSequence(databaseAccess, dataaccessobject.getDropAlarmFilterTableSequenceSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void putAlarmFilter() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            String nodename = ANY;
            String ipaddress = ANY;
            String alarmCode = ANY;
            String alarmLevel = ANY;
            String alarmMessage = ANY;
            String alarmConfirm = CONFIM;
            String alarmStartDate = Long.toString(date.getTime());
            String alarmEndDate = ANY;
            databaseAccess.executeUpdate("insert into alarm_filter_table( nodename, ipaddress, alarm_code, alarm_level, alarm_message,alarm_confirm,alarm_start_date, alarm_end_date ) VALUES( '" + nodename + "'," + "'" + ipaddress + "'," + "'" + alarmCode + "'," + "'" + alarmLevel + "'," + "'" + alarmMessage + "'," + "'" + alarmConfirm + "'," + " '" + alarmStartDate + "'," + " '" + alarmEndDate + "'" + ")");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public void updateAlarmFilter(AlarmViewFilter alarmViewFilter) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String nodename = alarmViewFilter.getNodename();
            String ipaddress = alarmViewFilter.getIpaddress();
            String alarmCode = alarmViewFilter.getAlarmCode();
            String alarmLevel = alarmViewFilter.getAlarmLevel();
            String alarmMessage = alarmViewFilter.getAlarmMessage();
            String alarmConfirm = alarmViewFilter.getAlarmConfirm();
            String alarmStartDate = alarmViewFilter.getAlarmStartDate();
            String alarmEndDate = alarmViewFilter.getAlarmEndDate();
            String sql = "";
            sql = "UPDATE alarm_filter_table set nodename= '" + nodename + "'," + IPADDRESS + "= " + "'" + ipaddress + "'," + ALARM_CODE + "= " + "'" + alarmCode + "'," + ALARM_LEVEL + "= " + "'" + alarmLevel + "'," + ALARM_MESSAGE + "= " + "'" + alarmMessage + "'," + ALARM_CONFIRM + "= " + "'" + alarmConfirm + "'," + ALARM_START_DATE + "= " + "'" + alarmStartDate + "'," + ALARM_END_DATE + "= " + "'" + alarmEndDate + "'" + " where " + ALARM_ID + "=" + this.alarmID;
            databaseAccess.executeUpdate(sql);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public ArrayList findAll() throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<AlarmViewFilter> alarmFilterList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "SELECT * from alarm_filter_table";
            System.out.println(sql);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            alarmFilterList = new ArrayList<AlarmViewFilter>();
            while (rs.next()) {
                AlarmViewFilter alarmViewFilter = new AlarmViewFilter();
                alarmViewFilter.setNodename(rs.getObject(NODENAME).toString());
                alarmViewFilter.setIpaddress(rs.getObject(IPADDRESS).toString());
                alarmViewFilter.setAlarmCode(rs.getObject(ALARM_CODE).toString());
                alarmViewFilter.setAlarmLevel(rs.getObject(ALARM_LEVEL).toString());
                alarmViewFilter.setAlarmMessage(rs.getObject(ALARM_MESSAGE).toString());
                alarmViewFilter.setAlarmConfirm(rs.getObject(ALARM_CONFIRM).toString());
                alarmViewFilter.setAlarmStartDate(rs.getObject(ALARM_START_DATE).toString());
                if (rs.getObject(ALARM_END_DATE) != null) {
                    alarmViewFilter.setAlarmEndDate(rs.getObject(ALARM_END_DATE).toString());
                } else {
                    alarmViewFilter.setAlarmEndDate(null);
                }
                alarmFilterList.add(alarmViewFilter);
            }
            ArrayList<AlarmViewFilter> arrayList = alarmFilterList;
            return arrayList;
        }
        catch (DatabaseConnectionException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
        }
    }
}

