/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.IfTypeMibDisplay;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.InterfaceMib;

public final class DBTableInterfaceMIB
extends DBTableBase {
    public static final String SNMP_IF_TABLE_NAME = "_if";
    public static final String IF_INDEX = "ifIndex";
    public static final String IF_DESC = "ifDesc";
    public static final String IF_TYPE = "ifType";
    public static final String IF_MTU = "ifMtu";
    public static final String IF_SPEED = "ifSpeed";
    public static final String IF_PHYSADDRESS = "ifPhysAddress";
    public static final String IF_STATUS = "ifStatus";
    public static final String IF_ADMINSTATUS = "ifAdminStatus";
    public static final String IF_OPERSTATUS = "ifOperStatus";
    public static final String IF_CURDATE = "curdate";
    private static final int COLUMN_IFINDEX_NO = 1;
    private static final int COLUMN_IFDESC_NO = 2;
    private static final int COLUMN_IFTYPE_NO = 3;
    private static final int COLUMN_IFMTU_NO = 4;
    private static final int COLUMN_IFSPEED_NO = 5;
    private static final int COLUMN_IFPHYSADDRESS_NO = 6;
    private static final int COLUMN_IFADMINSTATUS_NO = 7;
    private static final int COLUMN_IFOPERSTATUS_NO = 8;
    private static Logger logger = null;
    public static final String UP_CODE = "1";
    public static final String DOWN_CODE = "2";
    public static final String TESTING_CODE = "3";
    public static final String UP_STATUS = "Up";
    public static final String DOWN_STATUS = "Down";
    public static final String TESTING_STATUS = "Testing";
    private static final String SNMP_INTERFACE_TABLE_ITEM = " (ifIndex BIGINT , ifDesc VARCHAR(255), ifType  VARCHAR(10),ifMtu VARCHAR(10),ifSpeed VARCHAR(20),ifPhysAddress VARCHAR(40),ifAdminStatus VARCHAR(10),ifOperStatus VARCHAR(10) ,curdate TIMESTAMP )";
    private final IfTypeMibDisplay ifTypeMibDisplay = new IfTypeMibDisplay();
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableInterfaceMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void createTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_IF_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_IF_TABLE_NAME + SNMP_INTERFACE_TABLE_ITEM);
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(targetIpAddress, String.valueOf(ipaddress) + SNMP_IF_TABLE_NAME, "no");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_IF_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized ArrayList findSNMPInterfaces(String tragetIpAddress, boolean isConvIfDesc) throws SQLException, DatabaseConnectionException {
        String convipaddress = "IP" + tragetIpAddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<InterfaceMib> nodeSNMPInterfacesList = new ArrayList<InterfaceMib>();
        try {
            String sql = "SELECT * from " + convipaddress + SNMP_IF_TABLE_NAME + " order by " + IF_INDEX + " asc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                InterfaceMib nodeInterfaceMib = new InterfaceMib();
                nodeInterfaceMib.setIfIndex(rs.getObject(IF_INDEX).toString());
                nodeInterfaceMib.setIfDesc(rs.getObject(IF_DESC).toString());
                nodeInterfaceMib.setIfMtu(rs.getObject(IF_MTU).toString());
                nodeInterfaceMib.setIfSpeed(rs.getObject(IF_SPEED).toString());
                nodeInterfaceMib.setIfPhysAddress(rs.getObject(IF_PHYSADDRESS).toString());
                nodeInterfaceMib.setIfAdminStatus(rs.getObject(IF_ADMINSTATUS).toString());
                nodeInterfaceMib.setIfOperStatus(rs.getObject(IF_OPERSTATUS).toString());
                String ifStatus = this.setIfStatus(rs.getObject(IF_OPERSTATUS).toString(), rs.getObject(IF_ADMINSTATUS).toString());
                nodeInterfaceMib.setIfStatus(ifStatus);
                if (isConvIfDesc) {
                    nodeInterfaceMib.setIfType(this.ifTypeMibDisplay.getIfTypeString(rs.getObject(IF_TYPE).toString()));
                } else {
                    nodeInterfaceMib.setIfType(rs.getObject(IF_TYPE).toString());
                }
                nodeSNMPInterfacesList.add(nodeInterfaceMib);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        return nodeSNMPInterfacesList;
    }

    public synchronized void putSNMPInterfaces(String tragetIpAddress, ArrayList[] interfacesList) throws DatabaseConnectionException, SQLException {
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                int i = 0;
                while (i < interfacesList[1].size()) {
                    String ifDesc = ((MibValue)interfacesList[2].get(i)).getMibValue();
                    if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                        databaseAccess.executeUpdate("insert into " + ipaddressTableName + SNMP_IF_TABLE_NAME + "( " + IF_INDEX + ", " + IF_DESC + ", " + IF_TYPE + ", " + IF_MTU + ", " + IF_SPEED + ", " + IF_PHYSADDRESS + ", " + IF_ADMINSTATUS + ", " + IF_OPERSTATUS + ", " + IF_CURDATE + " )" + " VALUES( " + ((MibValue)interfacesList[1].get(i)).getMibValue() + "," + "'" + ifDesc + "'," + "'" + ((MibValue)interfacesList[3].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[4].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[5].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[6].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[7].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[8].get(i)).getMibValue() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")");
                    } else {
                        databaseAccess.executeUpdate("insert into " + ipaddressTableName + SNMP_IF_TABLE_NAME + "( " + IF_INDEX + ", " + IF_DESC + ", " + IF_TYPE + ", " + IF_MTU + ", " + IF_SPEED + ", " + IF_PHYSADDRESS + ", " + IF_ADMINSTATUS + ", " + IF_OPERSTATUS + ", " + IF_CURDATE + " )" + " VALUES( " + "'" + ((MibValue)interfacesList[1].get(i)).getMibValue() + "'," + "'" + ifDesc + "'," + "'" + ((MibValue)interfacesList[3].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[4].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[5].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[6].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[7].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[8].get(i)).getMibValue() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")");
                    }
                    ++i;
                }
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress);
                throw ex;
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void updateSNMPInterfaces(String tragetIpAddress, ArrayList[] interfacesArrayList) throws DatabaseConnectionException, SQLException {
        this.checkInterfaceMib(tragetIpAddress, interfacesArrayList);
        String ipaddressTablename = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTablename = ipaddressTablename.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                this.updateIntefaceTabel(databaseAccess, interfacesArrayList, ipaddressTablename);
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress);
                ex.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private void checkInterfaceMib(String tragetIpAddress, ArrayList[] interfacesArrayList) throws DatabaseConnectionException, SQLException {
        ArrayList preOidList = this.findSNMPInterfaces(tragetIpAddress, false);
        if (interfacesArrayList[1].size() != preOidList.size()) {
            String message = "(" + preOidList.size() + "-->" + interfacesArrayList[1].size() + ")";
            this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            logger.info("interfacesList[COLUMN_IFINDEX_NO].size() : " + interfacesArrayList[1].size());
            logger.info("preOidList.size() : " + preOidList.size());
            int i = 0;
            while (i < preOidList.size()) {
                InterfaceMib interfaceMib = (InterfaceMib)preOidList.get(i);
                logger.info("IfIndex : " + interfaceMib.getIfIndex());
                logger.info("IfDesc : " + interfaceMib.getIfDesc());
                logger.info("IfMtu : " + interfaceMib.getIfMtu());
                logger.info("IfSpeed : " + interfaceMib.getIfSpeed());
                logger.info("IfPhysAddress : " + interfaceMib.getIfPhysAddress());
                ++i;
            }
            i = 0;
            while (i < interfacesArrayList.length) {
                ArrayList ifList = interfacesArrayList[i];
                int j = 0;
                while (j < ifList.size()) {
                    logger.info("now i=" + i + " j=" + j + " value=" + (String)ifList.get(j));
                    ++j;
                }
                ++i;
            }
            this.deleteIfIndex(tragetIpAddress, preOidList);
            this.putSNMPInterfaces(tragetIpAddress, interfacesArrayList);
            return;
        }
        int oidCount = 0;
        while (oidCount < interfacesArrayList[1].size()) {
            String ifPhysAddress;
            String ifPhysAddressOld;
            String ifSpeed;
            String ifSpeedOld;
            String ifMtu;
            String ifMtuOld;
            String ifTypeOld;
            String ifIndex = ((MibValue)interfacesArrayList[1].get(oidCount)).getMibValue();
            String ifType = ((MibValue)interfacesArrayList[3].get(oidCount)).getMibValue();
            String ifDesc = ((MibValue)interfacesArrayList[2].get(oidCount)).getMibValue();
            String ifTypeName = this.ifTypeMibDisplay.getIfTypeString(ifType);
            String interfaceDescription = "(" + ifTypeName + " : " + ifDesc + ")";
            boolean isFoundIfIndex = false;
            InterfaceMib interfaceMibInfo = null;
            int j = 0;
            while (j < preOidList.size()) {
                interfaceMibInfo = (InterfaceMib)preOidList.get(j);
                String ifIndexOld = interfaceMibInfo.getIfIndex();
                if (ifIndexOld.equals(ifIndex)) {
                    isFoundIfIndex = true;
                    break;
                }
                ++j;
            }
            if (!isFoundIfIndex) {
                logger.warning("Not Found ifIndex " + interfaceMibInfo.getIfIndex());
                logger.warning("(Detect new ifIndex=" + ifIndex + " ifDesc=" + ifDesc + "(" + ifTypeName + "))");
                String message = "(Detect new ifIndex=" + ifIndex + " ifDesc=" + ifDesc + "(" + ifTypeName + "))";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
                this.deleteIfIndex(tragetIpAddress, preOidList);
                this.putSNMPInterfaces(tragetIpAddress, interfacesArrayList);
                return;
            }
            String ifDescOld = interfaceMibInfo.getIfDesc();
            if (!ifDescOld.equals(ifDesc) && !this.checkInterfaceMIBDataString(ifDesc, ifDescOld)) {
                logger.warning("Old ifDesc=" + ifDescOld + " New ifDesc=" + ifDesc);
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " ifDesc : " + ifDescOld + "-->" + ifDesc + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(ifTypeOld = interfaceMibInfo.getIfType()).equals(ifType)) {
                logger.warning("Old ifType=" + ifTypeOld + " New ifType=" + ifType);
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " ifType : " + ifTypeOld + "-->" + ifType + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(ifMtuOld = interfaceMibInfo.getIfMtu()).equals(ifMtu = ((MibValue)interfacesArrayList[4].get(oidCount)).getMibValue())) {
                logger.warning("Old ifMtu=" + ifMtuOld + " New ifMtu=" + ifMtu);
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " ifMtu : " + ifMtuOld + "-->" + ifMtu + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(ifSpeedOld = interfaceMibInfo.getIfSpeed()).equals(ifSpeed = ((MibValue)interfacesArrayList[5].get(oidCount)).getMibValue())) {
                logger.warning("Old ifSpeed=" + ifSpeedOld + " New ifSpeed=" + ifSpeed);
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " ifSpeed : " + ifSpeedOld + "-->" + ifSpeed + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(ifPhysAddressOld = interfaceMibInfo.getIfPhysAddress()).equals(ifPhysAddress = ((MibValue)interfacesArrayList[6].get(oidCount)).getMibValue())) {
                logger.info("Old ifPhysAddress=" + ifPhysAddressOld + " New ifPhysAddress=" + ifPhysAddress);
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " ifPhysAddress : " + ifPhysAddressOld + "-->" + ifPhysAddress + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            String ifAdminStatusOld = interfaceMibInfo.getIfAdminStatus();
            String ifAdminStatus = ((MibValue)interfacesArrayList[7].get(oidCount)).getMibValue();
            String ifOperStatusOld = interfaceMibInfo.getIfOperStatus();
            String ifOperStatus = ((MibValue)interfacesArrayList[8].get(oidCount)).getMibValue();
            if (!ifAdminStatusOld.equals(ifAdminStatus) || !ifOperStatusOld.equals(ifOperStatus)) {
                String nowStatus = this.setIfStatus(ifOperStatus, ifAdminStatus);
                String preStatus = this.setIfStatus(ifOperStatusOld, ifAdminStatusOld);
                logger.info("(ifIndex=" + ifIndex + interfaceDescription + " " + preStatus + "-->" + nowStatus + " (ifAdminStatus : " + ifAdminStatusOld + "-->" + ifAdminStatus + " , ifOperStatus : " + ifOperStatusOld + "-->" + ifOperStatus + "))");
                String message = "(ifIndex=" + ifIndex + interfaceDescription + " " + preStatus + "-->" + nowStatus + " (ifAdminStatus : " + ifAdminStatusOld + "-->" + ifAdminStatus + " , ifOperStatus : " + ifOperStatusOld + "-->" + ifOperStatus + "))";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            ++oidCount;
        }
    }

    private void setAlaram(String tragetIpAddress, String message, ArrayList[] interfacesArrayList, ArrayList preOidList) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngeInterfaceStatus(tragetIpAddress, message);
    }

    private void updateIntefaceTabel(DatabaseAccess databaseAccess, ArrayList[] interfacesArrayList, String ipaddressTablename) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        int i = 0;
        while (i < interfacesArrayList[1].size()) {
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                databaseAccess.executeUpdate("UPDATE " + ipaddressTablename + SNMP_IF_TABLE_NAME + " set " + IF_INDEX + "= " + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + ", " + IF_DESC + "='" + ((MibValue)interfacesArrayList[2].get(i)).getMibValue() + "', " + IF_TYPE + "='" + ((MibValue)interfacesArrayList[3].get(i)).getMibValue() + "', " + IF_MTU + "='" + ((MibValue)interfacesArrayList[4].get(i)).getMibValue() + "', " + IF_SPEED + "='" + ((MibValue)interfacesArrayList[5].get(i)).getMibValue() + "', " + IF_PHYSADDRESS + "='" + ((MibValue)interfacesArrayList[6].get(i)).getMibValue() + "', " + IF_ADMINSTATUS + "='" + ((MibValue)interfacesArrayList[7].get(i)).getMibValue() + "', " + IF_OPERSTATUS + "='" + ((MibValue)interfacesArrayList[8].get(i)).getMibValue() + "', " + IF_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IF_INDEX + "= " + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + " ");
            } else {
                databaseAccess.executeUpdate("UPDATE " + ipaddressTablename + SNMP_IF_TABLE_NAME + " set " + IF_INDEX + "='" + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + "', " + IF_DESC + "='" + ((MibValue)interfacesArrayList[2].get(i)).getMibValue() + "', " + IF_TYPE + "='" + ((MibValue)interfacesArrayList[3].get(i)).getMibValue() + "', " + IF_MTU + "='" + ((MibValue)interfacesArrayList[4].get(i)).getMibValue() + "', " + IF_SPEED + "='" + ((MibValue)interfacesArrayList[5].get(i)).getMibValue() + "', " + IF_PHYSADDRESS + "='" + ((MibValue)interfacesArrayList[6].get(i)).getMibValue() + "', " + IF_ADMINSTATUS + "='" + ((MibValue)interfacesArrayList[7].get(i)).getMibValue() + "', " + IF_OPERSTATUS + "='" + ((MibValue)interfacesArrayList[8].get(i)).getMibValue() + "', " + IF_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IF_INDEX + "='" + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + "';");
            }
            ++i;
        }
    }

    public synchronized void deleteIfIndex(String tragetIpAddress, ArrayList preOidList) throws DatabaseConnectionException, SQLException {
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            int i = 0;
            while (i < preOidList.size()) {
                InterfaceMib nodeview = (InterfaceMib)preOidList.get(i);
                String ifIndex = nodeview.getIfIndex();
                String sql = "";
                sql = "DELETE from " + ipaddressTableName + SNMP_IF_TABLE_NAME + " where " + IF_INDEX + "=" + "'" + ifIndex + "'";
                databaseAccess.executeUpdate(sql);
                ++i;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private boolean checkInterfaceMIBDataString(String newDataString, String oldDataString) {
        String checkIfDesc;
        int check2;
        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        String databaseKind = resourceset.getResourceInfo().getDatabaseName();
        int checkCode = 63;
        if (databaseKind.equals("MySQL")) {
            checkCode = 63;
        }
        boolean isMuch = false;
        int checkPos = oldDataString.indexOf(checkCode);
        if (checkPos > 0 && (check2 = newDataString.indexOf(checkIfDesc = oldDataString.substring(0, checkPos))) >= 0) {
            isMuch = true;
        }
        return isMuch;
    }

    private synchronized String setIfStatus(String ifOperStatus, String ifAdminStatus) {
        String ifStatus;
        if (ifOperStatus.equals(UP_CODE)) {
            ifStatus = UP_STATUS;
        } else if (ifOperStatus.equals(DOWN_CODE)) {
            ifStatus = DOWN_STATUS;
        } else if (ifOperStatus.equals(TESTING_CODE)) {
            ifStatus = TESTING_STATUS;
        } else {
            ifStatus = "Unknown";
            logger.warning("ifStatus=" + ifStatus + " (ifOperStatus=" + ifOperStatus + " ifAdminStatus=" + ifAdminStatus + ")");
        }
        return ifStatus;
    }

    public static DBTableInterfaceMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ DBTableInterfaceMIB(DBTableInterfaceMIB dBTableInterfaceMIB) {
        this();
    }

    private static class SingletonResource {
        static final DBTableInterfaceMIB RESOURCE = new DBTableInterfaceMIB(null);

        private SingletonResource() {
        }
    }
}

