/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;

public final class DBTableTaskSchedule
extends DBTableBase {
    public static final String TASK_SCHEDULEE_TABLE_NAME = "task_schedule";
    public static final String TASK_ID = "task_id";
    public static final String START_DATE = "start_date";
    public static final String END_DATE = "end_date";
    private static Logger logger = null;
    private DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableTaskSchedule() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableTaskSchedule getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            this.deleteTable(databaseAccess, TASK_SCHEDULEE_TABLE_NAME);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropTaskSCheduleTable());
            databaseAccess.executeUpdate(dataaccessobject.getCreateTaskSCheduleTable());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, TASK_SCHEDULEE_TABLE_NAME);
            this.dropSequence(databaseAccess, dataaccessobject.getDropTaskScheduleTableSequenceSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void put(String taskID, Date startDate, Date endDate) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            databaseAccess.executeUpdate("insert into task_schedule( task_id, start_date, end_date ) VALUES('" + taskID + "', " + "'" + this.simpleDateformat.format(startDate) + "'," + "'" + this.simpleDateformat.format(endDate) + "'" + ")");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized ArrayList findTarget(String taskID) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<TaskScheduleInfo> list = null;
        try {
            String sql = "SELECT * from task_schedule where task_id='" + taskID + "'";
            System.out.println(sql);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            list = new ArrayList<TaskScheduleInfo>();
            while (rs.next()) {
                TaskScheduleInfo taskInfo = new TaskScheduleInfo();
                if (rs.getObject(TASK_ID) != null) {
                    taskInfo.setTaskID(rs.getObject(TASK_ID).toString());
                }
                if (rs.getObject(START_DATE) != null) {
                    taskInfo.setTaskStartDate((Date)rs.getObject(START_DATE));
                }
                if (rs.getObject(END_DATE) != null) {
                    taskInfo.setTaskEndDate((Date)rs.getObject(END_DATE));
                }
                list.add(taskInfo);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        return list;
    }

    public synchronized ArrayList findAll() throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<TaskScheduleInfo> list = null;
        list = new ArrayList<TaskScheduleInfo>();
        try {
            String sql = "";
            sql = "SELECT * from task_schedule order by task_id desc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                TaskScheduleInfo taskInfo = new TaskScheduleInfo();
                if (rs.getObject(TASK_ID) != null) {
                    taskInfo.setTaskID(rs.getObject(TASK_ID).toString());
                }
                if (rs.getObject(START_DATE) != null) {
                    taskInfo.setTaskStartDate((Date)rs.getObject(START_DATE));
                }
                if (rs.getObject(END_DATE) != null) {
                    taskInfo.setTaskEndDate((Date)rs.getObject(END_DATE));
                }
                list.add(taskInfo);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
        }
        return list;
    }

    public synchronized void deleteTaskSchedule(String taskID) throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "";
            sql = "delete from task_schedule where task_id='" + taskID + "'";
            dataaccess.executeUpdate(sql);
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }

    /* synthetic */ DBTableTaskSchedule(DBTableTaskSchedule dBTableTaskSchedule) {
        this();
    }

    private static class SingletonResource {
        static final DBTableTaskSchedule RESOURCE = new DBTableTaskSchedule(null);

        private SingletonResource() {
        }
    }
}

