/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.osgi.framework.Bundle;

public final class IfTypeDetectFile {
    private static Logger logger;
    private HashMap ifTypeMap = new HashMap();

    private IfTypeDetectFile() {
        logger = Logger.getLogger(this.getClass().getName());
        this.parseIfTypeDefineFile();
    }

    private void parseIfTypeDefineFile() {
        String fileName = "resources/snmpIfType.data";
        int cnt = 0;
        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                String lineString;
                URL url = this.getDocumentURL(fileName);
                instream = url.openStream();
                instreamReader = new InputStreamReader(instream);
                bufReader = new BufferedReader(instreamReader);
                while ((lineString = bufReader.readLine()) != null) {
                    if (lineString.indexOf("#") >= 0) continue;
                    Pattern pattern = Pattern.compile("=");
                    String[] ifTypeJudgeArray = pattern.split(lineString);
                    try {
                        if (ifTypeJudgeArray.length != 2) {
                            logger.info(lineString);
                        } else {
                            this.ifTypeMap.put(ifTypeJudgeArray[0], ifTypeJudgeArray[1]);
                        }
                    }
                    catch (Exception e1) {
                        logger.warning(lineString);
                        e1.printStackTrace();
                    }
                    ++cnt;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instreamReader != null) {
                try {
                    instreamReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    public URL getDocumentURL(String fileName) {
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);
        if (url == null) {
            logger.severe("ifType defined file : " + fileName);
        }
        return url;
    }

    public static IfTypeDetectFile getInstance() {
        return SingletonResource.INSTANCE;
    }

    public HashMap getIfTypeMap() {
        return this.ifTypeMap;
    }

    /* synthetic */ IfTypeDetectFile(IfTypeDetectFile ifTypeDetectFile) {
        this();
    }

    private static class SingletonResource {
        static final IfTypeDetectFile INSTANCE = new IfTypeDetectFile(null);

        private SingletonResource() {
        }
    }
}

