/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model.apachederby;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyException;
import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class ApacheDerbyEmbeddedDerby {
    private static NetworkServerControl embeddedDerbyServer = null;
    private static final int TRY_COUNT = 4;
    private static final int ERROR_COUNT = 3;
    private static final int TRY_PERIOD = 5000;
    private static Logger logger;
    private boolean isEmbeddedDerby = false;
    private boolean isAbort;
    private String abortMessage = "";

    private ApacheDerbyEmbeddedDerby() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startEmbeddedDerby() throws Exception {
        if (this.isEmbeddedDerby) {
            throw new ApacheDerbyException("Already start EmbeddedDerby");
        }
        logger.info("Starting Embedded Apache Derby");
        this.isAbort = false;
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ApacheDerbyEmbeddedDerby.this.startWithProperty();
                    ApacheDerbyEmbeddedDerby.this.waitForStart();
                }
                catch (Exception e) {
                    ApacheDerbyEmbeddedDerby.this.abortMessage = "Abort start Embedded Derby " + e.getMessage();
                    logger.warning("Abort start Embedded Derby " + e.getMessage());
                    ApacheDerbyEmbeddedDerby.this.isAbort = true;
                }
            }
        });
        if (this.isAbort) {
            throw new Exception(this.abortMessage);
        }
    }

    public void stopEmbeddedDerby() throws SQLException {
        try {
            this.isEmbeddedDerby = false;
            logger.info("shutdown Embedded Derby");
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {}
    }

    private void startWithProperty() throws Exception {
        logger.info("derby.drda.startNetworkServer set true");
        System.setProperty("derby.drda.startNetworkServer", "true");
        logger.info("derby.drda.startNetworkServer" + System.getProperty("derby.drda.startNetworkServer"));
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.isEmbeddedDerby = true;
        }
        catch (InstantiationException e) {
            throw new ApacheDerbyException("InstantiationException " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ApacheDerbyException("IllegalAccessException " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ApacheDerbyException("ClassNotFoundException " + e.getMessage());
        }
    }

    private void waitForStart() throws Exception {
        logger.info("Testing if Network(Embedded Derby) Server is up and running!");
        embeddedDerbyServer = new NetworkServerControl();
        int i = 0;
        while (i < 4) {
            block3: {
                try {
                    Thread.sleep(5000L);
                    embeddedDerbyServer.ping();
                }
                catch (Exception e) {
                    logger.info("Try #" + i + " " + e.toString());
                    if (i < 3) break block3;
                    logger.warning("Giving up trying to connect to Network Server!");
                    throw e;
                }
            }
            ++i;
        }
        logger.info("Derby Network(Embedded Derby) Server now running");
    }

    public static ApacheDerbyEmbeddedDerby getInstance() {
        return SingletonResource.RESOURCE;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopEmbeddedDerby();
    }

    public boolean isEmbeddedDerby() {
        return this.isEmbeddedDerby;
    }

    public void setEmbeddedDerby(boolean isEmbeddedDerby) {
        this.isEmbeddedDerby = isEmbeddedDerby;
    }

    /* synthetic */ ApacheDerbyEmbeddedDerby(ApacheDerbyEmbeddedDerby apacheDerbyEmbeddedDerby) {
        this();
    }

    private static class SingletonResource {
        static final ApacheDerbyEmbeddedDerby RESOURCE = new ApacheDerbyEmbeddedDerby(null);

        private SingletonResource() {
        }
    }
}

