/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model.apachederby;

import java.net.InetAddress;
import java.util.logging.Logger;
import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ApacheDerbyNetworkServer {
    private static Thread apacheDerbyServerThread;
    private static Logger logger;
    private NetworkServerControl apacheDerbyNetworkServer;
    private String abortMessage = "";
    private boolean isAbort;

    private ApacheDerbyNetworkServer() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startDerbyNetworkServer() throws Exception {
        if (this.apacheDerbyNetworkServer != null) {
            throw new Exception("Already running Apache Derby Network Server");
        }
        this.isAbort = false;
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ApacheDerbyNetworkServer.this.apacheDerbyNetworkServer = new NetworkServerControl(InetAddress.getByName("localhost"), 1527);
                    apacheDerbyServerThread = new Thread(){

                        public void run() {
                            try {
                                ApacheDerbyNetworkServer.this.apacheDerbyNetworkServer.start(null);
                            }
                            catch (Exception e) {
                                ApacheDerbyNetworkServer.this.isAbort = true;
                                ApacheDerbyNetworkServer.this.abortMessage = "Abort start Apache Derby server " + e.getMessage();
                                logger.info("Abort start Apache Derby server " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    };
                    try {
                        apacheDerbyServerThread.start();
                    }
                    catch (Exception e) {
                        ApacheDerbyNetworkServer.this.isAbort = true;
                        ApacheDerbyNetworkServer.this.abortMessage = "Abort start Apache Derby server " + e.getMessage();
                        logger.info("Abort start Apache Derby server " + e.getMessage());
                        e.printStackTrace();
                        throw e;
                    }
                }
                catch (NoClassDefFoundError e) {
                    ApacheDerbyNetworkServer.this.isAbort = true;
                    ApacheDerbyNetworkServer.this.abortMessage = "Abort start Apache Derby server. ClassNotFoundException " + e.getMessage();
                    logger.info("Abort start Apache Derby server. ClassNotFoundException " + e.getMessage());
                }
                catch (Exception e) {
                    ApacheDerbyNetworkServer.this.isAbort = true;
                    ApacheDerbyNetworkServer.this.abortMessage = "Abort start Apache Derby server " + e.getMessage();
                    logger.info("Abort start Apache Derby server " + e.getMessage());
                    e.printStackTrace();
                }
                if (!ApacheDerbyNetworkServer.this.isAbort) {
                    ApacheDerbyNetworkServer.this.isAbort = ApacheDerbyNetworkServer.this.checkApacheDerby();
                }
            }
        });
        if (this.isAbort) {
            throw new Exception(this.abortMessage);
        }
    }

    private boolean checkApacheDerby() {
        int count = 10;
        boolean isApacheAbort = false;
        while (true) {
            try {
                this.apacheDerbyNetworkServer.ping();
            }
            catch (Exception e) {
                logger.warning("Apache Derby NetworkServer ping " + e.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
                if (--count >= 0) continue;
                this.abortMessage = "Abort start Apache Derby server at ping";
                isApacheAbort = true;
            }
            break;
        }
        return isApacheAbort;
    }

    public void stopDerbyNetworkServer() throws Exception {
        try {
            if (this.apacheDerbyNetworkServer != null) {
                this.apacheDerbyNetworkServer.shutdown();
                logger.info("Apache Derby NetworkServer shutdown");
                this.apacheDerbyNetworkServer = null;
            }
            if (apacheDerbyServerThread != null) {
                apacheDerbyServerThread.interrupt();
                logger.info("Apache Derby Server Thread interrupt");
            }
        }
        catch (Exception e) {
            logger.warning("Abort Apache Derby server stop " + e.getMessage());
            throw e;
        }
    }

    public void getSysInfoNetworkServer() throws Exception {
        if (this.apacheDerbyNetworkServer == null) {
            throw new Exception("Apache Derby inActive");
        }
        String myinfo = this.apacheDerbyNetworkServer.getSysinfo();
        this.apacheDerbyNetworkServer.getRuntimeInfo();
        Shell shell = new Shell();
        MessageDialog.openInformation((Shell)shell, (String)"Apache Derby sysinfo", (String)myinfo);
        shell.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopDerbyNetworkServer();
    }

    public static ApacheDerbyNetworkServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Thread getApacheDerbyServerThread() {
        return apacheDerbyServerThread;
    }

    /* synthetic */ ApacheDerbyNetworkServer(ApacheDerbyNetworkServer apacheDerbyNetworkServer) {
        this();
    }

    private static class SingletonResource {
        static final ApacheDerbyNetworkServer RESOURCE = new ApacheDerbyNetworkServer(null);

        private SingletonResource() {
        }
    }
}

