/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import netjfwatcher.engine.alarm.DocumentParseErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DialogMessageResource {
    public static final String EXIT = "0";
    public static final String MIBGETERROR = "0";
    public static final String MIBSETERROR = "1";
    public static final String SNMPV3CONFIGERROR = "2";
    public static final String SERVERCOMERR = "3";
    public static final String DBERR = "4";
    public static final String APPLICATIONERR = "5";
    public static final String ABORTRESERVE = "6";
    public static final String ABORTEDIT = "7";
    public static final String ABORTADD = "8";
    public static final String NOTARGET = "9";
    public static final String FILE_ACCESS_DENIED = "10";
    public static final String INPUT_DATA_NULL = "11";
    public static final String DATABASE_NULL = "12";
    public static final String CSVFILE_PARSE_ERR = "13";
    public static final String FILE_NOTFOUND = "14";
    public static final String DB_CREATE_ERR = "15";
    public static final String FILE_WRITE_ERR = "16";
    public static final String XMLFILE_PARSE_ERR = "17";
    public static final String XML_CREATE_ERR = "18";
    public static final String DATA_FILE_NO_SELECTED = "19";
    public static final String RMI_REGISTRY_SERVER_ERR = "20";
    public static final String RMI_REGISTRY_PORT_ERR = "21";
    public static final String RMI_INCOMING_PORT_ERR = "22";
    public static final String DOCUMENT_NOT_FOUND = "23";
    public static final String DOCUMENT_OPEN_ERR = "24";
    private static final String MESSAGE_XML_FILE = "resources/message.xml";
    private static final String CONFIRM_MESSAGE_TAG = "confirm";
    private static final String ALERT_MESSAGE_TAG = "alert";
    private static final String MESSAGE_TAG_ATTRIBUTE = "ID";
    private static final String MESSAGE_ID_NOTFOUND = "Application Error";
    private static HashMap alertMessageMap = new HashMap();
    private static HashMap confirmMessageMap = new HashMap();
    private static Logger logger = null;

    private DialogMessageResource() {
    }

    public static DialogMessageResource getInstance() {
        return SingletonMessage.MESSAGE;
    }

    public static String getConfirmMessage(String keyId) {
        if (confirmMessageMap.containsKey(keyId)) {
            return (String)confirmMessageMap.get(keyId);
        }
        return MESSAGE_ID_NOTFOUND;
    }

    public static String getAlertMessage(String keyId) {
        if (alertMessageMap.containsKey(keyId)) {
            return (String)alertMessageMap.get(keyId);
        }
        return MESSAGE_ID_NOTFOUND;
    }

    public void parseMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        logger = Logger.getLogger(DialogMessageResource.class.getName());
        ClassLoader loader = DialogMessageResource.class.getClassLoader();
        URL url = loader.getResource(MESSAGE_XML_FILE);
        if (url == null) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
        }
        try {
            dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(true);
            builder = dbfactory.newDocumentBuilder();
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(url.openStream());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        Element root = dom.getDocumentElement();
        Node firstFlightInfoNode = root.getFirstChild();
        DialogMessageResource.setMessageMap(confirmMessageMap, firstFlightInfoNode, CONFIRM_MESSAGE_TAG, MESSAGE_TAG_ATTRIBUTE);
        firstFlightInfoNode = root.getFirstChild();
        DialogMessageResource.setMessageMap(alertMessageMap, firstFlightInfoNode, ALERT_MESSAGE_TAG, MESSAGE_TAG_ATTRIBUTE);
    }

    private static void setMessageMap(HashMap messageMap, Node rootNode, String tagName, String tagAttribute) {
        Node targetNode = rootNode;
        while (targetNode != null) {
            if (targetNode.getNodeType() == 1 && targetNode.getNodeName().equals(tagName)) break;
            targetNode = targetNode.getNextSibling();
        }
        if (targetNode != null) {
            Node nodeLeaf = targetNode.getFirstChild();
            while (nodeLeaf != null) {
                if (nodeLeaf.getNodeType() == 1) {
                    NamedNodeMap map = nodeLeaf.getAttributes();
                    String messageId = null;
                    int j = 0;
                    while (j < map.getLength()) {
                        Node node = map.item(j);
                        if (node.getNodeName().equals(tagAttribute)) {
                            messageId = node.getNodeValue();
                        }
                        ++j;
                    }
                    messageMap.put(messageId, nodeLeaf.getFirstChild().getNodeValue());
                }
                nodeLeaf = nodeLeaf.getNextSibling();
            }
        }
    }

    /* synthetic */ DialogMessageResource(DialogMessageResource dialogMessageResource) {
        this();
    }

    private static class SingletonMessage {
        static final DialogMessageResource MESSAGE = new DialogMessageResource(null);

        private SingletonMessage() {
        }
    }
}

