/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderDatabaseWatch
extends Action {
    private static Logger logger;
    private IEditorPart editorNodeConfigView;
    private IAction databaseWatchAction = new ActionDatabaseWatch();
    private IAction databaseWatchActionSocket = new ActionDatabaseWatchSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderDatabaseWatch() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionDatabaseWatch() {
        return this.databaseWatchAction;
    }

    public IAction getActionDatabaseWatchSocket() {
        return this.databaseWatchActionSocket;
    }

    private abstract class AbstractDatabaseAction
    extends Action {
        private AbstractDatabaseAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public abstract class AbstractActionDatabaseView
    extends AbstractDatabaseAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabaseWatch.this.bundle.getEntry("icons/database.gif"));
        }

        public String getText() {
            return "Database Watch Node";
        }

        public String getToolTipText() {
            return "Database Watch Node";
        }

        protected void doTask() {
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionDatabaseWatch
    extends AbstractActionDatabaseView {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderDatabaseWatch.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderDatabaseWatch.this.editorNodeConfigView, false);
                ActionBuilderDatabaseWatch.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                ActionBuilderDatabaseWatch.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Database Watch Node View", this.nodeInfo, false), "netwatcher.database.view.EditorDatabaseWatcherConfigView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionDatabaseWatchSocket
    extends ActionDatabaseWatch {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderDatabaseWatch.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderDatabaseWatch.this.editorNodeConfigView, false);
                ActionBuilderDatabaseWatch.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                ActionBuilderDatabaseWatch.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Database Watch Node View", this.nodeInfo, true), "netwatcher.database.view.EditorDatabaseWatcherConfigView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

