/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.INodeTreeNode;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.webbrowser.nodetree.NodeListImport;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.HttpAccessException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeTree
extends Action {
    private static Logger logger = null;
    private HashMap nodeIconImageMap = new HashMap();
    private TreeViewer nodeListTreeViewer;
    private AbstractNodeTreeView nodeTreeView;
    private SubStatusLineManager statusLineManager;
    private Composite parentComposite;
    private NodeTreeGroup nodeTreeGroupRoot;
    private IEditorPart editorNodeConfigView;
    private ArrayList nodeInfoListHttp = new ArrayList();
    private ArrayList nodeInfoListSocket = new ArrayList();
    private HashMap groupMap = new HashMap();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction reloadNodeTreeDatabase = new ActionReloadNodeTreeDatabase();
    private IAction reloadNodeTreeHttp = new ActionReloadNodeTreeHttp();
    private IAction reloadNodeTreeSocket = new ActionReloadNodeTreeSocket();
    private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();
    private IAction sortNodeTreeHttp = new ActionSortNodeTreeHttp();
    private IAction sortNodeTreeSocket = new ActionSortNodeTreeSocket();

    public ActionBuilderNodeTree() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public ActionBuilderNodeTree(AbstractNodeTreeView nodeTreeView, TreeViewer nodeListTreeViewer, Composite parentComposite, NodeTreeGroup nodeTreeGroupRoot) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.nodeTreeView = nodeTreeView;
        this.nodeListTreeViewer = nodeListTreeViewer;
        this.parentComposite = parentComposite;
        this.nodeTreeGroupRoot = nodeTreeGroupRoot;
    }

    public TreeViewer getViewer() {
        return this.nodeListTreeViewer;
    }

    public IAction actionReloadNodeTreeDatabase() {
        return this.reloadNodeTreeDatabase;
    }

    public IAction actionReloadNodeTreeHttp() {
        return this.reloadNodeTreeHttp;
    }

    public IAction actionReloadNodeTreeSocket() {
        return this.reloadNodeTreeSocket;
    }

    public IAction actionSortNodeTreeDatabase() {
        return this.sortNodeTreeDatabase;
    }

    public IAction actionSortNodeTreeHttp() {
        return this.sortNodeTreeHttp;
    }

    public IAction actionSortNodeTreeSocket() {
        return this.sortNodeTreeSocket;
    }

    private void createNodeTree(NodeInformation nodeInfo, final boolean isSortDirectionTreeView) {
        String group = nodeInfo.getGroup();
        NodeTreeGroup nodetreeGroup = null;
        if (this.groupMap.containsKey(group)) {
            nodetreeGroup = (NodeTreeGroup)this.groupMap.get(group);
        } else {
            nodetreeGroup = new NodeTreeGroup(group);
            this.nodeTreeGroupRoot.addChild(nodetreeGroup);
            this.groupMap.put(group, nodetreeGroup);
        }
        String nodeName = String.valueOf(nodeInfo.getNodename()) + "(" + nodeInfo.getIpaddress() + ")";
        Image nodeIconImage = null;
        nodeIconImage = this.createNodeIconImage(nodeInfo.getNodeKind());
        nodetreeGroup.addChild(new NodeTree(nodeName, nodeInfo, nodeIconImage));
        this.nodeListTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name2;
                String name1;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (viewer == null || !(viewer instanceof ContentViewer)) {
                    name1 = e1.toString();
                    name2 = e2.toString();
                } else {
                    IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                    if (prov instanceof ILabelProvider) {
                        ILabelProvider lprov = (ILabelProvider)prov;
                        name1 = lprov.getText(e1);
                        name2 = lprov.getText(e2);
                    } else {
                        name1 = e1.toString();
                        name2 = e2.toString();
                    }
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                if (isSortDirectionTreeView) {
                    return this.collator.compare(name1, name2);
                }
                return this.collator.compare(name2, name1);
            }
        });
        this.nodeListTreeViewer.expandAll();
        this.nodeListTreeViewer.refresh();
    }

    private Image createNodeIconImage(String nodeKind) {
        String nodeIconFileName = MediaResource.getInstance().getNodeIconFullFileName(nodeKind);
        Image nodeIconImage = null;
        if (!this.nodeIconImageMap.containsKey(nodeIconFileName)) {
            Display display = this.parentComposite.getDisplay();
            URL url = null;
            url = this.bundle.getEntry(nodeIconFileName);
            if (url == null) {
                logger.severe("Npt found icon file : " + nodeIconFileName);
            } else {
                try {
                    nodeIconImage = new Image((Device)display, url.openStream());
                    this.nodeIconImageMap.put(nodeIconFileName, nodeIconImage);
                }
                catch (IOException e) {
                    logger.warning("Abort create image " + e.getMessage() + " for " + nodeIconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = (Image)this.nodeIconImageMap.get(nodeIconFileName);
        }
        return nodeIconImage;
    }

    protected void setStatusLine(int groupNo, int nodeNo) {
        this.statusLineManager = (SubStatusLineManager)this.nodeTreeView.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node Tree View Group count=" + groupNo + " Node count=" + nodeNo);
    }

    public INodeTreeNode getNodeBase() {
        IStructuredSelection selectElement = (IStructuredSelection)this.getViewer().getSelection();
        INodeTreeNode node = (INodeTreeNode)selectElement.getFirstElement();
        if (node == null) {
            node = (INodeTreeNode)this.getViewer().getInput();
        }
        return node;
    }

    public NodeTreeGroup setNodeGroupBase(INodeTreeNode node) {
        NodeTreeGroup baseNodeGroup = null;
        if (node != null) {
            baseNodeGroup = node.getParent();
        }
        if (node instanceof NodeTreeGroup) {
            baseNodeGroup = (NodeTreeGroup)node;
        }
        return baseNodeGroup;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
    }

    protected abstract class AbstractNodeAction
    extends Action {
        protected AbstractNodeAction() {
        }

        public final void run() {
            NodeTreeGroup baseNodeGroup = null;
            INodeTreeNode node = ActionBuilderNodeTree.this.getNodeBase();
            baseNodeGroup = ActionBuilderNodeTree.this.setNodeGroupBase(node);
            this.doTask(baseNodeGroup, node);
        }

        protected abstract void doTask(NodeTreeGroup var1, INodeTreeNode var2);

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Node Tree reload";
        }

        public String getToolTipText() {
            return "Node Tree reload";
        }
    }

    public final class ActionReloadNodeTreeDatabase
    extends AbstractNodeAction {
        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.setNodeTree();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setNodeTree() {
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.groupMap.clear();
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            ArrayList nodeList = null;
            try {
                try {
                    nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
                }
                catch (SQLException e1) {
                    block11: {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Node List import error ", (String)e1.getMessage());
                        logger.warning("Node List import error " + e1.getMessage());
                        shell.dispose();
                        e1.printStackTrace();
                        break block11;
                        catch (Exception e12) {
                            shell = new Shell();
                            MessageDialog.openError((Shell)shell, (String)"Node List import error ", (String)e12.getMessage());
                            logger.warning("Node List import error " + e12.getMessage());
                            shell.dispose();
                            e12.printStackTrace();
                        }
                    }
                    nodeRegisterDBTable = null;
                    return;
                }
            }
            finally {
                nodeRegisterDBTable = null;
            }
            if (nodeList == null) {
                return;
            }
            if (nodeList.size() == 0) {
                ActionBuilderNodeTree.this.nodeListTreeViewer.refresh();
                return;
            }
            int i = 0;
            while (i < nodeList.size()) {
                NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
                ActionBuilderNodeTree.this.createNodeTree(nodeInfo, true);
                ++i;
            }
            ActionBuilderNodeTree.this.setStatusLine(ActionBuilderNodeTree.this.groupMap.size(), nodeList.size());
        }
    }

    public final class ActionReloadNodeTreeHttp
    extends AbstractNodeAction {
        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.setNodeTree();
        }

        public void setNodeTree() {
            ArrayList nodeInfoImportList;
            IProgressMonitor monitor;
            block9: {
                Iterator it = null;
                for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                    NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                    if (nodeTreeGroup == null) continue;
                    NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                    parentNodeTreeGroup.removeChildAll();
                }
                ActionBuilderNodeTree.this.groupMap.clear();
                IWorkbench workbench = PlatformUI.getWorkbench();
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
                WWinActionBars bars = workbenchWindow.getActionBars();
                IStatusLineManager lineManager = bars.getStatusLineManager();
                monitor = lineManager.getProgressMonitor();
                monitor.beginTask("Reading ...  Node Tree ", 100);
                NodeListImport netNodeInfoImport = new NodeListImport();
                nodeInfoImportList = netNodeInfoImport.importNodeList();
                if (nodeInfoImportList.size() != 0) break block9;
                ActionBuilderNodeTree.this.nodeListTreeViewer.refresh();
                monitor.done();
                return;
            }
            try {
                try {
                    ActionBuilderNodeTree.this.nodeInfoListHttp.clear();
                    int i = 0;
                    while (i < nodeInfoImportList.size()) {
                        String[] nodeInfoArray = (String[])nodeInfoImportList.get(i);
                        NodeInformation nodeInfo = new NodeInformation();
                        nodeInfo.setIpaddress(nodeInfoArray[1]);
                        nodeInfo.setNodename(nodeInfoArray[0]);
                        nodeInfo.setGroup(nodeInfoArray[2]);
                        nodeInfo.setEngineAddress(nodeInfoArray[3]);
                        nodeInfo.setNodeKind(nodeInfoArray[6]);
                        ActionBuilderNodeTree.this.createNodeTree(nodeInfo, true);
                        ActionBuilderNodeTree.this.nodeInfoListHttp.add(nodeInfo);
                        ++i;
                    }
                    ActionBuilderNodeTree.this.setStatusLine(ActionBuilderNodeTree.this.groupMap.size(), nodeInfoImportList.size());
                }
                catch (HttpAccessException e) {
                    logger.warning(e.getMessage());
                    MessageBox alertMessageBox = new MessageBox(ActionBuilderNodeTree.this.parentComposite.getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                }
                catch (HttpAccessPreferenceException e) {
                    logger.warning(e.getMessage());
                    MessageBox alertMessageBox = new MessageBox(ActionBuilderNodeTree.this.parentComposite.getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                monitor.done();
            }
        }
    }

    public final class ActionReloadNodeTreeSocket
    extends AbstractNodeAction {
        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.setNodeTree();
        }

        public void setNodeTree() {
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.groupMap.clear();
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            try {
                ArrayList nodeList = connectNodeInfo.getNodeInformationList(null, null);
                String[] nodeIPAddress = new String[nodeList.size()];
                String[] nodeName = new String[nodeList.size()];
                if (nodeList.size() == 0) {
                    ActionBuilderNodeTree.this.nodeListTreeViewer.refresh();
                    return;
                }
                ActionBuilderNodeTree.this.nodeInfoListSocket.clear();
                int i = 0;
                while (i < nodeList.size()) {
                    NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
                    ActionBuilderNodeTree.this.createNodeTree(nodeInfo, true);
                    ActionBuilderNodeTree.this.nodeInfoListSocket.add(nodeInfo);
                    nodeIPAddress[i] = nodeInfo.getIpaddress();
                    nodeName[i] = nodeInfo.getNodename();
                    ++i;
                }
                ActionBuilderNodeTree.this.setStatusLine(ActionBuilderNodeTree.this.groupMap.size(), nodeList.size());
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
    }

    protected abstract class AbstractNodeSortAction
    extends AbstractNodeAction {
        protected AbstractNodeSortAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/sort_obj.gif"));
        }

        public String getText() {
            return "Sort Node Tree";
        }

        public String getToolTipText() {
            return "Sort Node Tree";
        }
    }

    protected final class ActionSortNodeTreeDatabase
    extends AbstractNodeSortAction {
        private String sortColumn0 = "nodegroup";
        private String sortDirection0 = "asc";
        private String sortColumn1 = "nodename";
        private String sortDirection1 = "asc";
        private boolean isSortToggle = true;

        protected ActionSortNodeTreeDatabase() {
        }

        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            if (this.isSortToggle) {
                this.sortDirection0 = "asc";
                this.sortDirection1 = "asc";
                this.isSortToggle = false;
            } else {
                this.sortDirection0 = "desc";
                this.sortDirection1 = "desc";
                this.isSortToggle = true;
            }
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof NodeTreeGroup) {
                    parentNodeTreeGroup = (NodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            this.setNodeTree();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void setNodeTree() {
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            ArrayList nodeList = null;
            try {
                try {
                    nodeList = nodeRegisterDBTable.getNodeInfoList(this.sortColumn0, this.sortDirection0, this.sortColumn1, this.sortDirection1);
                }
                catch (SQLException e1) {
                    block9: {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                        logger.warning("Node List import error" + e1.getMessage());
                        shell.dispose();
                        e1.printStackTrace();
                        break block9;
                        catch (Exception e12) {
                            shell = new Shell();
                            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e12.getMessage());
                            logger.warning("Node List import error" + e12.getMessage());
                            shell.dispose();
                            e12.printStackTrace();
                        }
                    }
                    nodeRegisterDBTable = null;
                    return;
                }
            }
            finally {
                nodeRegisterDBTable = null;
            }
            if (nodeList == null) {
                return;
            }
            int i = 0;
            while (i < nodeList.size()) {
                NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
                ActionBuilderNodeTree.this.createNodeTree(nodeInfo, this.isSortToggle);
                ++i;
            }
        }
    }

    protected final class ActionSortNodeTreeHttp
    extends AbstractNodeSortAction {
        private boolean isSortToggle = true;

        protected ActionSortNodeTreeHttp() {
        }

        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.isSortToggle = !this.isSortToggle;
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof NodeTreeGroup) {
                    parentNodeTreeGroup = (NodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            int i = 0;
            while (i < ActionBuilderNodeTree.this.nodeInfoListHttp.size()) {
                NodeInformation nodeInfo = (NodeInformation)ActionBuilderNodeTree.this.nodeInfoListHttp.get(i);
                ActionBuilderNodeTree.this.createNodeTree(nodeInfo, this.isSortToggle);
                ++i;
            }
        }
    }

    protected final class ActionSortNodeTreeSocket
    extends AbstractNodeSortAction {
        private boolean isSortToggle = true;

        protected ActionSortNodeTreeSocket() {
        }

        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.isSortToggle = !this.isSortToggle;
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof NodeTreeGroup) {
                    parentNodeTreeGroup = (NodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            int i = 0;
            while (i < ActionBuilderNodeTree.this.nodeInfoListSocket.size()) {
                NodeInformation nodeInfo = (NodeInformation)ActionBuilderNodeTree.this.nodeInfoListSocket.get(i);
                ActionBuilderNodeTree.this.createNodeTree(nodeInfo, this.isSortToggle);
                ++i;
            }
        }
    }
}

