/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.list;

import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderDatabaseWatch;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class NodeListTreeView
extends AbstractNodeTreeView {
    private static Logger logger = null;
    private NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();
    private NodePingMenu nodePingMenu = new NodePingMenu();
    private ActionBuilderNetworkCamera networkCameraAction = new ActionBuilderNetworkCamera();
    private ActionBuilderDatabaseWatch databaseWatchAction = new ActionBuilderDatabaseWatch();

    public NodeListTreeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void initShow() {
    }

    public void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeListTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.nodeListTreeViewer.getControl());
        this.nodeListTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeListTreeViewer);
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        toolBarManager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        toolBarManager.add(this.actionBuilderNodeOperation.getActionNodeOperation());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        manager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        if (this.nodeListTreeViewer.getTree().getSelection() != null) {
            TreeItem[] treeItem = this.nodeListTreeViewer.getTree().getSelection();
            if (treeItem != null && treeItem.length > 0) {
                int nodeTreeSelectNo = 0;
                while (nodeTreeSelectNo < treeItem.length) {
                    if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    } else if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
                        NodeInformation targetNodeInfo = ((NodeTree)treeItem[nodeTreeSelectNo].getData()).getNodeInfo();
                        ((ActionBuilderNodeOperation.ActionShowNodeView)this.actionBuilderNodeOperation.getActionShowNodeView()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actionBuilderNodeOperation.getActionShowNodeView());
                        ((ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm)this.actinAlarm.getActionOpenEditorPartPersonalNodeAlarm()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actinAlarm.getActionOpenEditorPartPersonalNodeAlarm());
                        ((ActionBuilderSnmp.ActionShowNodeSnmpView)this.snmpAction.getActionSnmpInfo()).setNodeInfo(targetNodeInfo);
                        manager.add(this.snmpAction.getActionSnmpInfo());
                        ((ActionBuilderNodeOperation.ActionNodeOperation)this.actionBuilderNodeOperation.getActionNodeOperation()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actionBuilderNodeOperation.getActionNodeOperation());
                        this.nodePingMenu.createPingMenu(manager, targetNodeInfo, false);
                        this.nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager, targetNodeInfo, false);
                        ((ActionBuilderSnmp.ActionSnmpStatisticsSet)this.snmpAction.getActionSnmpStatisticsSet()).setNodeInfo(targetNodeInfo);
                        manager.add(this.snmpAction.getActionSnmpStatisticsSet());
                        ((ActionBuilderDatabaseWatch.ActionDatabaseWatch)this.databaseWatchAction.getActionDatabaseWatch()).setNodeInfo(targetNodeInfo);
                        manager.add(this.databaseWatchAction.getActionDatabaseWatch());
                        if (targetNodeInfo.getNodeKind().equals("Printer")) {
                            ((ActionBuilderSnmp.ActionSnmpPrint)this.snmpAction.getActionPrintSnmp()).setNodeInfo(targetNodeInfo);
                            manager.add(this.snmpAction.getActionPrintSnmp());
                        }
                        if (targetNodeInfo.getNodeKind().equals("Camera")) {
                            ((ActionBuilderNetworkCamera.ActionNetworkCamera)this.networkCameraAction.getActionNetworkCamera()).setNodeInfo(targetNodeInfo);
                            manager.add(this.networkCameraAction.getActionNetworkCamera());
                        }
                    } else {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    }
                    ++nodeTreeSelectNo;
                }
            } else {
                manager.add(this.actionBuilderNodeOperation.getActionNodeOperation());
            }
        }
        manager.add(this.snmpAction.getActionSnmpStatistics());
        manager.add(this.actinAlarm.getActionShowAllNodeAlarmListTable());
        manager.add(this.actionBuilderNodeDetect.getActionNodeDetectView());
    }

    protected void setupNodeTreeViewListener() {
        this.nodeListTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ListenerNodeListTree(false));
    }
}

