/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.mail.MailSendFilter;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MailSendPreferencePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    public static final String MAIL_SEND_ON = "on";
    public static final String MAIL_SEND_OFF = "off";
    private static final int TEXT_WIDTH = 200;
    private static final int FILTER_TEXT_WIDTH = 300;
    private static final int COMBO_WIDTH = 120;
    private static final int GUARD_TIME_TEXT_WIDTH = 120;
    private static final int HOST_VALID_COMBO = 80;
    private static final int HORIZONTAL_SPAN2 = 2;
    private static Logger logger;
    private ResourceInfo info;
    private ArrayList mailPropList;
    private MailProperty[] mailprop;
    private int smtpHostSelectIndex = 0;
    private Combo smtpHostCombo;
    private Combo smtpHostValidCombo;
    private List mailDestinationList;
    private Text mailFromText;
    private Text destinationText;
    private Text mailSendGuardTimeText;
    private Button smtpHostAddButton;
    private Button smtpHostDeleteButton;
    private Button mailFromEditButton;
    private Button destinationAddButton;
    private Button destinationDeleteButton;
    private Combo alarmLevelCombo;
    private Button messageFilterCheckButton;
    private Text mailCheckStringText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.mailprop = this.info.getMailPropertyList();
        this.mailPropList = this.info.getMailPropertyArrayList();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Mail send guard time (sec)");
        label.setLayoutData((Object)new GridData());
        this.mailSendGuardTimeText = new Text(composite, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.mailSendGuardTimeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("SMTP Host");
        label.setLayoutData((Object)new GridData());
        this.smtpHostCombo = new Combo(composite, 4);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.smtpHostCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Valid");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.smtpHostValidCombo = new Combo(composite, 12);
        this.smtpHostValidCombo.add(MAIL_SEND_ON);
        this.smtpHostValidCombo.add(MAIL_SEND_OFF);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 80;
        this.smtpHostValidCombo.setLayoutData((Object)gridData);
        this.smtpHostAddButton = new Button(composite, 0);
        this.smtpHostAddButton.setText("SMTP Host Add");
        this.smtpHostAddButton.setLayoutData((Object)new GridData());
        this.smtpHostDeleteButton = new Button(composite, 0);
        this.smtpHostDeleteButton.setText("SMTP Host Delete");
        this.smtpHostDeleteButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("From");
        label.setLayoutData((Object)new GridData());
        this.mailFromText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.mailFromText.setLayoutData((Object)gridData);
        this.mailFromEditButton = new Button(composite, 0);
        this.mailFromEditButton.setText("From Edit");
        this.mailFromEditButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Destination list");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.mailDestinationList = new List(composite, 2564);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.mailDestinationList.getItemHeight() * 8;
        this.mailDestinationList.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(4, false);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        this.destinationAddButton = new Button(composite2, 0);
        this.destinationAddButton.setText("Add");
        this.destinationAddButton.setLayoutData((Object)new GridData());
        this.destinationDeleteButton = new Button(composite2, 0);
        this.destinationDeleteButton.setText("Delete");
        this.destinationDeleteButton.setLayoutData((Object)new GridData());
        label = new Label(composite2, 0);
        label.setText("Destination");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.destinationText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.destinationText.setLayoutData((Object)gridData);
        GridLayout gridLayout3 = new GridLayout(4, false);
        Composite composite3 = new Composite(parent, 0);
        composite3.setLayoutData((Object)new GridData(256));
        composite3.setLayout((Layout)gridLayout3);
        label = new Label(composite3, 0);
        label.setText("Alarm level filter");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmLevelCombo = new Combo(composite3, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.alarmLevelCombo.setLayoutData((Object)gridData);
        this.alarmLevelCombo.add("INFO");
        this.alarmLevelCombo.add("WARNING");
        this.alarmLevelCombo.add("ERROR");
        this.alarmLevelCombo.select(0);
        label = new Label(composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.messageFilterCheckButton = new Button(composite3, 32);
        this.messageFilterCheckButton.setText("Message filter");
        this.mailCheckStringText = new Text(composite3, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.mailCheckStringText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.setListener();
        this.setShowTextData(0);
        return composite;
    }

    private void setListener() {
        this.smtpHostAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String smtpHost = MailSendPreferencePage.this.smtpHostCombo.getText();
                String[] check = MailSendPreferencePage.this.smtpHostCombo.getItems();
                int i = 0;
                while (i < check.length) {
                    if (check[i].equals(smtpHost)) {
                        MessageDialog.openError((Shell)MailSendPreferencePage.this.getShell(), (String)"Error", (String)("Already SMTP Host = " + smtpHost));
                        return;
                    }
                    ++i;
                }
                MailProperty addmailProp = new MailProperty();
                addmailProp.setSmtpHost(smtpHost);
                addmailProp.setFrom(MailSendPreferencePage.this.mailFromText.getText());
                addmailProp.setMailSendFlag(MailSendPreferencePage.MAIL_SEND_OFF);
                MailSendPreferencePage.this.mailPropList.add(addmailProp);
                MailSendPreferencePage.this.info.setMailPropertyArrayList(MailSendPreferencePage.this.mailPropList);
                MailSendPreferencePage.this.mailprop = MailSendPreferencePage.this.info.getMailPropertyList();
                MailSendPreferencePage.this.smtpHostCombo.add(smtpHost);
                MailSendPreferencePage.this.setShowTextData(MailSendPreferencePage.this.smtpHostCombo.getItemCount() - 1);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.smtpHostDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String smtpHost = MailSendPreferencePage.this.smtpHostCombo.getText();
                if (MessageDialog.openQuestion((Shell)MailSendPreferencePage.this.getShell(), (String)"Confirm", (String)("Remove " + smtpHost + " ?"))) {
                    MailSendPreferencePage.this.mailPropList.clear();
                    MailSendPreferencePage.this.smtpHostCombo.removeAll();
                    int i = 0;
                    while (i < MailSendPreferencePage.this.mailprop.length) {
                        if (MailSendPreferencePage.this.mailprop[i].getSmtpHost().equals(smtpHost)) {
                            logger.info("SMTP host delete : " + smtpHost);
                        } else {
                            MailSendPreferencePage.this.mailPropList.add(MailSendPreferencePage.this.mailprop[i]);
                            MailSendPreferencePage.this.smtpHostCombo.add(MailSendPreferencePage.this.mailprop[i].getSmtpHost());
                        }
                        ++i;
                    }
                    MailSendPreferencePage.this.info.setMailPropertyArrayList(MailSendPreferencePage.this.mailPropList);
                    MailSendPreferencePage.this.mailprop = MailSendPreferencePage.this.info.getMailPropertyList();
                    MailSendPreferencePage.this.setShowTextData(0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.smtpHostCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailSendPreferencePage.this.smtpHostSelectIndex = MailSendPreferencePage.this.smtpHostCombo.getSelectionIndex();
                if (MailSendPreferencePage.this.smtpHostSelectIndex >= 0) {
                    MailSendPreferencePage.this.setShowTextData(MailSendPreferencePage.this.smtpHostSelectIndex);
                }
            }
        });
        this.smtpHostValidCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailSendPreferencePage.this.mailprop[MailSendPreferencePage.this.smtpHostSelectIndex].setMailSendFlag(MailSendPreferencePage.this.smtpHostValidCombo.getText());
                MailSendPreferencePage.this.info.setMailPropertyList(MailSendPreferencePage.this.mailprop);
            }
        });
        this.mailDestinationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MailSendPreferencePage.this.mailDestinationList.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                MailSendPreferencePage.this.destinationText.setText(MailSendPreferencePage.this.mailDestinationList.getItem(index));
            }
        });
        this.destinationAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String detination = MailSendPreferencePage.this.destinationText.getText();
                int formCheck0 = detination.indexOf("@");
                if (formCheck0 < 0) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Format error at mail address = " + detination));
                    return;
                }
                String[] check = MailSendPreferencePage.this.mailDestinationList.getItems();
                int i = 0;
                while (i < check.length) {
                    if (check[i].equals(detination)) {
                        MessageDialog.openError((Shell)MailSendPreferencePage.this.getShell(), (String)"Error", (String)("Already To mail address = " + detination));
                        return;
                    }
                    ++i;
                }
                MailSendPreferencePage.this.mailprop[MailSendPreferencePage.this.smtpHostSelectIndex].setTo(detination);
                MailSendPreferencePage.this.mailDestinationList.add(detination);
                MailSendPreferencePage.this.info.setMailPropertyList(MailSendPreferencePage.this.mailprop);
                MailSendPreferencePage.this.destinationText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.destinationDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String detination = MailSendPreferencePage.this.destinationText.getText();
                if (MessageDialog.openQuestion((Shell)MailSendPreferencePage.this.getShell(), (String)"Confirm", (String)("Remove " + detination + " ?"))) {
                    String[] check = MailSendPreferencePage.this.mailDestinationList.getItems();
                    int i = 0;
                    while (i < check.length) {
                        if (check[i].equals(detination)) {
                            MailSendPreferencePage.this.mailDestinationList.remove(i);
                        }
                        ++i;
                    }
                    String[] updateToList = MailSendPreferencePage.this.mailDestinationList.getItems();
                    MailSendPreferencePage.this.mailprop[MailSendPreferencePage.this.smtpHostSelectIndex].setTo(updateToList);
                    MailSendPreferencePage.this.info.setMailPropertyList(MailSendPreferencePage.this.mailprop);
                    MailSendPreferencePage.this.destinationText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.mailFromEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String fromString = MailSendPreferencePage.this.mailFromText.getText();
                int formCheck0 = fromString.indexOf("@");
                if (formCheck0 < 0) {
                    MessageDialog.openError((Shell)MailSendPreferencePage.this.getShell(), (String)"Error", (String)("Format error at mail address = " + fromString));
                    return;
                }
                MailSendPreferencePage.this.mailprop[MailSendPreferencePage.this.smtpHostSelectIndex].setFrom(fromString);
                MailSendPreferencePage.this.info.setMailPropertyList(MailSendPreferencePage.this.mailprop);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.messageFilterCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Button bChk = (Button)event.widget;
                if (bChk.getSelection()) {
                    MailSendPreferencePage.this.mailCheckStringText.setEnabled(true);
                } else {
                    MailSendPreferencePage.this.mailCheckStringText.setEnabled(false);
                }
            }
        });
    }

    private void setShowTextData(int index) {
        this.smtpHostCombo.removeAll();
        this.mailDestinationList.removeAll();
        this.mailSendGuardTimeText.setText(this.info.getMailGuardTime());
        int i = 0;
        while (i < this.mailprop.length) {
            this.smtpHostCombo.add(this.mailprop[i].getSmtpHost());
            ++i;
        }
        this.smtpHostCombo.select(index);
        if (this.mailprop[index].getMailSendFlag().equals(MAIL_SEND_ON)) {
            this.smtpHostValidCombo.select(0);
        } else {
            this.smtpHostValidCombo.select(1);
        }
        this.mailFromText.setText(this.mailprop[index].getFrom());
        ArrayList mailToList = this.mailprop[index].getToList();
        int i2 = 0;
        while (i2 < mailToList.size()) {
            this.mailDestinationList.add((String)mailToList.get(i2));
            ++i2;
        }
        this.alarmLevelCombo.setText(this.info.getMailFilterErrorLevel());
        this.messageFilterCheckButton.setSelection(this.info.isMailFilterStringFlag());
        this.mailCheckStringText.setText(this.info.getMailFilterString());
        if (this.messageFilterCheckButton.getSelection()) {
            this.mailCheckStringText.setEnabled(true);
        } else {
            this.mailCheckStringText.setEnabled(false);
        }
    }

    protected void performDefaults() {
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.mailprop = this.info.getMailPropertyList();
        this.mailPropList = this.info.getMailPropertyArrayList();
        this.setShowTextData(0);
    }

    public boolean performOk() {
        this.info.setMailGuardTime(this.mailSendGuardTimeText.getText());
        this.info.setMailPropertyList(this.mailprop);
        this.info.setMailFilterErrorLevel(this.alarmLevelCombo.getText());
        this.info.setMailFilterStringFlag(this.messageFilterCheckButton.getSelection());
        this.info.setMailFilterString(this.mailCheckStringText.getText());
        MailSendFilter.getInstance().setMessageFilterString(this.messageFilterCheckButton.getSelection(), this.alarmLevelCombo.getText(), this.mailCheckStringText.getText());
        this.saveResourceXMLInfo(this.info);
        return super.performOk();
    }
}

