/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;

public class DatabaseCheck {
    private static final int PHASE1_NO = 0;
    private static final int PHASE2_NO = 1;
    private static final int PHASE3_NO = 2;
    private static final int PHASE_COUNT = 3;
    private static Logger logger = null;
    private static final String PHASE1_OK_DESCRIPTION = "Phase 1 OK";
    private static final String PHASE2_OK_DESCRIPTION = "Phase 2 OK";
    private static final String PHASE3_OK_DESCRIPTION = "Phase 3 OK";
    private final String ipAddress;
    private final String databaseName;
    private String[] checkResult = new String[3];

    public DatabaseCheck(String ipAddress, String paraDatabaseName) {
        logger = Logger.getLogger(this.getClass().getName());
        this.ipAddress = ipAddress;
        this.databaseName = paraDatabaseName;
    }

    public String[] checkDatabase(String jdbcdriver, String url, String username, String password, String checkSQL, boolean isQuery, boolean isDriverCheck, boolean isTest) throws Exception {
        AlarmMessageMake message;
        logger.info("Database Test start : " + this.databaseName);
        logger.info("jdbcdriver : " + jdbcdriver);
        logger.info("url : " + url);
        logger.info("username : " + username);
        logger.info("password : " + password);
        logger.info("SQL : " + checkSQL);
        this.checkResult[0] = "";
        this.checkResult[1] = "";
        this.checkResult[2] = "";
        this.checkResult = this.checkPhase1(jdbcdriver, isTest);
        if (!this.checkResult[0].equals(PHASE1_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        if (isDriverCheck) {
            return this.checkResult;
        }
        this.checkResult = this.checkPhase2(url, username, password, isTest);
        if (!this.checkResult[1].equals(PHASE2_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        if (AlarmRecovery.getInstance().isOccurredAlarmId(this.ipAddress, "40")) {
            message = AlarmMessageMake.getInstance();
            message.setRecoveryDatabaseConnectionError(this.ipAddress, "URL=" + url);
        }
        this.checkResult = this.checkPhase3(url, username, password, checkSQL, isQuery, isTest);
        if (!this.checkResult[2].equals(PHASE3_OK_DESCRIPTION)) {
            return this.checkResult;
        }
        if (AlarmRecovery.getInstance().isOccurredAlarmId(this.ipAddress, "42")) {
            message = AlarmMessageMake.getInstance();
            message.setRecoveryDatabaseSQLError(this.ipAddress, "URL=" + url + " SQL=" + checkSQL);
        }
        return this.checkResult;
    }

    private String[] checkPhase1(String jdbcdriver, boolean isTest) throws Exception {
        try {
            if (this.databaseName.equals("Embedded Derby")) {
                ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(false);
            }
            Class.forName(jdbcdriver).newInstance();
            if (this.databaseName.equals("Embedded Derby")) {
                ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(true);
            }
            this.checkResult[0] = PHASE1_OK_DESCRIPTION;
            logger.info(this.checkResult[0]);
        }
        catch (ExceptionInInitializerError e) {
            this.checkResult[0] = "ExceptionInInitializerError: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            if (isTest) {
                throw new DatabaseConnectionException(this.checkResult[0]);
            }
            return this.checkResult;
        }
        catch (InstantiationException e) {
            this.checkResult[0] = "InstantiationException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            if (isTest) {
                throw new DatabaseConnectionException(this.checkResult[0]);
            }
            return this.checkResult;
        }
        catch (IllegalAccessException e) {
            this.checkResult[0] = "IllegalAccessException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            if (isTest) {
                throw new DatabaseConnectionException(this.checkResult[0]);
            }
            return this.checkResult;
        }
        catch (ClassNotFoundException e) {
            this.checkResult[0] = "ClassNotFoundException: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            if (isTest) {
                throw new DatabaseConnectionException(this.checkResult[0]);
            }
            return this.checkResult;
        }
        catch (NoClassDefFoundError e) {
            this.checkResult[0] = "NoClassDefFoundError: " + e.getMessage();
            logger.warning(this.checkResult[1]);
            if (isTest) {
                throw new DatabaseConnectionException(this.checkResult[0]);
            }
            return this.checkResult;
        }
        return this.checkResult;
    }

    private String[] checkPhase2(String url, String username, String password, boolean isTest) {
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                con = DriverManager.getConnection(url, username, password);
                stmt = con.createStatement();
                this.checkResult[1] = PHASE2_OK_DESCRIPTION;
                logger.info(this.checkResult[1]);
            }
            catch (SQLException e1) {
                this.checkResult[1] = e1.getNextException() != null ? "SQLException: " + e1.getMessage() + " Next exception: " + e1.getNextException() : "SQLException: " + e1.getMessage();
                logger.warning("SQLException URL = " + url + " : User = " + username + " : Password = " + password);
                logger.warning(this.checkResult[1]);
                if (!isTest) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setDatabaseConnectionError(this.ipAddress, "SQLException URL = " + url);
                }
                String[] stringArray = this.checkResult;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    stmt = null;
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stringArray;
            }
            catch (NoClassDefFoundError e1) {
                String[] stringArray;
                block31: {
                    this.checkResult[1] = "NoClassDefFoundError: " + e1.getMessage();
                    logger.warning("NoClassDefFoundError URL = " + url + " : User = " + username + " : Password = " + password);
                    logger.warning(this.checkResult[1]);
                    if (!isTest) {
                        AlarmMessageMake message = AlarmMessageMake.getInstance();
                        message.setDatabaseConnectionError(this.ipAddress, "NoClassDefFoundError URL = " + url);
                    }
                    stringArray = this.checkResult;
                    if (stmt == null) break block31;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    stmt = null;
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stringArray;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return this.checkResult;
    }

    private String[] checkPhase3(String url, String username, String password, String checkSQL, boolean isQuery, boolean isTest) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        int result = 0;
        logger.info("Database Kind : " + this.databaseName);
        try {
            try {
                con = !this.databaseName.equals("Embedded Derby") ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
                stmt = con.createStatement();
                if (isQuery) {
                    rs = stmt.executeQuery(checkSQL);
                } else {
                    result = stmt.executeUpdate(checkSQL);
                    logger.info(String.valueOf(this.checkResult[2]) + " result code = " + result);
                }
                this.checkResult[2] = PHASE3_OK_DESCRIPTION;
            }
            catch (SQLException e2) {
                this.checkResult[2] = "SQLException: " + e2.getMessage() + " SQL : " + checkSQL;
                logger.warning("SQL : " + checkSQL);
                logger.warning(this.checkResult[2]);
                if (!isTest) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setDatabaseSQLError(this.ipAddress, "SQLException URL = " + url + " SQL = " + checkSQL);
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return this.checkResult;
    }
}

