/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.snmpmanager.process.AbstractManagerMessageProcessingSubsystem;
import netjfwatcher.engine.snmpmanager.process.SnmpRequestIDManager;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public abstract class AbstractManagerV1V2MP
extends AbstractManagerMessageProcessingSubsystem {
    private static Logger logger;

    public AbstractManagerV1V2MP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public abstract void setManagerMP(DatagramSocket var1, InetAddress var2, String var3) throws SnmpConfigurationException, SnmpV3ConfigurationException;

    public SnmpVarBindList getProcess(byte code, String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException, SnmpV3ConfigurationException, NoRouteToHostException, SocketTimeoutException, IOException {
        SnmpVarBindList returnVarBindList = null;
        switch (code) {
            case -96: {
                returnVarBindList = this.getMIBEntry(requestOID);
                break;
            }
            case -95: {
                returnVarBindList = this.getNextMIBEntry(requestOID);
                break;
            }
            default: {
                logger.warning("Undefined SNMP Command code : " + code);
            }
        }
        return returnVarBindList;
    }

    public SnmpVarBindList setProcess(byte code, String requestOID, AbstractSnmpObject newValue) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpV3AuthAbortException, SnmpSetException, SnmpV3ConfigurationException, SnmpBadValueException, NoRouteToHostException, SocketTimeoutException, IOException {
        SnmpVarBindList returnVarBindList = null;
        switch (code) {
            case -93: {
                returnVarBindList = this.setMIBEntry(requestOID, newValue);
                break;
            }
            default: {
                logger.warning("Illegal Command code " + code);
            }
        }
        return returnVarBindList;
    }

    public SnmpVarBindList getMIBEntry(String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpBadValueException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, SnmpErrorStatusException, NoRouteToHostException, SocketTimeoutException, IOException {
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        SnmpVarBindList retrievedVars = null;
        SnmpMessage message = null;
        try {
            message = this.messageSendInstance.createSNMPMessage(this.version, this.community, requestID, requestOID, (byte)-96);
            byte[] messageEncoding = message.getBEREncoding();
            this.dSocket.connect(this.targetAddress, this.snmpPort);
            retrievedVars = this.sendAndReceive(requestID, requestOID, messageEncoding, this.dSocket);
        }
        finally {
            this.dSocket.disconnect();
        }
        return retrievedVars;
    }

    public SnmpVarBindList getNextMIBEntry(String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpBadValueException, SnmpV3ConfigurationException, NoRouteToHostException, SocketTimeoutException, IOException {
        SnmpVarBindList retrievedVars = null;
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        try {
            SnmpMessage message = this.messageSendInstance.createSNMPMessage(this.version, this.community, requestID, requestOID, (byte)-95);
            byte[] messageEncoding = message.getBEREncoding();
            this.dSocket.connect(this.targetAddress, this.snmpPort);
            retrievedVars = this.sendAndReceive(requestID, requestOID, messageEncoding, this.dSocket);
        }
        finally {
            this.dSocket.disconnect();
        }
        return retrievedVars;
    }

    public SnmpVarBindList setMIBEntry(String requestOID, AbstractSnmpObject newValue) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpSetException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, NoRouteToHostException, SocketTimeoutException, IOException {
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        int errorStatus = 0;
        int errorIndex = 0;
        SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(requestOID);
        SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, newValue);
        SnmpSequence varList = new SnmpSequence();
        varList.addSNMPObject(nextPair);
        SnmpPDU pdu = new SnmpPDU(-93, requestID, errorStatus, errorIndex, varList);
        SnmpVarBindList receiveVarBindList = null;
        SnmpMessage message = new SnmpMessage(this.version, this.community, pdu);
        this.dSocket.connect(this.targetAddress, this.snmpPort);
        byte[] messageEncoding = message.getBEREncoding();
        receiveVarBindList = this.sendAndReceive(requestID, requestOID, messageEncoding, this.dSocket);
        return receiveVarBindList;
    }
}

