/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpmanager.SnmpManagerQueue;

public class SnmpManagerMessageReceive
extends DataStringDisplay {
    public static final int SNMP_V3_RECEIVE_MAXSIZE = 8196;
    private static Logger logger;
    private InetAddress hostAddress;
    private DatagramSocket dSocket;
    private SnmpMessage receivedSNMPMessage = new SnmpMessage();
    private SnmpVarBindList retrievedVars = new SnmpVarBindList();
    private DateFormat simpleDateformat = new SimpleDateFormat("HH:mm:ss");

    public SnmpManagerMessageReceive() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setSnmpReceiveSocket(InetAddress hostAddress, DatagramSocket dSocket) {
        this.dSocket = dSocket;
        this.hostAddress = hostAddress;
    }

    public SnmpVarBindList parseReceiveData(int requestID, String requestOID, DatagramSocket dSocket) throws SnmpUnmuchRequestIDException, SnmpErrorStatusException, SnmpBadValueException, SocketTimeoutException, IOException {
        byte[] receiveDataByte = null;
        DatagramPacket inPacket = new DatagramPacket(new byte[8196], 8196);
        dSocket.receive(inPacket);
        receiveDataByte = inPacket.getData();
        logger.fine("Receive data : " + this.hexBytetoString(receiveDataByte, inPacket.getLength()));
        Date date = Calendar.getInstance().getTime();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive date : " + this.simpleDateformat.format(date) + " : Data length : " + inPacket.getLength() + "Byte");
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(receiveDataByte, inPacket.getLength()));
        SnmpPDU receivedPDU = null;
        SNMPTLV nextTLV = null;
        nextTLV = this.receivedSNMPMessage.extractNextTLV(receiveDataByte, 0);
        this.receivedSNMPMessage.setTLV(nextTLV);
        receivedPDU = this.parseSNMPMessage(this.receivedSNMPMessage);
        this.retrievedVars = this.parsePDU(receivedPDU, requestID, requestOID);
        return this.retrievedVars;
    }

    public SnmpPDU parseSNMPMessage(SnmpMessage receivedSNMPMessage) throws SnmpBadValueException {
        SnmpPDU receivedPDU = null;
        try {
            byte[] versionByte = receivedSNMPMessage.getVersion();
            byte version = versionByte[0];
            byte[] communityByte = receivedSNMPMessage.getCommunity();
            String snmpVersion = this.getVesionDiscrip(version);
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Version : " + version + " (" + snmpVersion + ")");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Community : " + SnmpManagerMessageReceive.bytetoChar(communityByte));
            receivedPDU = receivedSNMPMessage.getPDU();
        }
        catch (SnmpBadValueException e) {
            e.printStackTrace();
            logger.warning("Receive PDU parse error : " + e.getMessage());
            throw new SnmpBadValueException("Receive PDU parse error");
        }
        if (receivedPDU == null) {
            logger.warning("Receive PDU parse error for PDU null");
            throw new SnmpBadValueException("Receive PDU parse error for PDU null");
        }
        return receivedPDU;
    }

    public SnmpVarBindList parsePDU(SnmpPDU receivedPDU, int requestID, String requestOID) throws SnmpUnmuchRequestIDException, SnmpErrorStatusException {
        byte command = receivedPDU.getPDUType();
        String snmpCode = this.getCommandDescription(command);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Command : " + this.hexByte(command) + " (" + snmpCode + ")");
        SnmpVarBindList retrievedVars = new SnmpVarBindList();
        if (receivedPDU.getRequestID() != requestID) {
            SnmpSequence varList = receivedPDU.getVarBindList();
            SnmpStatisticsManager.getInstance().addSnmpUnmuchRequestID(this.hostAddress.getHostAddress());
            varList = receivedPDU.getVarBindList();
            SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(0);
            SnmpObjectIdentifier newObjectIdentifier = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
            logger.warning("Unmuch Request ID : receive ID=" + receivedPDU.getRequestID() + " expected ID=" + requestID + " Address=" + this.hostAddress.toString() + " receive OID=" + newObjectIdentifier + " expected OID=" + requestOID);
            throw new SnmpUnmuchRequestIDException("Unmuch Request ID : receive ID=" + receivedPDU.getRequestID() + " expected ID=" + requestID + " Address=" + this.hostAddress.toString());
        }
        this.checkErrorStatus(receivedPDU, requestOID);
        SnmpSequence varList = receivedPDU.getVarBindList();
        SnmpSequence receiveSnmpPair = (SnmpSequence)varList.getSNMPObjectAt(0);
        retrievedVars.clearSNMPObjectList();
        retrievedVars.addSNMPObject(receiveSnmpPair);
        SnmpObjectIdentifier responseOID = (SnmpObjectIdentifier)receiveSnmpPair.getSNMPObjectAt(0);
        AbstractSnmpObject responseValue = receiveSnmpPair.getSNMPObjectAt(1);
        String responseTypeString = responseValue.getTagCode();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("OID : " + responseOID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Value : " + responseValue);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Type : " + responseTypeString);
        return retrievedVars;
    }

    private void checkErrorStatus(SnmpPDU pdu, String requestOID) throws SnmpErrorStatusException {
        if (pdu.getErrorStatus() != 0) {
            switch (pdu.getErrorStatus()) {
                case -1: {
                    String msg = "Format error " + requestOID + ".";
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 1: {
                    String msg = "Value supplied for OID " + requestOID + " too big.";
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 2: {
                    String msg = "OID " + requestOID + " nosuchname.";
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 3: {
                    String msg = "Bad value supplied for OID " + requestOID + ".";
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 4: {
                    String msg = "OID " + requestOID + " read-only.";
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 5: {
                    String msg = "GenError OID " + requestOID;
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPErrorStatus(this.hostAddress.getHostAddress(), msg);
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning(msg);
                    throw new SnmpErrorStatusException(msg);
                }
                case 6: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("noAccess OID " + requestOID);
                    throw new SnmpErrorStatusException("noAccess OID " + requestOID);
                }
                case 7: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("wrongType OID " + requestOID);
                    throw new SnmpErrorStatusException("wrongType OID " + requestOID);
                }
                case 8: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("wrongLength OID " + requestOID);
                    throw new SnmpErrorStatusException("wrongLength OID " + requestOID);
                }
                case 10: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("wrongValue OID " + requestOID);
                    throw new SnmpErrorStatusException("wrongValue OID " + requestOID);
                }
                case 11: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("noCreation OID " + requestOID);
                    throw new SnmpErrorStatusException("noCreation OID " + requestOID);
                }
                case 12: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("inconsistentValue OID " + requestOID);
                    throw new SnmpErrorStatusException("inconsistentValue OID " + requestOID);
                }
                case 13: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("resourceUnavailable OID " + requestOID);
                    throw new SnmpErrorStatusException("resourceUnavailable OID " + requestOID);
                }
                case 14: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("commitFailed OID " + requestOID);
                    throw new SnmpErrorStatusException("commitFailed OID " + requestOID);
                }
                case 15: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("undoFailed OID " + requestOID);
                    throw new SnmpErrorStatusException("undoFailed OID " + requestOID);
                }
                case 16: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("authorizationError OID " + requestOID);
                    throw new SnmpErrorStatusException("authorizationError OID " + requestOID);
                }
                case 17: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("noWritable OID " + requestOID);
                    throw new SnmpErrorStatusException("noWritable OID " + requestOID);
                }
                case 18: {
                    SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
                    logger.warning("inconsistentName OID " + requestOID);
                    throw new SnmpErrorStatusException("inconsistentName OID " + requestOID);
                }
            }
            SnmpStatisticsManager.getInstance().addSnmpErrorStatus(this.hostAddress.getHostAddress());
            logger.warning("Error setting OID " + requestOID + " error status(" + pdu.getErrorStatus() + ").");
            throw new SnmpErrorStatusException("Error setting OID " + requestOID + " error status(" + pdu.getErrorStatus() + ").");
        }
    }

    private String getVesionDiscrip(int version) {
        String snmpVersion = "";
        switch (version) {
            case 0: {
                snmpVersion = "SnmpV1";
                break;
            }
            case 1: {
                snmpVersion = "SnmpV2c";
                break;
            }
            case 3: {
                snmpVersion = "SnmpV3";
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
            }
        }
        return snmpVersion;
    }

    private String getCommandDescription(byte code) {
        String snmpCode = "";
        switch (code) {
            case -96: {
                snmpCode = "GetRequest";
                break;
            }
            case -95: {
                snmpCode = "GetNextRequest";
                break;
            }
            case -93: {
                snmpCode = "SetRequest";
                break;
            }
            case -94: {
                snmpCode = "GetResponse";
                break;
            }
            default: {
                snmpCode = "Unknown";
                logger.warning("Undefined SNMP Command code : " + code);
            }
        }
        return snmpCode;
    }
}

