/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.nodedetect.NodeDetectTimerProcessor;
import netjfwatcher.engine.view.editorpart.nodedetect.ThreadAutoNodeDetect;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;

public class EditorAutoNodeDetect
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = "Node Discovery";
    public static final int DATE_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 500};
    private static final int IPADDRESS_LENGTH = 4;
    private static final int HORIZONTAL_SPAN4 = 4;
    private static final int NODE_DISCOVERY_PROCESSOR_TIMER = 1000;
    private static final String INITIAL_NODE_KIND = "Router";
    private static final String INITIAL_PING_TIMEOUT = "3";
    private static final String INITIAL_PERIOD_TIME = "180";
    private static final int INITIAL_PERIOD_TIME_DATA = 60;
    private static Logger logger;
    private Text snmpROCommunityText;
    private Text startIPAddressText;
    private Text endIPAddressText;
    private Text pingTimeoutText;
    private Combo snmpVersionCombo;
    private Text chekNodeCountText;
    private Text ipNodeCountText;
    private Text snmpNodeCountText;
    private Button startButton;
    private Button cancelButton;
    private Combo nodeKindCombo;
    private Text nodeGroupText;
    private Text pingPeriodText;
    private Text snmpPeriodText;
    private Color textBackColor;
    private ArrayList nodeDiscoveryIPAddressList = new ArrayList();
    private Display display;
    private NodeDetectTimerProcessor timerProcessor;

    public EditorAutoNodeDetect() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = WHITE_COLOR;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        GridLayout gridLayout2 = new GridLayout(4, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        Group composite3 = new Group(composite0, 0);
        composite3.setText("Node Discovery Status");
        composite3.setLayout((Layout)new GridLayout(4, false));
        composite3.setLayoutData((Object)new GridData());
        Group composite4 = new Group(composite0, 0);
        composite4.setText("Node Register Information");
        composite4.setLayout((Layout)new GridLayout(4, false));
        composite4.setLayoutData((Object)new GridData());
        this.startButton = new Button(composite1, 0);
        this.startButton.setText("Start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.startButton.setLayoutData((Object)gridData);
        this.cancelButton = new Button(composite1, 0);
        this.cancelButton.setText("Cancel");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.cancelButton.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Start IP Address");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.startIPAddressText = new Text(composite2, 2048);
        this.startIPAddressText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.startIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("End IP Address");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.endIPAddressText = new Text(composite2, 2048);
        this.endIPAddressText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.endIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("IP Node Check Timeout(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingTimeoutText = new Text(composite2, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SNMP RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpROCommunityText = new Text(composite2, 2048);
        this.snmpROCommunityText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpROCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SNMP Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpVersionCombo = new Combo(composite2, 12);
        this.snmpVersionCombo.add("SNMPV1");
        this.snmpVersionCombo.add("SNMPV2C");
        this.snmpVersionCombo.select(0);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("Check Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.chekNodeCountText = new Text((Composite)composite3, 133128);
        this.chekNodeCountText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.chekNodeCountText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("IP Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.ipNodeCountText = new Text((Composite)composite3, 133128);
        this.ipNodeCountText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.ipNodeCountText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("SNMP Node Count");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpNodeCountText = new Text((Composite)composite3, 133128);
        this.snmpNodeCountText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpNodeCountText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.setNodeKind((Composite)composite4);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeKindCombo.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("Node Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeGroupText = new Text((Composite)composite4, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeGroupText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("Ping Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingPeriodText = new Text((Composite)composite4, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingPeriodText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("SNMP Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpPeriodText = new Text((Composite)composite4, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpPeriodText.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)composite4, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setTexInitial();
        this.startButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.startIPAddressText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                EditorAutoNodeDetect.this.setIPAddress(EditorAutoNodeDetect.this.startIPAddressText.getText());
            }
        });
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorAutoNodeDetect.this.startButton.setEnabled(false);
                EditorAutoNodeDetect.this.cancelButton.setEnabled(true);
                EditorAutoNodeDetect.this.chekNodeCountText.setText("");
                EditorAutoNodeDetect.this.ipNodeCountText.setText("");
                EditorAutoNodeDetect.this.snmpNodeCountText.setText("");
                EditorAutoNodeDetect.this.getIPAddressList();
                EditorAutoNodeDetect.this.chekNodeCountText.setText("0/" + Integer.toString(EditorAutoNodeDetect.this.nodeDiscoveryIPAddressList.size()));
                String ipTimeout = EditorAutoNodeDetect.this.pingTimeoutText.getText();
                int timeout = 1;
                try {
                    timeout = Integer.parseInt(ipTimeout);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error IP Node Check Timeout : " + EditorAutoNodeDetect.this.pingTimeoutText));
                    EditorAutoNodeDetect.this.pingTimeoutText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                if (timeout < 1) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error IP Node Check Timeout >= 1(Sec) : " + EditorAutoNodeDetect.this.pingTimeoutText));
                    EditorAutoNodeDetect.this.pingTimeoutText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                String pingPeriodTime = EditorAutoNodeDetect.this.pingPeriodText.getText();
                int pingPeriod = 60;
                try {
                    pingPeriod = Integer.parseInt(pingPeriodTime);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error Ping Period : " + EditorAutoNodeDetect.this.pingPeriodText));
                    EditorAutoNodeDetect.this.pingPeriodText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                if (pingPeriod < 60) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error Ping Period >= 60(Sec) : " + pingPeriod));
                    EditorAutoNodeDetect.this.pingPeriodText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                String snmpPeriodTime = EditorAutoNodeDetect.this.snmpPeriodText.getText();
                int snmpPeriod = 60;
                try {
                    snmpPeriod = Integer.parseInt(snmpPeriodTime);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error SNMP Period : " + EditorAutoNodeDetect.this.snmpPeriodText));
                    EditorAutoNodeDetect.this.snmpPeriodText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                if (snmpPeriod < 60) {
                    MessageDialog.openError((Shell)EditorAutoNodeDetect.this.getEditorSite().getShell(), (String)"Error", (String)("Error SNMP Period >= 60(Sec) : " + snmpPeriod));
                    EditorAutoNodeDetect.this.snmpPeriodText.setFocus();
                    EditorAutoNodeDetect.this.startButton.setEnabled(true);
                    EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                    return;
                }
                int snmpVersion = EditorAutoNodeDetect.this.snmpVersionCombo.getSelectionIndex();
                String ipNodeCheckTimeout = Integer.toString(timeout * 1000);
                String snmpROCommunity = EditorAutoNodeDetect.this.snmpROCommunityText.getText();
                String nodeKind = EditorAutoNodeDetect.this.nodeKindCombo.getText();
                String nodeGroup = EditorAutoNodeDetect.this.nodeGroupText.getText();
                ThreadAutoNodeDetect.getInstance().setNodeCheckParam(ipNodeCheckTimeout, snmpVersion, snmpROCommunity);
                ThreadAutoNodeDetect.getInstance().startThread(EditorAutoNodeDetect.this.nodeDiscoveryIPAddressList);
                EditorAutoNodeDetect.this.startNodeDicoveryTimer(nodeKind, nodeGroup, pingPeriodTime, snmpPeriodTime, snmpROCommunity, snmpVersion);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorAutoNodeDetect.this.startButton.setEnabled(true);
                EditorAutoNodeDetect.this.cancelButton.setEnabled(false);
                EditorAutoNodeDetect.this.display.timerExec(-1, (Runnable)EditorAutoNodeDetect.this.timerProcessor);
                ThreadAutoNodeDetect.getInstance().stopThread();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void startNodeDicoveryTimer(String nodeKind, String nodeGroup, String pingPeriod, String snmpPeriod, String snmpROCommunity, int snmpVersion) {
        IEditorSite editorSite = this.getEditorSite();
        NodeDetectTimerProcessor.getInstance().setDisplay(this.display);
        NodeDetectTimerProcessor.getInstance().setText(editorSite, this.chekNodeCountText, this.ipNodeCountText, this.snmpNodeCountText, this.startButton, this.cancelButton);
        NodeDetectTimerProcessor.getInstance().setNodeAddParam(nodeKind, nodeGroup, pingPeriod, snmpPeriod, snmpROCommunity, snmpVersion);
        this.timerProcessor = NodeDetectTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    private void setTexInitial() {
        this.snmpROCommunityText.setText("public");
        this.pingTimeoutText.setText(INITIAL_PING_TIMEOUT);
        this.nodeGroupText.setText("Default Group");
        this.pingPeriodText.setText(INITIAL_PERIOD_TIME);
        this.snmpPeriodText.setText(INITIAL_PERIOD_TIME);
        String localIPAddress = "";
        try {
            localIPAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e4) {
            logger.warning("UnknownHostException : " + e4.getMessage());
        }
        this.setInitialIPAddress(localIPAddress);
    }

    private void setInitialIPAddress(String ipAddress) {
        String[] ipArray = ipAddress.split("[.]");
        if (ipArray.length == 4) {
            String setIPAddress = String.valueOf(ipArray[0]) + "." + ipArray[1] + "." + ipArray[2] + ".";
            this.startIPAddressText.setText(String.valueOf(setIPAddress) + "1");
            if (ipAddress.equals("127.0.0.1")) {
                this.endIPAddressText.setText(String.valueOf(setIPAddress) + "1");
            } else {
                this.endIPAddressText.setText(String.valueOf(setIPAddress) + "254");
            }
        }
    }

    private void setIPAddress(String ipAddress) {
        String[] ipArray = ipAddress.split("[.]");
        if (ipArray.length == 4) {
            String setIPAddress = String.valueOf(ipArray[0]) + "." + ipArray[1] + "." + ipArray[2] + ".";
            if (ipAddress.equals("127.0.0.1")) {
                this.endIPAddressText.setText(String.valueOf(setIPAddress) + "1");
            } else {
                this.endIPAddressText.setText(String.valueOf(setIPAddress) + "254");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getIPAddressList() {
        this.nodeDiscoveryIPAddressList.clear();
        startIPArray = this.startIPAddressText.getText().split("[.]");
        if (startIPArray.length != 4) {
            return;
        }
        endIPArray = this.endIPAddressText.getText().split("[.]");
        if (endIPArray.length != 4) {
            return;
        }
        startCount = 0;
        endCount = 0;
        try {
            startCount = Integer.parseInt(startIPArray[3]);
            endCount = Integer.parseInt(endIPArray[3]);
            if (true) ** GOTO lbl21
        }
        catch (NumberFormatException v0) {
            return;
        }
        do {
            ipAddress = String.valueOf(startIPArray[0]) + "." + startIPArray[1] + "." + startIPArray[2] + "." + Integer.toString(startCount);
            this.nodeDiscoveryIPAddressList.add(ipAddress);
            ++startCount;
lbl21:
            // 2 sources

        } while (startCount <= endCount);
    }

    private void setNodeKind(Composite composite2) {
        Label label = new Label(composite2, 0);
        label.setText("Default Node Kind");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeKindCombo = new Combo(composite2, 12);
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        for (String key : nodeIconMap.keySet()) {
            this.nodeKindCombo.add(key);
        }
        this.nodeKindCombo.setText(INITIAL_NODE_KIND);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }
}

