/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.nodedetect.ThreadAutoNodeDetect;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;

public class NodeDetectTimerProcessor
implements Runnable {
    private static final int TIMER = 1000;
    private static Logger logger;
    private IEditorSite editorSite;
    private String nodeKind = "Router";
    private String nodeGroup;
    private String snmpPeriod;
    private String pingPeriod;
    private String snmpROCommunity;
    private int snmpVersion;
    private Display display;
    private Button startButton;
    private Button cancelButton;
    private Text chekNodeCountText;
    private Text ipNodeCountText;
    private Text snmpNodeCountText;

    private NodeDetectTimerProcessor() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        if (this.editorSite.getPage().isPartVisible(this.editorSite.getPart())) {
            int checkNode = ThreadAutoNodeDetect.getInstance().getPingOKList().size() + ThreadAutoNodeDetect.getInstance().getPingNGList().size();
            int totalNode = ThreadAutoNodeDetect.getInstance().getSnmpNGList().size() + ThreadAutoNodeDetect.getInstance().getSnmpIFNGList().size() + ThreadAutoNodeDetect.getInstance().getSnmpIFOKList().size();
            this.chekNodeCountText.setText(String.valueOf(Integer.toString(checkNode)) + "/" + Integer.toString(ThreadAutoNodeDetect.getInstance().getCheckNodeAddressList().size()));
            this.snmpNodeCountText.setText(Integer.toString(ThreadAutoNodeDetect.getInstance().getSnmpOKList().size()));
            this.ipNodeCountText.setText(Integer.toString(ThreadAutoNodeDetect.getInstance().getPingOKList().size()));
            if (checkNode == ThreadAutoNodeDetect.getInstance().getCheckNodeAddressList().size()) {
                this.chekNodeCountText.setText(String.valueOf(Integer.toString(checkNode)) + "/" + Integer.toString(ThreadAutoNodeDetect.getInstance().getCheckNodeAddressList().size()));
                this.cancelButton.setEnabled(false);
                if (totalNode != 0) {
                    StringBuffer message = new StringBuffer();
                    message.append("Node Register ?" + System.getProperty("line.separator"));
                    message.append(System.getProperty("line.separator"));
                    message.append("IP Node          = " + ThreadAutoNodeDetect.getInstance().getSnmpNGList().size() + System.getProperty("line.separator"));
                    message.append("SNMP Level1 Node = " + ThreadAutoNodeDetect.getInstance().getSnmpIFNGList().size() + System.getProperty("line.separator"));
                    message.append("SNMP Level2 Node = " + ThreadAutoNodeDetect.getInstance().getSnmpIFOKList().size() + System.getProperty("line.separator"));
                    message.append("-------------------------" + System.getProperty("line.separator"));
                    message.append("Total Node       = " + totalNode + System.getProperty("line.separator"));
                    if (MessageDialog.openQuestion((Shell)this.editorSite.getShell(), (String)"Confirm", (String)message.toString())) {
                        ArrayList duplicateAddressList = this.registerNode();
                        if (duplicateAddressList.size() > 0) {
                            StringBuffer message2 = new StringBuffer();
                            message2.append("Already register node count = " + duplicateAddressList.size() + System.getProperty("line.separator"));
                            message2.append(System.getProperty("line.separator"));
                            int ipCount = 0;
                            while (ipCount < duplicateAddressList.size()) {
                                message2.append("Duplicate IP Address = " + (String)duplicateAddressList.get(ipCount) + System.getProperty("line.separator"));
                                ++ipCount;
                            }
                            MessageDialog.openWarning((Shell)this.editorSite.getShell(), (String)"Warning", (String)message2.toString());
                        } else {
                            MessageDialog.openInformation((Shell)this.editorSite.getShell(), (String)"Info", (String)"Node register complete.");
                        }
                    }
                }
                this.startButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
                this.display.timerExec(-1, (Runnable)this);
            } else {
                this.display.timerExec(1000, (Runnable)this);
            }
        } else {
            this.display.timerExec(1000, (Runnable)this);
        }
    }

    public static NodeDetectTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void setNodeAddParam(String nodeKind, String nodeGroup, String pingPeriod, String snmpPeriod, String snmpROCommunity, int snmpVersion) {
        this.snmpPeriod = snmpPeriod;
        this.pingPeriod = pingPeriod;
        this.snmpROCommunity = snmpROCommunity;
        this.snmpVersion = snmpVersion;
        this.nodeKind = nodeKind;
        this.nodeGroup = nodeGroup;
    }

    public void setText(IEditorSite editorSite, Text chekNodeCountText, Text ipNodeCountText, Text snmpNodeCountText, Button startButton, Button cancelButton) {
        this.editorSite = editorSite;
        this.chekNodeCountText = chekNodeCountText;
        this.ipNodeCountText = ipNodeCountText;
        this.snmpNodeCountText = snmpNodeCountText;
        this.startButton = startButton;
        this.cancelButton = cancelButton;
    }

    private ArrayList registerNode() {
        NodeInformation addNodeInfo;
        HashMap nodeMap = this.getNodeList();
        ArrayList<String> dupicateAddressList = new ArrayList<String>();
        ArrayList snmpNGList = ThreadAutoNodeDetect.getInstance().getSnmpNGList();
        ArrayList snmpIFOKList = ThreadAutoNodeDetect.getInstance().getSnmpIFOKList();
        ArrayList snmpIFNGList = ThreadAutoNodeDetect.getInstance().getSnmpIFNGList();
        NodeAdd nodeAddInstance = NodeAdd.getInstance();
        int i = 0;
        while (i < snmpNGList.size()) {
            addNodeInfo = this.createNodeInfo((String)snmpNGList.get(i), this.pingPeriod, "0", "No SNMP", this.snmpVersion, this.snmpROCommunity);
            if (addNodeInfo != null) {
                if (!nodeMap.containsKey((String)snmpNGList.get(i))) {
                    nodeAddInstance.addNode(addNodeInfo, true);
                } else {
                    dupicateAddressList.add((String)snmpNGList.get(i));
                }
            }
            ++i;
        }
        i = 0;
        while (i < snmpIFNGList.size()) {
            addNodeInfo = this.createNodeInfo((String)snmpIFNGList.get(i), this.pingPeriod, this.snmpPeriod, "SNMP Configration", this.snmpVersion, this.snmpROCommunity);
            if (addNodeInfo != null) {
                if (!nodeMap.containsKey((String)snmpIFNGList.get(i))) {
                    nodeAddInstance.addNode(addNodeInfo, true);
                } else {
                    dupicateAddressList.add((String)snmpIFNGList.get(i));
                }
            }
            ++i;
        }
        i = 0;
        while (i < snmpIFOKList.size()) {
            addNodeInfo = this.createNodeInfo((String)snmpIFOKList.get(i), this.pingPeriod, this.snmpPeriod, "SNMP ifOctets", this.snmpVersion, this.snmpROCommunity);
            if (addNodeInfo != null) {
                if (!nodeMap.containsKey((String)snmpIFOKList.get(i))) {
                    nodeAddInstance.addNode(addNodeInfo, true);
                } else {
                    dupicateAddressList.add((String)snmpIFOKList.get(i));
                }
            }
            ++i;
        }
        return dupicateAddressList;
    }

    private NodeInformation createNodeInfo(String ipAddress, String pingPeriod, String snmpPeriod, String snmpLevel, int snmpVersion, String roCommunity) {
        NodeInformation workNodeInfo = new NodeInformation();
        workNodeInfo.setPingPeriod(pingPeriod);
        workNodeInfo.setPingThreshold("4000");
        workNodeInfo.setSnmpPeriod(snmpPeriod);
        workNodeInfo.setHttpPeriod("0");
        workNodeInfo.setHttpTimeout("180000");
        workNodeInfo.setPopPeriod("0");
        workNodeInfo.setPopPort("110");
        workNodeInfo.setPopTimeout("120000");
        workNodeInfo.setSmtpPeriod("0");
        workNodeInfo.setSmtpPort("25");
        workNodeInfo.setSmtpTimeout("120000");
        workNodeInfo.setSmtpCheckPort("25");
        workNodeInfo.setSmtpCheckTimeout("120000");
        workNodeInfo.setPopUser("");
        workNodeInfo.setPopPassword("");
        workNodeInfo.setSmtpSendAddress("");
        workNodeInfo.setSmtpCheckHost("");
        workNodeInfo.setSmtpCheckUser("");
        workNodeInfo.setSmtpCheckPassword("");
        workNodeInfo.setHttpUrl("http://");
        workNodeInfo.setHttpPort("80");
        String nodeName = null;
        try {
            InetAddress host = InetAddress.getByName(ipAddress);
            String addIPAddress = host.getHostAddress();
            workNodeInfo.setIpaddress(addIPAddress);
            nodeName = host.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"UnknownHostException");
            shell.dispose();
            return null;
        }
        workNodeInfo.setNodename(nodeName);
        String engineAddress = "localhost";
        try {
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning("UnknownHostException : " + e.getMessage());
        }
        workNodeInfo.setEngineAddress(engineAddress);
        if (this.nodeGroup != null && !this.nodeGroup.equals("")) {
            workNodeInfo.setGroup(this.nodeGroup);
        } else {
            workNodeInfo.setGroup("Default Group");
        }
        workNodeInfo.setRoCommunity(roCommunity);
        workNodeInfo.setRwCommunity("private");
        switch (snmpVersion) {
            case 0: {
                workNodeInfo.setSnmpVersion("SNMPV1");
                break;
            }
            case 1: {
                workNodeInfo.setSnmpVersion("SNMPV2C");
                break;
            }
            case 2: {
                workNodeInfo.setSnmpVersion("SNMPV3");
                break;
            }
            default: {
                workNodeInfo.setSnmpVersion("SNMPV1");
            }
        }
        if (snmpLevel.equals("No SNMP")) {
            workNodeInfo.setSnmpLevel("0");
        } else if (snmpLevel.equals("SNMP Configration")) {
            workNodeInfo.setSnmpLevel("1");
        } else if (snmpLevel.equals("SNMP ifOctets")) {
            workNodeInfo.setSnmpLevel("2");
        } else if (snmpLevel.equals("SNMP laLoad")) {
            workNodeInfo.setSnmpLevel("3");
        } else if (snmpLevel.equals("SNMP disk")) {
            workNodeInfo.setSnmpLevel("4");
        } else {
            workNodeInfo.setSnmpLevel("0");
        }
        HashMap nodeKindMap = ThreadAutoNodeDetect.getInstance().getNodeKindMap();
        String autoNodeKind = (String)nodeKindMap.get(ipAddress);
        if (autoNodeKind != null) {
            workNodeInfo.setNodeKind(autoNodeKind);
        } else {
            workNodeInfo.setNodeKind(this.nodeKind);
        }
        return workNodeInfo;
    }

    private HashMap getNodeList() {
        ArrayList nodeList = null;
        HashMap<String, NodeInformation> nodeListMap = new HashMap<String, NodeInformation>();
        try {
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            int i = 0;
            while (i < nodeList.size()) {
                NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
                String ipAddress = nodeInfo.getIpaddress();
                nodeListMap.put(ipAddress, nodeInfo);
                ++i;
            }
        }
        catch (SQLException e1) {
            logger.warning("Node List import error " + e1.getMessage());
        }
        catch (Exception e1) {
            logger.warning("Node List import error " + e1.getMessage());
        }
        return nodeListMap;
    }

    /* synthetic */ NodeDetectTimerProcessor(NodeDetectTimerProcessor nodeDetectTimerProcessor) {
        this();
    }

    private static class SingletonResource {
        static final NodeDetectTimerProcessor RESOURCE = new NodeDetectTimerProcessor(null);

        private SingletonResource() {
        }
    }
}

